/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDCharClass;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDRegexProgram;

class XSDRegexVM
implements XSDConstantValues {
    private final XSDRegexProgram program;
    private String value;
    private int len;

    XSDRegexVM(XSDRegexProgram xSDRegexProgram) {
        this.program = xSDRegexProgram;
    }

    static boolean isXMLSpace(char c2) {
        switch (c2) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static boolean isWEsc(char c2) {
        int n2 = 1643118592;
        int n3 = Character.getType(c2);
        if ((n2 & 1 << n3) != 0) {
            return false;
        }
        n2 = 28672;
        if ((n2 & 1 << n3) != 0) {
            return false;
        }
        n2 = 360449;
        return (n2 & 1 << n3) == 0;
    }

    protected int matchNodes(int n2, int n3, int n4) throws XSDException {
        int n5 = n4;
        int n6 = this.len;
        char[] cArray = this.program.instruction;
        XSDCharClass[] xSDCharClassArray = this.program.chClass;
        int n7 = n2;
        block12: while (n7 < n3) {
            char c2 = cArray[n7];
            int n8 = n7 + (short)cArray[n7 + 2];
            int n9 = cArray[n7 + 1];
            switch (c2) {
                case 'G': 
                case 'N': {
                    break;
                }
                case '(': {
                    return this.matchNodes(n8, 65536, n5);
                }
                case ')': {
                    return this.matchNodes(n8, 65536, n5);
                }
                case '\\': {
                    if (n5 >= n6) {
                        return -1;
                    }
                    if (xSDCharClassArray[n9].match(this.value.charAt(n5++))) break;
                    return -1;
                }
                case '.': {
                    if (n5 < n6 && this.value.charAt(n5++) != '\n') break;
                    return -1;
                }
                case 'A': {
                    int n10;
                    if (n5 >= n6) {
                        return -1;
                    }
                    int n11 = n9;
                    int n12 = n7 + 3;
                    if (n6 - n5 < n11) {
                        return -1;
                    }
                    for (n10 = 0; n10 < n11; ++n10) {
                        if (this.value.charAt(n5++) == cArray[n12 + n10]) continue;
                        return -1;
                    }
                    break;
                }
                case 'P': 
                case 'p': {
                    if (n5 >= n6) {
                        return -1;
                    }
                    if (xSDCharClassArray[n9].match(this.value.charAt(n5++))) break;
                    return -1;
                }
                case '[': {
                    if (n5 >= n6) {
                        return -1;
                    }
                    int n10 = this.value.charAt(n5);
                    if (!xSDCharClassArray[cArray[n7 + 3]].match((char)n10)) {
                        return -1;
                    }
                    ++n5;
                    break;
                }
                case '|': {
                    short s2;
                    if (this.len == 0 && n7 == 3) {
                        return this.len;
                    }
                    if (cArray[n8] != '|') {
                        n7 += 3;
                        continue block12;
                    }
                    do {
                        int n13;
                        if ((n13 = this.matchNodes(n7 + 3, 65536, n5)) != this.len) continue;
                        return n13;
                    } while ((s2 = (short)cArray[n7 + 2]) != 0 && cArray[n7 += s2] == '|');
                    return -1;
                }
                case 'E': {
                    return n5;
                }
                default: {
                    this.error(24000, "Invalid opcode.");
                }
            }
            n7 = n8;
        }
        this.error(24000, "Reach an invalid state.");
        return -1;
    }

    boolean match(String string) throws XSDException {
        if (this.program == null) {
            this.error(24000, "Invalid state.");
        }
        this.value = string;
        this.len = string.length();
        if (this.program.hasInvalidChar(string)) {
            return false;
        }
        int n2 = this.matchNodes(0, 65536, 0);
        return n2 == this.len;
    }

    private void error(int n2, String string) throws XSDException {
        throw new XSDException(n2, string);
    }

    private void error2(int n2, String string, String string2) throws XSDException {
        throw new XSDException(n2, string, string2);
    }
}

