/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class NodeFactory
implements Serializable {
    XMLDocument defaultDoc;

    public NodeFactory() {
        this.defaultDoc = new XMLDocument();
        this.defaultDoc.setNodeFlag(0x100000);
    }

    protected NodeFactory(XMLDocument xMLDocument) {
        this.defaultDoc = xMLDocument;
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public XMLDocument createDocument() {
        this.defaultDoc = this.defaultDoc.createDocument();
        return this.defaultDoc;
    }

    public XMLElement createElement(String string) {
        return (XMLElement)this.defaultDoc.createElement(string);
    }

    public XMLElement createElementNS(String string, String string2, String string3) {
        String string4 = string;
        if (string2 != null && string2 != "") {
            string4 = string2 + ":" + string;
        }
        return (XMLElement)this.defaultDoc.createElement(string3, string4);
    }

    public XMLText createTextNode(String string) {
        return (XMLText)this.defaultDoc.createTextNode(string);
    }

    public XMLCDATA createCDATASection(String string) {
        return (XMLCDATA)this.defaultDoc.createCDATASection(string);
    }

    public XMLComment createComment(String string) {
        return (XMLComment)this.defaultDoc.createComment(string);
    }

    public XMLPI createProcessingInstruction(String string, String string2) {
        return (XMLPI)this.defaultDoc.createProcessingInstruction(string, string2);
    }

    public XMLAttr createAttribute(String string, String string2) {
        XMLAttr xMLAttr = (XMLAttr)this.defaultDoc.createAttribute(string);
        xMLAttr.setNodeValue(string2);
        return xMLAttr;
    }

    public XMLAttr createAttributeNS(String string, String string2, String string3, String string4) {
        String string5 = string;
        if (string2 != null && string2 != "") {
            string5 = string2 + ":" + string;
        }
        XMLAttr xMLAttr = (XMLAttr)this.defaultDoc.createAttribute(string3, string5, string4);
        return xMLAttr;
    }

    public XMLAttr createAttribute(String string, String string2, String string3, String string4) {
        return this.createAttributeNS(string, string2, string3, string4);
    }

    public XMLDocumentFragment createDocumentFragment() {
        return (XMLDocumentFragment)this.defaultDoc.createDocumentFragment();
    }

    public XMLEntityReference createEntityReference(String string) {
        return (XMLEntityReference)this.defaultDoc.createEntityReference(string);
    }

    final XMLDocument createNFDocument() {
        return new NFDocument(this);
    }

    class NFDocument
    extends XMLDocument {
        NodeFactory nf;
        XMLDocument doc;

        NFDocument(NodeFactory nodeFactory2) {
            this.nf = nodeFactory2;
        }

        @Override
        XMLDocument createDocument() {
            this.doc = this.nf.createDocument();
            return this.doc;
        }

        @Override
        DTD createDoctype(String string, String string2, String string3) {
            if (this.doc != null) {
                return this.doc.createDoctype(string, string2, string3);
            }
            return null;
        }

        @Override
        public Element createElement(String string, String string2) throws DOMException {
            XMLElement xMLElement = this.nf.isNamespaceAware() ? this.nf.createElementNS(XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string) : this.nf.createElement(string2);
            if (xMLElement != null) {
                xMLElement.setDocument(this.doc);
            }
            return xMLElement;
        }

        @Override
        public Text createTextNode(char[] cArray, int n2, int n3) {
            XMLText xMLText = this.nf.createTextNode(new String(cArray, n2, n3));
            if (xMLText != null) {
                xMLText.setDocument(this.doc);
            }
            return xMLText;
        }

        @Override
        public CDATASection createCDATASection(String string) throws DOMException {
            XMLCDATA xMLCDATA = this.nf.createCDATASection(string);
            if (xMLCDATA != null) {
                xMLCDATA.setDocument(this.doc);
            }
            return xMLCDATA;
        }

        @Override
        public Comment createComment(String string) {
            XMLComment xMLComment = this.nf.createComment(string);
            if (xMLComment != null) {
                xMLComment.setDocument(this.doc);
            }
            return xMLComment;
        }

        @Override
        public ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
            XMLPI xMLPI = this.nf.createProcessingInstruction(string, string2);
            if (xMLPI != null) {
                xMLPI.setDocument(this.doc);
            }
            return xMLPI;
        }

        @Override
        public Attr createAttribute(String string, String string2, String string3) throws DOMException {
            XMLAttr xMLAttr = this.nf.isNamespaceAware() ? this.nf.createAttributeNS(XMLUtil.getLocalName(string2), XMLUtil.getPrefix(string2), string, string3) : this.nf.createAttribute(string2, string3);
            if (xMLAttr != null) {
                xMLAttr.setDocument(this.doc);
            }
            return xMLAttr;
        }

        @Override
        public DocumentFragment createDocumentFragment() {
            XMLDocumentFragment xMLDocumentFragment = this.nf.createDocumentFragment();
            if (xMLDocumentFragment != null) {
                xMLDocumentFragment.setDocument(this.doc);
            }
            return xMLDocumentFragment;
        }

        @Override
        public EntityReference createEntityReference(String string) throws DOMException {
            XMLEntityReference xMLEntityReference = this.nf.createEntityReference(string);
            if (xMLEntityReference != null) {
                xMLEntityReference.setDocument(this.doc);
            }
            return xMLEntityReference;
        }
    }
}

