/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLEntity;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLExternalReader;
import oracle.xml.parser.v2.XMLMultiHandler;
import oracle.xml.parser.v2.XMLNotation;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.util.QxNameHash;
import oracle.xml.util.TagNameHashtable;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class NonValidatingParser
implements XMLConstants {
    TagNameHashtable.TagName attrTag = null;
    boolean namespaceFeature = false;
    boolean namespacePrefixFeature = true;
    boolean stringInternFeature = true;
    boolean parsing;
    EntityResolver entResolver;
    DTDHandler dtdHandler;
    LexicalHandler lexHandler;
    DeclHandler declHandler;
    ContentHandler cntHandler;
    XMLError err;
    XMLReader reader;
    URL baseURL;
    DTD dtd;
    int externalDTD;
    boolean doctypePresent = false;
    boolean fixedDTD;
    boolean standalone = false;
    boolean expanderef = true;
    boolean charChunks = false;
    ParserState currentState;
    ParserState[] parserStates;
    int stateIndex;
    int maxIndex;
    int stateSize = 16;
    Boolean entResolution = null;
    int[] charLimits = new int[2];
    int valMode = 0;
    int preserveWS = -1;
    HashMap attrHash;
    int nsArraySize = 256;
    String[] prefixes;
    String[] namespaces;
    int nsTop = 0;
    HashMap<String, String> namespaceMap;
    SAXAttrList attrList;
    static final int WS_UNINIT = -1;
    static final int WS_TRUE = 0;
    static final int WS_FALSE = 1;
    boolean entityAttributeSet = false;
    int entityExpansionDepth = -1;
    private static String entityDepthProperty = null;
    boolean deterministic = true;
    boolean[] bltent_wspace = new boolean[1];
    StringBuilder attrValue = new StringBuilder(48);
    private boolean isIgnoringComments = false;

    public NonValidatingParser() {
        this.parserStates = new ParserState[this.stateSize];
        this.stateIndex = -1;
        this.maxIndex = -1;
        this.dtd = new DTD();
    }

    public NonValidatingParser(NonValidatingParser nonValidatingParser) {
        this.reader = nonValidatingParser.reader;
        this.baseURL = nonValidatingParser.baseURL;
        this.entResolver = nonValidatingParser.entResolver;
        this.entResolution = nonValidatingParser.entResolution;
        this.dtdHandler = nonValidatingParser.dtdHandler;
        this.lexHandler = nonValidatingParser.lexHandler;
        this.declHandler = nonValidatingParser.declHandler;
        this.cntHandler = nonValidatingParser.cntHandler;
        this.parserStates = nonValidatingParser.parserStates;
        this.currentState = nonValidatingParser.currentState;
        this.stateSize = nonValidatingParser.stateSize;
        this.stateIndex = nonValidatingParser.stateIndex;
        this.maxIndex = nonValidatingParser.maxIndex;
        this.dtd = nonValidatingParser.dtd;
        this.err = nonValidatingParser.err;
        this.fixedDTD = nonValidatingParser.fixedDTD;
        this.standalone = nonValidatingParser.standalone;
        this.preserveWS = nonValidatingParser.preserveWS;
        this.doctypePresent = nonValidatingParser.doctypePresent;
        this.valMode = nonValidatingParser.valMode;
        this.expanderef = nonValidatingParser.expanderef;
        this.entityAttributeSet = nonValidatingParser.entityAttributeSet;
        this.entityExpansionDepth = nonValidatingParser.entityExpansionDepth;
        this.deterministic = nonValidatingParser.deterministic;
        this.isIgnoringComments = nonValidatingParser.isIgnoringComments;
    }

    void init() throws SAXException, IOException {
        this.doctypePresent = false;
        if (this.reader != null) {
            this.reader.entResolver = null;
            this.reader.close();
        }
        if (!this.fixedDTD) {
            this.dtd = new DTD();
        } else {
            this.doctypePresent = true;
        }
        for (int i2 = 0; i2 < this.stateSize; ++i2) {
            if (this.parserStates[i2] == null) continue;
            this.parserStates[i2].reset(null, null, null, null);
        }
        this.attrHash = new HashMap(20);
        this.externalDTD = 0;
        this.stateIndex = -1;
        this.err.reset();
        this.nsTop = 0;
        this.nsArraySize = 256;
        this.prefixes = new String[this.nsArraySize];
        this.namespaces = new String[this.nsArraySize];
        this.namespaceMap = new HashMap(36);
        this.attrList = new SAXAttrList(12);
    }

    void reset() {
        if (this.reader != null) {
            this.reader.entResolver = null;
        }
        this.reader = null;
        if (!this.fixedDTD) {
            this.dtd = null;
        }
        for (int i2 = 0; i2 < this.stateSize; ++i2) {
            if (this.parserStates[i2] == null) continue;
            this.parserStates[i2].reset(null, null, null, null);
        }
        this.externalDTD = 0;
        this.currentState = null;
        this.stateIndex = -1;
        this.nsTop = 0;
        this.nsArraySize = 256;
        this.prefixes = new String[this.nsArraySize];
        this.namespaces = new String[this.nsArraySize];
        this.namespaceMap = new HashMap(36);
        this.attrList = new SAXAttrList(12);
        this.deterministic = true;
    }

    final void parseDTD(String string) throws SAXException, IOException {
        this.reader.attrValue = this.attrValue;
        this.dtd.setRootTag(string);
        this.dtd.xdkSetPublicId(this.reader.getPublicId());
        this.dtd.xdkSetSystemId(this.reader.getSystemId());
        this.reader.setLexicalHandler(this.lexHandler);
        this.reader = this.reader.getExternalReader();
        this.err.setLocator(this.reader);
        ++this.externalDTD;
        this.lexHandler.startDTD(string, this.dtd.getPublicId(), this.dtd.getSystemId());
        this.parseMarkupDecl();
        this.lexHandler.endDTD();
        --this.externalDTD;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 0, "EOF");
        }
        this.err.flushErrors1();
    }

    void parseDocument() throws XMLParseException, SAXException, IOException {
        this.reader.attrValue = this.attrValue;
        this.reader.setLexicalHandler(this.lexHandler);
        this.cntHandler.setDocumentLocator(this.reader);
        try {
            if (!this.entityAttributeSet && entityDepthProperty != null) {
                try {
                    this.entityExpansionDepth = new Integer(entityDepthProperty);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.entityExpansionDepth > 0 && this.entityExpansionDepth <= 16) {
                this.reader.setEntityDepth(this.entityExpansionDepth);
            }
            this.cntHandler.startDocument();
            if (this.cntHandler instanceof XSDValidator) {
                XSDValidator xSDValidator = (XSDValidator)this.cntHandler;
                try {
                    xSDValidator.setXMLProperty("baseURL", this.getBaseURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (SAXException sAXException) {
            this.err.setException(sAXException);
            this.err.error0(180, 1);
            this.err.flushErrors1();
        }
        this.parsing = true;
        this.parseProlog();
        this.parseRootElement();
        this.parseMisc();
        this.parsing = false;
        if (!this.reader.isEOF()) {
            this.err.error1(100, 0, "EOF");
        }
        this.checkNames(this.err);
        this.err.flushErrors1();
        if (this.err.getNumFatalMessages() == 0) {
            this.cntHandler.endDocument();
        }
        this.err.setLocator(null);
    }

    void parseProlog() throws XMLParseException, SAXException, IOException {
        this.parseMisc();
        this.parseDoctypeDecl();
        this.parseMisc();
    }

    void parseRootElement() throws XMLParseException, SAXException, IOException {
        if (this.reader.tryRead(60)) {
            this.parseElement();
        } else {
            this.err.error0(108, 0);
            this.err.flushErrors1();
        }
    }

    void parseMisc() throws XMLParseException, SAXException, IOException {
        while (true) {
            this.reader.skipWhiteSpace();
            if (this.reader.tryRead(cPISTART, 0, cPISTART.length)) {
                this.parsePI();
                continue;
            }
            if (!this.reader.tryRead(cCOMMENTSTART, 0, cCOMMENTSTART.length)) break;
            this.parseComment();
        }
    }

    void parsePI() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        String string = this.reader.scanQName();
        if (string.toLowerCase().equals("xml")) {
            this.err.error0(109, 0);
            bl = true;
        }
        boolean bl2 = this.reader.skipWhiteSpace();
        String string2 = this.reader.scanPI();
        if (!bl2 && string2.length() != 0) {
            this.err.error0(190, 0);
        }
        if (!bl) {
            this.cntHandler.processingInstruction(string, string2);
        }
    }

    void parseComment() throws XMLParseException, SAXException, IOException {
        char[] cArray = this.reader.scanComment(this.charLimits);
        if (this.charLimits[1] != 0 && !this.isIgnoringComments) {
            this.lexHandler.comment(cArray, this.charLimits[0], this.charLimits[1]);
        }
    }

    void parseDoctypeDecl() throws XMLParseException, SAXException, IOException {
        if (!this.reader.tryRead(cDECLSTART, 0, cDECLSTART.length)) {
            return;
        }
        if (!this.reader.tryRead(cDOCTYPE, 0, cDOCTYPE.length)) {
            this.err.error1(100, 0, "DOCTYPE");
            this.err.flushErrors1();
        }
        this.doctypePresent = true;
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        String string2 = null;
        String string3 = null;
        if (this.reader.skipWhiteSpace()) {
            if (this.reader.tryRead(cPUBLIC, 0, cPUBLIC.length)) {
                this.reader.requireWhiteSpace();
                string3 = this.reader.scanPubIdLiteral();
                this.reader.requireWhiteSpace();
                string2 = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            } else if (this.reader.tryRead(cSYSTEM, 0, cSYSTEM.length)) {
                this.reader.requireWhiteSpace();
                string2 = this.reader.scanQuotedString();
                this.reader.skipWhiteSpace();
            }
        }
        this.lexHandler.startDTD(string, string3, string2);
        if (this.reader.tryRead(91)) {
            this.dtd.setNodeFlag(65536);
            this.parseMarkupDecl();
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error0(191, 0);
        }
        if (string2 != null && !this.fixedDTD) {
            try {
                if (!this.standalone) {
                    URL uRL = new URL(this.getBaseURL(), string2);
                    string2 = uRL.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (!(this.standalone || this.reader.isStandalone() && this.reader.valMode == 0)) {
                if (!this.pushExternalDTD(string2, string3)) {
                    return;
                }
                this.reader = this.reader.getExternalReader();
                this.err.setLocator(this.reader);
                ++this.externalDTD;
                this.lexHandler.startEntity("[dtd]");
                this.parseMarkupDecl();
                this.lexHandler.endEntity("[dtd]");
                if (!this.reader.isEOF()) {
                    this.err.error0(192, 0);
                }
                --this.externalDTD;
                this.reader = this.reader.getInternalReader();
                this.err.setLocator(this.reader);
            }
        }
        if (!this.fixedDTD) {
            this.dtd.setRootTag(string);
            this.dtd.xdkSetSystemId(string2);
            this.dtd.xdkSetPublicId(string3);
        }
        this.lexHandler.endDTD();
    }

    URL getBaseURL() throws MalformedURLException {
        if (this.reader.isTopLevelReader() && this.baseURL != null) {
            return this.baseURL;
        }
        return new URL(this.reader.getSystemId());
    }

    private boolean pushExternalDTD(String string, String string2) throws SAXException, IOException {
        InputSource inputSource = this.entResolver.resolveEntity(string2, string);
        if (inputSource != null) {
            Reader reader = inputSource.getCharacterStream();
            if (reader != null) {
                this.reader.pushXMLReader(reader, inputSource.getSystemId(), inputSource.getPublicId());
            } else {
                InputStream inputStream = inputSource.getByteStream();
                if (inputStream != null) {
                    String string3 = inputSource.getEncoding();
                    if (string3 == null) {
                        this.reader.pushXMLReader(inputStream, inputSource.getSystemId(), inputSource.getPublicId());
                    } else {
                        this.reader.pushXMLReader(new InputStreamReader(inputStream, string3), inputSource.getSystemId(), inputSource.getPublicId());
                    }
                } else {
                    string = inputSource.getSystemId();
                    if (string != null) {
                        try {
                            this.reader.pushXMLReader(new URL(string), string, inputSource.getPublicId());
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.err.setException(malformedURLException);
                            this.err.error1(112, 0, string);
                            this.err.flushErrors1();
                        }
                    } else {
                        this.err.error1(113, 0, string);
                        this.err.flushErrors1();
                    }
                }
            }
        } else {
            boolean bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
            if (!bl) {
                this.err.error1(20242, 0, string);
                this.err.flushErrors1();
                String string4 = this.err.getMessage1(20242, string);
                throw new SAXException(string4);
            }
            try {
                this.reader.pushXMLReader(new URL(string), string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.err.setException(malformedURLException);
                this.err.error1(112, 0, string);
                this.err.flushErrors1();
                return false;
            }
        }
        return true;
    }

    void parseMarkupDecl() throws XMLParseException, SAXException, IOException {
        this.reader.skipWhiteSpace();
        while (!this.reader.isEOF()) {
            Object object;
            while (this.externalDTD == 0 && this.reader.tryRead(37)) {
                object = this.reader.getEntity(true);
                if (object == null) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                boolean bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
                if (!this.reader.pushEntityRef((XMLEntity)object, bl, false)) {
                    this.reader.skipWhiteSpace();
                    continue;
                }
                if (((XMLEntity)object).isExternalEntity()) {
                    this.reader = this.reader.getExternalReader();
                    this.err.setLocator(this.reader);
                    ++this.externalDTD;
                }
                this.parseMarkupDecl();
                if (((XMLEntity)object).isExternalEntity()) {
                    --this.externalDTD;
                    this.reader = this.reader.getInternalReader();
                    this.err.setLocator(this.reader);
                } else {
                    this.reader.popXMLReader();
                }
                this.reader.skipWhiteSpace();
            }
            this.reader.skipWhiteSpace();
            if (this.reader.setMarkupDepth(cDECLSTART, 0, cDECLSTART.length)) {
                if (this.reader.tryRead(cELEMENT, 0, cELEMENT.length)) {
                    this.parseElementDecl();
                } else if (this.reader.tryRead(cATTLIST, 0, cATTLIST.length)) {
                    this.parseAttlistDecl();
                } else if (this.reader.tryRead(cENTITY, 0, cENTITY.length)) {
                    this.parseEntityDecl();
                } else if (this.reader.tryRead(cNOTATION, 0, cNOTATION.length)) {
                    this.parseNotationDecl();
                } else if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
                    this.parseComment();
                } else if (this.externalDTD > 0 && this.reader.checkMarkupDepth(91)) {
                    this.reader.skipWhiteSpace();
                    if (this.reader.tryRead(cINCLUDE, 0, cINCLUDE.length)) {
                        this.reader.skipWhiteSpace();
                        if (!this.reader.checkMarkupDepth(91)) {
                            this.err.error0(114, 0);
                        }
                        object = ((XMLExternalReader)this.reader).markupDepth;
                        this.parseMarkupDecl();
                        ((XMLExternalReader)this.reader).markupDepth = object;
                        if (!this.reader.checkMarkupDepth(cCDATAEND, 1, cCDATAEND.length - 1)) {
                            this.err.error0(115, 0);
                        }
                    } else if (this.reader.tryRead(cIGNORE, 0, cIGNORE.length)) {
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    } else {
                        this.err.error2(101, 0, "IGNORE", "INCLUDE");
                        this.reader.skipIgnoreSection();
                        this.reader.skipWhiteSpace();
                    }
                }
            } else if (this.reader.setMarkupDepth(cPISTART, 0, cPISTART.length)) {
                this.parsePI();
            } else {
                if (this.reader.tryRead(93)) {
                    return;
                }
                this.reader.skipWhiteSpace();
                if (this.reader.isEOF()) {
                    return;
                }
                this.err.error0(192, 0);
                this.err.flushErrors();
            }
            this.reader.skipWhiteSpace();
        }
    }

    void parseElementDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        ElementDecl elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl != null && elementDecl.isNodeFlag(65536)) {
            int n2 = this.reader.valMode == 2 ? 1 : 2;
            this.err.error1(131, n2, string);
        }
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string);
            this.dtd.addElementDecl(elementDecl);
        } else {
            elementDecl.setNodeFlag(65536);
        }
        if (this.externalDTD > 0) {
            elementDecl.setNodeFlag(128);
        }
        this.reader.requireWhiteSpace();
        this.parseContentModel(elementDecl.xdkGetContentModel());
        this.declHandler.elementDecl(string, elementDecl.xdkGetContentModel().getStringValue());
        this.reader.skipWhiteSpace();
        if (!this.reader.checkMarkupDepth(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    void parseContentModel(ContentModel contentModel) throws XMLParseException, SAXException, IOException {
        contentModel.setDeterministic(this.deterministic);
        if (this.reader.tryRead(cEMPTY, 0, cEMPTY.length)) {
            contentModel.type = 1;
        } else if (this.reader.tryRead(cANY, 0, cANY.length)) {
            contentModel.type = (byte)2;
        } else if (this.reader.tryRead(40)) {
            this.reader.push(40);
            if (!contentModel.parseContentModel(this.err, this.reader)) {
                this.err.flushErrors1();
            }
        } else {
            this.err.error3(102, 0, "EMPTY", "ANY", "(");
            this.err.flushErrors1();
        }
    }

    ElementDecl parseAttlistDecl() throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = null;
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        elementDecl = this.dtd.findElementDecl(string);
        if (elementDecl == null) {
            elementDecl = this.dtd.createElementDecl(string, (byte)2);
            elementDecl.resetNodeFlag(65536);
            this.dtd.addElementDecl(elementDecl);
            if (this.externalDTD > 0) {
                elementDecl.setNodeFlag(128);
            }
        }
        boolean bl = this.reader.skipWhiteSpace();
        while (!this.reader.checkMarkupDepth(62)) {
            AttrDecl attrDecl;
            String string2;
            int n2;
            if (!bl) {
                this.err.error0(190, 0);
            }
            if ((n2 = elementDecl.getAttrDeclIndex(string2 = (attrDecl = this.parseAttrDecl(elementDecl)).getNodeName())) != -1) {
                this.err.error1(135, 2, string2);
                if (this.fixedDTD) {
                    elementDecl.removeAttrDeclAt(n2);
                    elementDecl.addAttrDecl(attrDecl);
                }
            } else {
                if (this.externalDTD > 0) {
                    attrDecl.setNodeFlag(128);
                }
                elementDecl.addAttrDecl(attrDecl);
                this.declHandler.attributeDecl(string, string2, AttrDecl.attrDeclTypes[attrDecl.atttype], AttrDecl.attrDeclPresence[attrDecl.attpres], attrDecl.getDefaultValue());
            }
            bl = this.reader.skipWhiteSpace();
        }
        return elementDecl;
    }

    AttrDecl parseAttrDecl(ElementDecl elementDecl) throws XMLParseException, SAXException, IOException {
        String string;
        AttrDecl attrDecl = null;
        boolean bl = false;
        String string2 = this.reader.scanQName();
        attrDecl = (AttrDecl)elementDecl.getDocument().createNodeFromType((short)14);
        attrDecl.xdkSetQxName(QxNameHash.create("", string2, "", string2));
        this.reader.requireWhiteSpace();
        if (this.reader.tryRead(cCDATA, 0, cCDATA.length)) {
            attrDecl.atttype = 0;
        } else if (this.reader.tryRead(cIDREFS, 0, cIDREFS.length)) {
            attrDecl.atttype = 3;
        } else if (this.reader.tryRead(cIDREF, 0, cIDREF.length)) {
            attrDecl.atttype = 2;
        } else if (this.reader.tryRead(cID, 0, cID.length)) {
            attrDecl.atttype = 1;
        } else if (this.reader.tryRead(cENTITY, 0, cENTITY.length)) {
            attrDecl.atttype = 4;
        } else if (this.reader.tryRead(cENTITIES, 0, cENTITIES.length)) {
            attrDecl.atttype = 5;
        } else if (this.reader.tryRead(cNMTOKENS, 0, cNMTOKENS.length)) {
            attrDecl.atttype = 7;
        } else if (this.reader.tryRead(cNMTOKEN, 0, cNMTOKEN.length)) {
            attrDecl.atttype = 6;
        } else if (this.reader.tryRead(cNOTATION, 0, cNOTATION.length)) {
            attrDecl.atttype = 8;
            this.reader.requireWhiteSpace();
        } else if (this.reader.tryRead(40)) {
            attrDecl.atttype = 9;
        } else {
            this.err.error0(133, 0);
            attrDecl.atttype = 0;
        }
        if (attrDecl.atttype == 8 || attrDecl.atttype == 9) {
            Vector<String> vector = new Vector<String>();
            attrDecl.xdkSetEnumValue(vector);
            if (attrDecl.atttype == 8 && !this.reader.tryRead(40)) {
                this.err.error1(100, 0, "(");
            }
            while (!this.reader.isEOF()) {
                this.reader.skipWhiteSpace();
                string = attrDecl.atttype == 8 ? this.reader.scanQName() : this.reader.scanNmToken();
                vector.addElement(string);
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(124)) continue;
                if (this.reader.tryRead(41)) break;
                this.err.error2(101, 0, ")", "|");
                this.err.flushErrors1();
            }
        }
        this.reader.requireWhiteSpace();
        attrDecl.attpres = 0;
        if (this.reader.tryRead(35)) {
            if (this.reader.tryRead(cFIXED, 0, cFIXED.length)) {
                attrDecl.attpres = 3;
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(cREQUIRED, 0, cREQUIRED.length)) {
                attrDecl.attpres = 1;
            } else if (this.reader.tryRead(cIMPLIED, 0, cIMPLIED.length)) {
                attrDecl.attpres = 2;
            } else {
                this.err.error0(288, 0);
            }
        }
        if (attrDecl.attpres == 3 || attrDecl.attpres == 0) {
            this.reader.attrName = string2;
            string = this.parseAttrValue();
            string = this.normalizeAttrValue(string, attrDecl, true);
            attrDecl.xdkSetAttrDeclDefault(string);
        }
        return attrDecl;
    }

    String normalizeAttrValue(String string, AttrDecl attrDecl, boolean bl) throws XMLParseException, SAXException, IOException {
        if (attrDecl != null && attrDecl.atttype != 0) {
            int n2;
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            int n4 = 0;
            for (n2 = 0; n2 < n3 && cArray[n2] == ' '; ++n2) {
            }
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                if (n4 != 0) {
                    cArray[i2 - n4] = cArray[i2];
                }
                if (cArray[i2] != ' ' || cArray[i2 - 1] != ' ') continue;
                ++n4;
            }
            if ((n3 = n3 - n2 - n4) != 0 && cArray[n2 + n3 - 1] == ' ') {
                --n3;
            }
            return new String(cArray, n2, n3);
        }
        return string;
    }

    XMLEntity parseEntityDecl() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        boolean bl2 = false;
        this.reader.requireWhiteSpace();
        boolean bl3 = this.reader.checkParEntity();
        String string = this.reader.scanQName();
        String string2 = bl3 ? "%" + string : string;
        XMLEntity xMLEntity = (XMLEntity)this.dtd.findEntity(string, bl3);
        if (xMLEntity != null) {
            this.err.error1(116, 2, string);
            xMLEntity = this.dtd.createEntityDecl(string, bl3);
            bl2 = true;
            if (this.fixedDTD) {
                this.dtd.addEntity(xMLEntity, bl3);
                xMLEntity.expanderef = this.expanderef;
                if (this.externalDTD > 0) {
                    xMLEntity.setNodeFlag(128);
                }
            }
        } else {
            xMLEntity = this.dtd.createEntityDecl(string, bl3);
            xMLEntity.expanderef = this.expanderef;
            this.dtd.addEntity(xMLEntity, bl3);
            if (this.externalDTD > 0) {
                xMLEntity.setNodeFlag(128);
            }
        }
        this.reader.requireWhiteSpace();
        String string3 = null;
        String string4 = null;
        if (this.reader.tryRead(cPUBLIC, 0, cPUBLIC.length)) {
            bl = true;
            this.reader.requireWhiteSpace();
            string4 = this.reader.scanPubIdLiteral();
            xMLEntity.xdkSetPublicId(string4);
            this.reader.requireWhiteSpace();
            string3 = this.reader.scanQuotedString();
            xMLEntity.xdkSetSystemId(string3);
        } else if (this.reader.tryRead(cSYSTEM, 0, cSYSTEM.length)) {
            bl = true;
            this.reader.requireWhiteSpace();
            string3 = this.reader.scanQuotedString();
            xMLEntity.xdkSetSystemId(string3);
        }
        if (bl) {
            String string5 = xMLEntity.getSystemId();
            try {
                URL uRL = new URL(this.getBaseURL(), string5);
                xMLEntity.setURL(uRL.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            boolean bl4 = this.reader.skipWhiteSpace();
            boolean bl5 = false;
            if (this.reader.tryRead(cNDATA, 0, cNDATA.length)) {
                if (!bl4) {
                    this.err.error0(190, 0);
                }
                if (bl3) {
                    this.err.error0(117, 0);
                }
                this.reader.requireWhiteSpace();
                xMLEntity.setNotationName(this.reader.scanQName());
                if (!bl3 && xMLEntity.getNotationName() == null) {
                    this.err.error0(118, 0);
                }
                this.dtdHandler.unparsedEntityDecl(string, xMLEntity.getPublicId(), xMLEntity.getSystemId(), xMLEntity.getNotationName());
                bl5 = true;
            } else if (!bl2) {
                this.declHandler.externalEntityDecl(string2, xMLEntity.getPublicId(), string5);
            }
            if (!(this.standalone || bl5 || string3.equals(""))) {
                try {
                    String string6 = xMLEntity.getSystemId();
                    String string7 = xMLEntity.getPublicId();
                    URL uRL = new URL(this.getBaseURL(), string6);
                    String string8 = uRL.toString();
                    InputSource inputSource = this.entResolver.resolveEntity(string7, string8);
                    InputStream inputStream = inputSource == null ? this.reader.openURL(uRL) : null;
                    if (inputSource != null || inputStream != null && inputStream.available() != 0) {
                        if (inputSource != null) {
                            this.reader.pushXMLReader(inputSource);
                        } else {
                            this.reader.pushXMLReader(inputStream, string6, string7);
                        }
                        xMLEntity.setInputEncoding(this.reader.encoding);
                        xMLEntity.setXmlEncoding(this.reader.xmlDeclEncoding);
                        xMLEntity.setXmlVersion(this.reader.xmlDeclVersion);
                        this.reader.popXMLReader();
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            String string9 = this.parseEntityValue();
            xMLEntity.setNodeValue(string9);
            xMLEntity.setNodeFlag(131072);
            if (!bl2) {
                this.declHandler.internalEntityDecl(string2, string9);
            }
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.checkMarkupDepth(62)) {
            this.err.error1(100, 0, ">");
        }
        return xMLEntity;
    }

    String parseEntityValue() throws SAXException, IOException {
        String string;
        block4: {
            int n2 = this.reader.read();
            if (n2 != 34 && n2 != 39) {
                this.err.error0(119, 0);
                this.err.flushErrors1();
            }
            string = "";
            while (true) {
                string = string.concat(this.reader.scanEntityString(n2));
                if (this.reader.tryRead(n2)) break block4;
                if (this.reader.tryRead(37)) {
                    if (this.externalDTD > 0) {
                        string = string.concat(this.parseEntityRefValue());
                        continue;
                    }
                    this.err.error1(210, 0, "%");
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors1();
            return string;
        }
        return string;
    }

    private String parseEntityRefValue() throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity = this.reader.getEntity(true);
        if (xMLEntity == null) {
            return "";
        }
        if (xMLEntity.getLength() == -1) {
            return xMLEntity.xdkGetNodeValue();
        }
        boolean bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
        if (!this.reader.pushEntityRef(xMLEntity, bl, true)) {
            return "";
        }
        String string = "";
        while (true) {
            string = string.concat(this.reader.scanEntityString(65535));
            if (this.reader.tryRead(37)) {
                string = string.concat(this.parseEntityRefValue());
                continue;
            }
            if (this.reader.isEOF()) break;
        }
        this.reader.popXMLReader();
        return string;
    }

    void parseNotationDecl() throws XMLParseException, SAXException, IOException {
        this.reader.requireWhiteSpace();
        String string = this.reader.scanQName();
        XMLNotation xMLNotation = (XMLNotation)this.dtd.findNotation(string);
        if (xMLNotation != null) {
            if (this.valMode == 2) {
                this.err.error1(136, 1, string);
            } else {
                this.err.error1(136, 2, string);
            }
            xMLNotation = this.dtd.createNotationDecl(string);
        } else {
            xMLNotation = this.dtd.createNotationDecl(string);
            this.dtd.addNotation(xMLNotation);
            if (this.externalDTD > 0) {
                xMLNotation.setNodeFlag(128);
            }
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(cPUBLIC, 0, cPUBLIC.length)) {
            this.reader.requireWhiteSpace();
            xMLNotation.setPublicId(this.reader.scanPubIdLiteral());
            boolean bl = this.reader.skipWhiteSpace();
            if (!this.reader.checkMarkupDepth(62)) {
                if (!bl) {
                    this.err.error0(190, 0);
                }
                xMLNotation.setSystemId(this.reader.scanQuotedString());
                this.reader.skipWhiteSpace();
                if (!this.reader.checkMarkupDepth(62)) {
                    this.err.error1(100, 0, ">");
                }
            }
        } else if (this.reader.tryRead(cSYSTEM, 0, cSYSTEM.length)) {
            this.reader.requireWhiteSpace();
            xMLNotation.setSystemId(this.reader.scanQuotedString());
            this.reader.skipWhiteSpace();
            if (!this.reader.checkMarkupDepth(62)) {
                this.err.error1(100, 0, ">");
            }
        } else {
            this.err.error2(101, 0, "PUBLIC", "SYSTEM");
            this.err.flushErrors1();
            if (this.reader.checkMarkupDepth(62)) {
                this.err.error1(100, 0, ">");
            }
            return;
        }
        try {
            URL uRL = this.baseURL != null ? new URL(this.baseURL, xMLNotation.getSystemId()) : new URL(new URL(this.reader.getSystemId()), xMLNotation.getSystemId());
            xMLNotation.setSystemId(uRL.toString());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.dtdHandler.notationDecl(string, xMLNotation.getPublicId(), xMLNotation.getSystemId());
    }

    String parseElement() throws XMLParseException, SAXException, IOException {
        block8: while (true) {
            TagNameHashtable.TagName tagName = this.reader.readQName();
            this.pushState(tagName.getPrefix(), tagName.getLocalName(), tagName.getTag());
            this.attrList.reset();
            this.parseAttributes();
            this.cntHandler.startElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname, this.attrList);
            if (this.currentState.empty) {
                this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
                this.popState();
                if (this.stateIndex == -1) {
                    return this.parserStates[0].qname;
                }
            }
            block9: while (true) {
                if (this.stateIndex < 0) continue block8;
                this.parseText();
                int n2 = this.reader.tryRead();
                switch (n2) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        this.parseEndTag();
                        if (this.currentState.markupDepth != 0) {
                            this.err.error0(120, 0);
                        }
                        this.cntHandler.endElement(this.currentState.namespace, this.currentState.localname, this.currentState.qname);
                        this.popState();
                        if (this.stateIndex != -1) continue block9;
                        return this.parserStates[0].qname;
                    }
                    case 2: {
                        if (!this.parseContentEntityRef()) continue block9;
                        ++this.currentState.markupDepth;
                        continue block9;
                    }
                    case 3: {
                        this.parsePI();
                        continue block9;
                    }
                    case 4: {
                        this.parseComment();
                        continue block9;
                    }
                    case 5: {
                        this.lexHandler.startCDATA();
                        do {
                            char[] cArray = this.reader.scanCDATA(this.charLimits, this.charChunks);
                            if (this.charLimits[1] == 0) break;
                            this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
                        } while (this.charChunks);
                        this.lexHandler.endCDATA();
                        continue block9;
                    }
                }
                if (!this.reader.isEOF()) continue;
                this.reader.popXMLReader();
                --this.currentState.markupDepth;
            }
            break;
        }
    }

    void parseEndTag() throws XMLParseException, SAXException, IOException {
        if (!this.reader.scanQName(this.currentState.qname)) {
            this.err.error1(121, 0, this.currentState.qname);
            this.err.flushErrors1();
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error0(123, 0);
        }
    }

    boolean isMarkup() throws SAXException, IOException {
        return this.reader.peek() == 60 || this.reader.peek(cPISTART, 0, cPISTART.length) || this.reader.peek(cCOMMENTSTART, 0, cCOMMENTSTART.length) || this.reader.peek(cCDATASTART, 0, cCDATASTART.length);
    }

    void parseText() throws XMLParseException, SAXException, IOException {
        char[] cArray;
        if (this.preserveWS != 0) {
            cArray = this.reader.scanWhiteSpace(this.charLimits);
            if (this.charLimits[1] != 0) {
                ElementDecl elementDecl = this.currentState.ed;
                if (this.isMarkup() && (this.preserveWS == 1 || elementDecl != null && elementDecl.getContentType() == 4)) {
                    this.cntHandler.ignorableWhitespace(cArray, this.charLimits[0], this.charLimits[1]);
                } else {
                    this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
                }
            }
        }
        this.bltent_wspace[0] = false;
        do {
            cArray = this.reader.scanChars(this.charLimits, this.charChunks, this.bltent_wspace);
            if (this.charLimits[1] == 0) break;
            this.reportCharacters(cArray, this.charLimits[0], this.charLimits[1]);
        } while (this.charChunks && !this.bltent_wspace[0]);
    }

    void parseAttributes() throws XMLParseException, SAXException, IOException {
        boolean bl = false;
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(62)) {
            if (this.currentState.ed != null) {
                this.checkDefaultAttributes();
            }
            this.expandNamespace();
            return;
        }
        if (this.reader.tryRead(cEMPTYTAGEND, 0, cEMPTYTAGEND.length)) {
            this.currentState.empty = true;
            if (this.currentState.ed != null) {
                this.checkDefaultAttributes();
            }
            this.expandNamespace();
            return;
        }
        while (true) {
            this.parseAttr();
            bl = this.reader.skipWhiteSpace();
            if (this.reader.tryRead(62)) break;
            if (this.reader.tryRead(cEMPTYTAGEND, 0, cEMPTYTAGEND.length)) {
                this.currentState.empty = true;
                break;
            }
            if (bl) continue;
            this.err.error0(190, 0);
        }
        if (this.currentState.ed != null) {
            this.checkDefaultAttributes();
        }
        this.expandNamespace();
    }

    DocumentBuilder getDocumentBuilder() {
        if (this.cntHandler instanceof XMLMultiHandler) {
            ContentHandler[] contentHandlerArray = ((XMLMultiHandler)this.cntHandler).getContentHandlers();
            int n2 = ((XMLMultiHandler)this.cntHandler).getNumContentHandlers();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!(contentHandlerArray[i2] instanceof DocumentBuilder)) continue;
                return (DocumentBuilder)contentHandlerArray[i2];
            }
        }
        return null;
    }

    AttrDecl parseAttr() throws XMLParseException, SAXException, IOException {
        AttrDecl attrDecl = null;
        int n2 = 0;
        this.attrTag = this.reader.readQName();
        String string = this.attrTag.getTag();
        String string2 = this.attrTag.getPrefix();
        String string3 = this.attrTag.getLocalName();
        if (this.currentState.ed != null) {
            attrDecl = this.currentState.ed.findAttrDecl(string);
        }
        if (attrDecl != null) {
            n2 = attrDecl.atttype;
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(61)) {
            this.err.error0(122, 0);
        }
        this.reader.skipWhiteSpace();
        this.reader.attrName = string3;
        String string4 = this.parseAttrValue();
        if (attrDecl != null) {
            string4 = this.normalizeAttrValue(string4, attrDecl, false);
        }
        if (string3 == "xmlns" || string2 == "xmlns") {
            this.addNamespaceDef(string2, string3, string4);
            if (!this.namespacePrefixFeature) {
                return attrDecl;
            }
        }
        this.attrList.addAttr(string2, string3, string, string4, true, 0);
        return attrDecl;
    }

    void addNamespaceDef(String string, String string2, String string3) throws SAXException {
        Object object;
        string3 = string3.intern();
        if (string == "xmlns") {
            this.cntHandler.startPrefixMapping(string2, string3);
        } else {
            this.cntHandler.startPrefixMapping("", string3);
        }
        if (this.nsTop == this.nsArraySize) {
            object = this.prefixes;
            this.prefixes = new String[this.nsArraySize * 2];
            System.arraycopy(object, 0, this.prefixes, 0, this.nsArraySize);
            object = this.namespaces;
            this.namespaces = new String[this.nsArraySize * 2];
            System.arraycopy(object, 0, this.namespaces, 0, this.nsArraySize);
            this.nsArraySize *= 2;
        }
        object = this.namespaceMap.get(string2);
        this.prefixes[this.nsTop] = string2;
        this.namespaces[this.nsTop] = object != null ? object : null;
        ++this.nsTop;
        this.currentState.nsEnd = this.nsTop;
        this.namespaceMap.put(string2, string3);
    }

    void checkDefaultAttributes() throws XMLParseException, SAXException {
        NamedNodeMap namedNodeMap = this.currentState.ed.getAttrDecls();
        if (namedNodeMap != null) {
            AttrDecl attrDecl;
            int n2;
            this.attrHash.clear();
            for (n2 = 0; n2 < this.attrList.count; ++n2) {
                this.attrHash.put(this.attrList.qname[n2], this.attrList.qname[n2]);
                attrDecl = (AttrDecl)namedNodeMap.getNamedItem(this.attrList.qname[n2]);
                if (attrDecl == null) continue;
                this.attrList.attrType[n2] = attrDecl.atttype;
            }
            n2 = namedNodeMap.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                attrDecl = (AttrDecl)namedNodeMap.item(i2);
                String string2 = attrDecl.getNodeName();
                if (this.attrHash.get(string2) != null || (string = attrDecl.getDefaultValue()) == null) continue;
                String string3 = XMLUtil.getPrefix(string2);
                String string4 = XMLUtil.getLocalName(string2);
                if (string4 == "xmlns" || string3 == "xmlns") {
                    this.addNamespaceDef(string3, string4, string);
                }
                this.attrList.addAttr(string3, string4, string2, string, false, attrDecl.atttype);
            }
        }
    }

    String parseAttrValue() throws XMLParseException, SAXException, IOException {
        block4: {
            this.attrValue.setLength(0);
            int n2 = this.reader.read();
            if (n2 != 34 && n2 != 39) {
                this.err.error0(125, 0);
                this.err.flushErrors1();
            }
            while (true) {
                this.reader.scanAttrString(n2);
                if (this.reader.tryRead(n2)) break block4;
                if (this.reader.tryRead(60)) {
                    this.err.error0(126, 0);
                    continue;
                }
                if (this.reader.tryRead(38)) {
                    this.parseAttrEntityRef();
                    continue;
                }
                if (this.reader.isEOF()) break;
            }
            this.err.error0(193, 0);
            this.err.flushErrors1();
            return this.attrValue.toString();
        }
        this.reader.attrName = null;
        return this.attrValue.toString();
    }

    void parseAttrEntityRef() throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return;
        }
        if (xMLEntity.getSystemId() != null) {
            this.err.error0(127, 0);
            return;
        }
        if (xMLEntity.getLength() == -1) {
            this.attrValue.append(xMLEntity.xdkGetNodeValue());
            return;
        }
        if (!this.reader.pushEntityRef(xMLEntity, false, false)) {
            return;
        }
        while (true) {
            this.reader.scanAttrString(65535);
            if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                return;
            }
            if (this.reader.tryRead(60)) {
                this.err.error0(126, 0);
                continue;
            }
            if (!this.reader.tryRead(38)) continue;
            this.parseAttrEntityRef();
        }
    }

    boolean parseContentEntityRef() throws XMLParseException, SAXException, IOException {
        XMLEntity xMLEntity = this.reader.getEntity(false);
        if (xMLEntity == null) {
            return false;
        }
        if (xMLEntity.getLength() == -1) {
            char[] cArray = xMLEntity.xdkGetNodeValue().toCharArray();
            this.reportCharacters(cArray, 0, cArray.length);
            return false;
        }
        if (xMLEntity.getNotationName() != null) {
            this.err.error0(128, 0);
            return false;
        }
        boolean bl = this.entResolution == null ? XMLParser.extValue : this.entResolution;
        String string = this.reader.xmlDeclVersion;
        String string2 = this.reader.xmlDeclEncoding;
        this.reader.xmlDeclEncoding = null;
        this.reader.xmlDeclVersion = null;
        boolean bl2 = this.reader.pushEntityRef(xMLEntity, bl, true);
        this.reader.xmlDeclVersion = string;
        this.reader.xmlDeclEncoding = string2;
        return bl2;
    }

    void reportCharacters(char[] cArray, int n2, int n3) throws XMLParseException, SAXException, IOException {
        this.cntHandler.characters(cArray, n2, n3);
    }

    void pushState(String string, String string2, String string3) throws XMLParseException, SAXException, IOException {
        ElementDecl elementDecl = this.dtd.findElementDecl(string3);
        ++this.stateIndex;
        if (this.stateIndex > this.maxIndex) {
            if (this.stateIndex >= this.stateSize) {
                ParserState[] parserStateArray = this.parserStates;
                this.parserStates = new ParserState[this.stateSize * 2];
                System.arraycopy(parserStateArray, 0, this.parserStates, 0, this.stateSize);
                this.stateSize *= 2;
            }
            this.parserStates[this.stateIndex] = this.currentState = new ParserState(string, string2, string3, elementDecl);
            ++this.maxIndex;
        } else {
            this.currentState = this.parserStates[this.stateIndex];
            this.currentState.reset(string, string2, string3, elementDecl);
        }
        this.currentState.nsStart = this.nsTop;
        this.currentState.nsEnd = this.nsTop;
    }

    ParserState popState() throws XMLParseException, SAXException, IOException {
        ParserState parserState = this.currentState;
        while (this.currentState.nsStart < this.currentState.nsEnd) {
            --this.currentState.nsEnd;
            String string = this.prefixes[this.currentState.nsEnd];
            String string2 = this.namespaces[this.currentState.nsEnd];
            if (string == "xmlns") {
                this.cntHandler.endPrefixMapping("");
            } else {
                this.cntHandler.endPrefixMapping(string);
            }
            if (string2 != null) {
                this.namespaceMap.put(string, string2);
                continue;
            }
            this.namespaceMap.remove(string);
        }
        this.nsTop = this.currentState.nsEnd;
        --this.stateIndex;
        this.currentState = this.stateIndex >= 0 ? this.parserStates[this.stateIndex] : null;
        return parserState;
    }

    void expandNamespace() throws XMLParseException, SAXException, IOException {
        int n2 = this.attrList.count;
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 3: {
                if (this.attrList.qname[0] == this.attrList.qname[2] || this.attrList.qname[1] == this.attrList.qname[2]) {
                    this.err.error0(124, 0);
                }
            }
            case 2: {
                if (this.attrList.qname[0] != this.attrList.qname[1]) break;
                this.err.error0(124, 0);
                break;
            }
            default: {
                this.attrHash.clear();
            }
        }
        if (this.currentState.prefix != "") {
            this.currentState.namespace = this.resolveNS(this.currentState.prefix);
            if (this.currentState.namespace == "") {
                this.err.error1(129, 1, this.currentState.prefix);
            }
        } else {
            this.currentState.namespace = this.resolveNS("xmlns");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            if (n2 > 3) {
                if (this.attrHash.get(this.attrList.qname[i2]) == null) {
                    this.attrHash.put(this.attrList.qname[i2], this.attrList.qname[i2]);
                } else {
                    this.err.error0(124, 0);
                }
            }
            if ((string = this.attrList.prefix[i2]) != "") {
                this.attrList.namespace[i2] = string == "xmlns" ? "http://www.w3.org/2000/xmlns/" : this.resolveNS(string);
                if (this.attrList.namespace[i2] != "") continue;
                this.err.error1(129, 1, string);
                continue;
            }
            if (this.attrList.name[i2] != "xmlns") continue;
            this.attrList.namespace[i2] = "http://www.w3.org/2000/xmlns/";
        }
    }

    String resolveNS(String string) {
        if (string == "xml") {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String string2 = this.namespaceMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    void checkNames(XMLError xMLError) throws XMLParseException {
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces") {
            return this.namespaceFeature;
        }
        if (string == "http://xml.org/sax/features/namespace-prefixes") {
            return this.namespacePrefixFeature;
        }
        if (string == "http://xml.org/sax/features/string-interning") {
            return this.stringInternFeature;
        }
        if (string == "http://xml.org/sax/features/validation") {
            return this.valMode != 0;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            return true;
        }
        if (string == "http://xml.org/sax/features/external-parameter-entities") {
            return true;
        }
        if (string == "http://xml.org/sax/features/use-locator2") {
            return true;
        }
        throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ((string = string.intern()) == "http://xml.org/sax/features/namespaces" || string == "http://xml.org/sax/features/namespace-prefixes" || string == "http://xml.org/sax/features/string-interning" || string == "http://xml.org/sax/features/validation") {
            if (this.parsing) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
            if (string == "http://xml.org/sax/features/namespaces") {
                this.namespaceFeature = bl;
            } else if (string == "http://xml.org/sax/features/namespace-prefixes") {
                this.namespacePrefixFeature = bl;
            } else if (string == "http://xml.org/sax/features/string-interning") {
                this.stringInternFeature = bl;
            }
            return;
        }
        if (string == "http://xml.org/sax/features/external-general-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else if (string == "http://xml.org/sax/features/external-parameter-entities") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else if (string == "http://xml.org/sax/features/use-locator2") {
            if (!bl) {
                throw new SAXNotSupportedException(this.err.getMessage1(501, string));
            }
        } else {
            throw new SAXNotRecognizedException(this.err.getMessage1(500, string));
        }
    }

    void setIgnoringComments(boolean bl) {
        this.isIgnoringComments = bl;
    }

    static {
        entityDepthProperty = XMLUtil.getProperty("oracle.xdkjava.security.entityExpansionDepth");
    }
}

