/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import oracle.xml.parser.v2.XMLByteReader;

class XMLUTF8Reader
extends XMLByteReader {
    boolean fourByte;
    private int saveFourByte;
    private boolean allowIllegalUTF8Encoding = false;

    XMLUTF8Reader(InputStream inputStream, String string, String string2) {
        super(inputStream, string, string2);
    }

    @Override
    void reset() {
        this.fourByte = false;
        this.saveFourByte = -1;
        super.reset();
    }

    @Override
    void fillBuffer() throws IOException {
        int n2 = this.byteIndex;
        int n3 = this.endPos;
        while (n3 < this.BUFSIZE) {
            int n4;
            if (n2 == this.BUFSIZE) {
                this.byteIndex = n2;
                this.fillByteBuffer();
                n2 = this.byteIndex;
            }
            if ((n4 = this.byteBuffer[n2] & 0xFF) < 128) {
                ++n2;
                if (n4 == 13 || n4 == 10) {
                    if (n4 == 13) {
                        if (n2 == this.BUFSIZE) {
                            this.byteIndex = n2;
                            this.fillByteBuffer();
                            n2 = this.byteIndex;
                        }
                        if (this.byteBuffer[n2] == 10) {
                            ++n2;
                        }
                    }
                    this.charBuffer[n3] = 10;
                    this.setLineNumber(n3);
                    ++n3;
                    continue;
                }
                this.charBuffer[n3] = (char)n4;
                ++n3;
                continue;
            }
            if (this.allowIllegalUTF8Encoding && n4 < 192) {
                byte by = this.byteBuffer[n2++];
                this.charBuffer[n3++] = (char)by;
                continue;
            }
            if (n4 < 255) {
                if (n2 + 4 >= this.BUFSIZE && this.eofIndex > this.BUFSIZE) {
                    this.byteIndex = n2;
                    this.fillByteBuffer();
                    n2 = this.byteIndex;
                }
                n2 += this.readUTF8Char(n2, n3);
                ++n3;
                continue;
            }
            if (n2 >= this.eofIndex) {
                this.charBuffer[n3] = 65535;
                this.charsRead += (long)(n3 - this.endPos);
                this.eofPos = n3;
                this.endPos = n3;
                this.byteIndex = n2;
                return;
            }
            n2 += this.readUTF8Char(n2, n3);
            ++n3;
        }
        this.byteIndex = n2;
        this.charsRead += (long)(n3 - this.endPos);
        this.endPos = n3;
    }

    void checkUTF8Byte(int n2, int n3) throws IOException {
        for (int i2 = 1; i2 <= n3; ++i2) {
            if ((this.byteBuffer[n2 + i2] & 0xC0) == 128) continue;
            throw new UTFDataFormatException(this.err.getMessage0(170));
        }
    }

    int readUTF8Char(int n2, int n3) throws IOException {
        if ((this.byteBuffer[n2] & 0xE0) == 192) {
            this.checkUTF8Byte(n2, 1);
            int n4 = ((this.byteBuffer[n2] & 0x1F) << 6) + (this.byteBuffer[n2 + 1] & 0x3F);
            if (n4 < 128) {
                throw new UTFDataFormatException(this.err.getMessage1(171, n4 + ""));
            }
            this.charBuffer[n3] = (char)n4;
            return 2;
        }
        if ((this.byteBuffer[n2] & 0xF0) == 224) {
            this.checkUTF8Byte(n2, 2);
            int n5 = ((this.byteBuffer[n2] & 0xF) << 12) + ((this.byteBuffer[n2 + 1] & 0x3F) << 6) + (this.byteBuffer[n2 + 2] & 0x3F);
            if (n5 >= 55296 && n5 < 57344 || n5 == 65535 || n5 == 65534 || n5 < 2048) {
                String string = this.err.getMessage1(171, Integer.toHexString(n5));
                throw new UTFDataFormatException(string);
            }
            this.charBuffer[n3] = (char)n5;
            return 3;
        }
        if ((this.byteBuffer[n2] & 0xF8) == 240) {
            int n6 = 4;
            this.checkUTF8Byte(n2, 3);
            int n7 = ((this.byteBuffer[n2] & 7) << 18) + ((this.byteBuffer[n2 + 1] & 0x3F) << 12) + ((this.byteBuffer[n2 + 2] & 0x3F) << 6) + (this.byteBuffer[n2 + 3] & 0x3F);
            if (n7 >= 65536 && n7 <= 0x10FFFF) {
                if (!this.fourByte) {
                    n7 = (n7 - 65536 >> 10) + 55296;
                    this.fourByte = true;
                    n6 = 0;
                } else {
                    n7 = (n7 - 65536 & 0x3FF) + 56320;
                    this.fourByte = false;
                }
            } else {
                String string = this.err.getMessage1(171, Integer.toHexString(n7));
                throw new UTFDataFormatException(string);
            }
            this.charBuffer[n3] = (char)n7;
            return n6;
        }
        if ((this.byteBuffer[n2] & 0xFC) == 248) {
            throw new UTFDataFormatException(this.err.getMessage0(172));
        }
        if ((this.byteBuffer[n2] & 0xFE) == 252) {
            throw new UTFDataFormatException(this.err.getMessage0(173));
        }
        throw new UTFDataFormatException(this.err.getMessage0(170));
    }

    final void setAllowIllegalUTF8Encoding(boolean bl) {
        this.allowIllegalUTF8Encoding = bl;
    }

    final boolean isAllowIllegalUTF8Encoding() {
        return this.allowIllegalUTF8Encoding;
    }
}

