/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.BLOB;
import oracle.xml.scalable.AbstractPageManager;
import oracle.xml.scalable.PageManager;

public class BlobPageManager
extends AbstractPageManager {
    BLOB blob;
    long blobOffset;

    public BlobPageManager(Connection connection) throws SQLException {
        this.blob = BLOB.createTemporary(connection, true, 12);
        this.blob.open(1);
        this.init();
    }

    @Override
    public void seek(long l2) throws IOException {
        this.blobOffset = l2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4 = n3;
            InputStream inputStream = this.blob.getBinaryStream(this.blobOffset);
            while (n4 > 0) {
                int n5 = inputStream.read(byArray, n2, n4);
                if (n5 == -1) {
                    return n3 - n4;
                }
                this.blobOffset += (long)n5;
                n4 -= n5;
                n2 += n5;
            }
            inputStream.close();
            return n3;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            OutputStream outputStream = this.blob.setBinaryStream(this.blobOffset);
            outputStream.write(byArray, n2, n3);
            this.blobOffset += (long)n3;
            outputStream.close();
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    @Override
    public void deletePage(PageManager.PageId pageId) {
        long l2 = this.lastOffset;
        super.deletePage(pageId);
        try {
            if (l2 != this.lastOffset) {
                this.blob.truncate(this.lastOffset);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.blob.close();
            BLOB.freeTemporary(this.blob);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

