/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

public class Queue {
    private int max;
    private Object[] queue;
    private int front;
    private int rear;

    public Queue(int n2) {
        this.max = n2 + 1;
        this.queue = new Object[this.max];
        this.front = 0;
        this.rear = -1;
    }

    public void insert(Object object) {
        if (!this.isFull()) {
            if (this.rear == this.max - 1) {
                this.rear = -1;
            }
        } else {
            int n2 = this.max - 1;
            Object[] objectArray = new Object[n2 * 2 + 1];
            System.arraycopy(this.queue, 0, objectArray, 0, n2);
            this.max = n2 * 2 + 1;
            this.queue = objectArray;
        }
        this.queue[++this.rear] = object;
    }

    public Object remove() {
        Object object = this.queue[this.front++];
        if (this.front == this.max) {
            this.front = 0;
        }
        return object;
    }

    public Object peek() {
        return this.queue[this.front];
    }

    public Object peek(int n2) {
        return this.queue[this.front + n2];
    }

    public boolean isEmpty() {
        return this.rear + 1 == this.front || this.front + this.max - 1 == this.rear;
    }

    public boolean isFull() {
        return this.rear + 2 == this.front || this.front + this.max - 2 == this.rear;
    }

    public int size() {
        if (this.rear >= this.front) {
            return this.rear - this.front + 1;
        }
        return this.max - this.front + this.rear + 1;
    }
}

