/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.xml.util.XMLError;

public class XMLException
extends Exception {
    private XMLError error;
    private String mesg;
    private String sysId;
    private String pubId;
    private int type;
    private Exception exception;
    public static final int ERROR = 1;
    public static final int FATAL_ERROR = 0;
    public static final int WARNING = 2;

    XMLException() {
    }

    public XMLException(String string, Throwable throwable) {
        this.mesg = string;
        if (throwable instanceof Exception) {
            this.exception = (Exception)throwable;
        }
    }

    public XMLException(String string, String string2, String string3, int n2, int n3, int n4) {
        super(string);
        this.pubId = string2;
        this.sysId = string3;
        this.mesg = string;
        this.type = n4;
    }

    public XMLException(XMLError xMLError, int n2) {
        super(xMLError.formatErrorMesg(n2));
        this.error = xMLError;
        this.exception = xMLError.getException(n2);
    }

    public XMLException(XMLError xMLError, int n2, Exception exception) {
        super(xMLError.formatErrorMesg(n2));
        this.exception = exception;
        this.error = xMLError;
    }

    public XMLException(XMLError xMLError, Exception exception) {
        super(xMLError.formatErrorMesg(0));
        this.exception = exception;
        this.error = xMLError;
    }

    public int getNumMessages() {
        if (this.error == null) {
            return 1;
        }
        return this.error.nerrors;
    }

    public String getMessage(int n2) {
        if (this.error == null) {
            return this.mesg;
        }
        return this.error.mesg[n2];
    }

    public String formatErrorMessage(int n2) {
        if (this.error == null) {
            return this.mesg;
        }
        return this.error.formatErrorMesg(n2);
    }

    public int getLineNumber(int n2) {
        if (this.error == null) {
            return 0;
        }
        return this.error.line[n2];
    }

    public int getColumnNumber(int n2) {
        if (this.error == null) {
            return 0;
        }
        return this.error.col[n2];
    }

    public String getSystemId(int n2) {
        if (this.error == null) {
            return null;
        }
        return this.error.sysId[n2];
    }

    public String getPublicId(int n2) {
        if (this.error == null) {
            return this.pubId;
        }
        return this.error.pubId[n2];
    }

    public Exception getException(int n2) {
        if (this.error == null) {
            return this.exception;
        }
        return this.error.exp[n2];
    }

    @Override
    public Throwable getCause() {
        if (this.error == null) {
            return this.exception;
        }
        return this.error.lastExp;
    }

    public int getMessageType(int n2) {
        if (this.error == null) {
            return this.type;
        }
        return this.error.types[n2];
    }

    @Override
    public void printStackTrace() {
        if (this.exception != null) {
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        if (this.exception != null) {
            this.exception.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.exception != null) {
            this.exception.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }

    @Override
    public String toString() {
        if (this.exception != null) {
            return this.exception.toString();
        }
        return super.toString();
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        if (throwable instanceof Exception) {
            this.exception = (Exception)throwable;
        }
        return this;
    }

    public XMLError getXMLError() {
        return this.error;
    }
}

