/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.xpath.JXPathFunction;
import oracle.xml.xpath.XMLPathTable;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathCompileEventsHandler;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;

public class JXPathContext
implements NSResolver {
    NamespaceContext context;
    XPathFunctionResolver funcResolver;
    XMLSchema xmlschema;
    XMLPathTable pathtable;
    XPathCompileEvents xpce;

    public JXPathContext(NamespaceContext namespaceContext, XPathFunctionResolver xPathFunctionResolver) {
        this.context = namespaceContext;
        this.funcResolver = xPathFunctionResolver;
    }

    void setXPathCompileEventsHandler(XPathCompileEventsHandler xPathCompileEventsHandler) {
        if (this.xpce == null) {
            this.xpce = new XPathCompileEvents();
        }
        this.xpce.setXPathCompileEventsHandler(xPathCompileEventsHandler);
    }

    XPathCompileEvents getXPathCompileEvents() {
        return this.xpce;
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.xmlschema = xMLSchema;
    }

    void setXMLPathTable(XMLPathTable xMLPathTable) {
        this.pathtable = xMLPathTable;
    }

    XMLPathTable getXMLPathTable() {
        return this.pathtable;
    }

    XMLSchema getXMLSchema() {
        return this.xmlschema;
    }

    @Override
    public String resolveNamespacePrefix(String string) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.context != null) {
            return this.context.getNamespaceURI(string);
        }
        return null;
    }

    public OXMLFunction getFunction(String string, String string2, int n2) {
        XPathFunction xPathFunction;
        if (this.funcResolver != null && (xPathFunction = this.funcResolver.resolveFunction(new QName(string, string2), n2)) != null) {
            if (xPathFunction instanceof OXMLFunction) {
                return (OXMLFunction)((Object)xPathFunction);
            }
            return new JXFunction(xPathFunction, string2, n2);
        }
        return null;
    }

    class JXFunction
    extends OXMLFunction {
        XPathFunction function;
        String funcName;
        int numArgs;

        JXFunction(XPathFunction xPathFunction, String string, int n2) {
            this.function = xPathFunction;
            this.funcName = string;
            this.numArgs = n2;
        }

        @Override
        public String getFunctionName() {
            return this.funcName;
        }

        @Override
        public int getNumberArgs() {
            return this.numArgs;
        }

        @Override
        public OXMLSequenceType getReturnType() {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }

        @Override
        public OXMLSequenceType getArgType(int n2) {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }

        @Override
        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.numArgs);
            for (int i2 = 0; i2 < this.numArgs; ++i2) {
                arrayList.add(((XPathSequence)oXMLSequenceArray[i2]).getObjectValue());
            }
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        @Override
        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(((XPathSequence)oXMLSequence).getObjectValue());
            arrayList.add(((XPathSequence)oXMLSequence2).getObjectValue());
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        @Override
        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(((XPathSequence)oXMLSequence).getObjectValue());
            return this.invoke(arrayList, oXMLFunctionContext);
        }

        @Override
        public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext) throws XQException {
            return this.invoke(null, oXMLFunctionContext);
        }

        private OXMLSequence invoke(List list, OXMLFunctionContext oXMLFunctionContext) throws XQException {
            Object object = null;
            try {
                object = this.function instanceof JXPathFunction ? ((JXPathFunction)((Object)this.function)).evaluate(((XPathRuntimeContext)oXMLFunctionContext).getXPathContext(), list) : this.function.evaluate(list);
                OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
                if (((XPathSequence)oXMLSequence).setObjectValue(object)) {
                    return oXMLSequence;
                }
                throw new XQException("FOTY0001");
            }
            catch (XPathFunctionException xPathFunctionException) {
                throw new XQException(xPathFunctionException.getMessage(), xPathFunctionException);
            }
        }
    }
}

