/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathError;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xslt.XSLException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

class StreamNodeSequence
implements StreamingSequence {
    XMLNode curNode = null;
    StreamNodeSequence ctxSeq = null;
    int axistype = -1;
    XPathStep step = null;
    XPathRuntimeContext context;
    int[] posArray = null;
    boolean started = false;

    StreamNodeSequence(XPathStep xPathStep, XPathRuntimeContext xPathRuntimeContext, StreamNodeSequence object, XMLNode xMLNode) {
        if (xPathStep != null) {
            Object object2;
            this.step = xPathStep;
            this.axistype = xPathStep.getAxisType();
            if (this.step.prevSeparator == 6) {
                if (this.axistype == 2) {
                    object2 = new StreamNodeSequence(null, xPathRuntimeContext, (StreamNodeSequence)object, null);
                    ((StreamNodeSequence)object2).axistype = 5;
                    object = object2;
                } else {
                    this.axistype = this.axistype == 11 ? 5 : 4;
                }
            }
            if ((object2 = xPathStep.predicates) != null && ((XPathPredicate)object2).checkPosLastFN() > 0) {
                int n2 = ((XPathPredicate)object2).predicateSize;
                this.posArray = new int[n2];
            }
        }
        this.context = xPathRuntimeContext;
        this.ctxSeq = object;
        if (xMLNode != null) {
            this.curNode = xMLNode;
        }
    }

    void reset(XMLNode xMLNode) {
        this.started = false;
        if (this.ctxSeq != null) {
            this.ctxSeq.reset(xMLNode);
        } else {
            this.curNode = xMLNode;
        }
    }

    @Override
    public boolean isDone() {
        return this.started && this.curNode == null;
    }

    void resetPosArray() {
        for (int i2 = 0; i2 < this.posArray.length; ++i2) {
            this.posArray[i2] = 0;
        }
    }

    @Override
    public boolean next() throws XSLException {
        XMLNode xMLNode = null;
        boolean bl = false;
        switch (this.axistype) {
            case 4: 
            case 5: {
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        this.curNode = xMLNode;
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        if (this.axistype == 5) {
                            if (this.step == null) {
                                return true;
                            }
                            if ((this.step.anyNode || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                                return true;
                            }
                        }
                    }
                    XMLNode xMLNode2 = this.curNode;
                    while (this.curNode != null) {
                        this.curNode = (XMLNode)xMLNode2.getFirstChild();
                        while (this.curNode == null && !xMLNode2.isSameNode(xMLNode)) {
                            this.curNode = (XMLNode)xMLNode2.getNextSibling();
                            if (this.curNode != null) continue;
                            xMLNode2 = (XMLNode)xMLNode2.getParentNode();
                        }
                        if (this.curNode == null) continue;
                        if (this.step == null) {
                            return true;
                        }
                        if ((this.step.anyNode && !(this.curNode instanceof DocumentType) || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                            return true;
                        }
                        xMLNode2 = this.curNode;
                    }
                    this.ctxSeq.next();
                    xMLNode = this.ctxSeq.getNode();
                }
                return false;
            }
            case 3: {
                XMLNode xMLNode3 = null;
                boolean bl2 = true;
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        xMLNode3 = xMLNode;
                        this.curNode = (XMLNode)xMLNode.getFirstChild();
                        if (this.curNode == null) {
                            bl2 = false;
                        }
                    } else {
                        xMLNode3 = this.curNode;
                        this.curNode = (XMLNode)this.curNode.getNextSibling();
                    }
                    while (this.curNode != null) {
                        xMLNode3 = this.curNode;
                        if ((this.step.anyNode && !(this.curNode instanceof DocumentType) || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                            return true;
                        }
                        this.curNode = (XMLNode)this.curNode.getNextSibling();
                    }
                    if (this.ctxSeq.next()) {
                        xMLNode = this.ctxSeq.getNode();
                        continue;
                    }
                    xMLNode = null;
                }
                return this.createNode(xMLNode3, bl2);
            }
            case 11: {
                while (this.ctxSeq.next()) {
                    this.curNode = this.ctxSeq.getNode();
                    if (this.posArray != null) {
                        this.resetPosArray();
                    }
                    if (!this.step.anyNode && !this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name) || this.step.predicates != null && !this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context)) continue;
                    return true;
                }
                this.curNode = null;
                return false;
            }
            case 2: {
                boolean bl3 = false;
                XMLNode xMLNode4 = null;
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                    xMLNode4 = this.ctxSeq.getNode();
                }
                xMLNode = this.ctxSeq.getNode();
                while (xMLNode != null) {
                    if (this.curNode == null) {
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        if (xMLNode instanceof XMLElement) {
                            this.curNode = ((XMLElement)xMLNode).getFirstAttribute();
                        }
                    } else {
                        this.curNode = ((XMLAttr)this.curNode).getNextAttribute();
                    }
                    while (this.curNode != null) {
                        if (!this.curNode.isNodeFlag(262144) && (this.step.anyNode || this.curNode.checkTypeNSName(this.step.nodeType, this.step.nameSpace, this.step.name)) && (this.step.predicates == null || this.step.predicates.filterStreamNode(this.curNode, this.posArray, this.context))) {
                            bl3 = true;
                            return true;
                        }
                        this.curNode = ((XMLAttr)this.curNode).getNextAttribute();
                    }
                    if (this.ctxSeq.next()) {
                        xMLNode4 = xMLNode = this.ctxSeq.getNode();
                        continue;
                    }
                    xMLNode = null;
                }
                if (!bl3 && this.context.getCreateNode() && xMLNode4 instanceof XMLElement) {
                    ((XMLElement)xMLNode4).setAttributeNS(this.step.nameSpace, this.step.name, "");
                    this.curNode = (XMLAttr)((XMLElement)xMLNode4).getAttributeNodeNS(this.step.nameSpace, this.step.name);
                    return true;
                }
                return false;
            }
            case -1: {
                if (this.started) {
                    this.curNode = null;
                    return false;
                }
                this.started = true;
                return true;
            }
        }
        return false;
    }

    boolean createNode(XMLNode xMLNode, boolean bl) throws XSLException {
        if (this.context.getCreateNode()) {
            Node node = null;
            node = xMLNode != null && bl ? xMLNode.getParentNode() : xMLNode;
            boolean bl2 = false;
            if (node != null && node instanceof XMLElement) {
                XMLDocument xMLDocument = ((XMLElement)node).getDocument();
                int n2 = 1;
                if (this.step.predicates != null && (n2 = this.step.predicates.getPosition(this.context)) < 1) {
                    n2 = 1;
                }
                int n3 = ((XMLElement)node).getChildrenByTagName(this.step.name, this.step.nameSpace).getLength();
                n2 -= n3;
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.curNode = (XMLElement)xMLDocument.createElementNS(this.step.nameSpace, this.step.name);
                    node.appendChild(this.curNode);
                    bl2 = true;
                }
            }
            return bl2;
        }
        if (this.context.getEnableException()) {
            if (this.context.getXPathContext() == null) {
                return false;
            }
            Node node = null;
            node = xMLNode != null && bl ? xMLNode.getParentNode() : xMLNode;
            int n4 = ((XMLElement)node).getChildrenByTagName(this.step.name, this.step.nameSpace).getLength();
            int n5 = 1;
            if (this.step.predicates != null && this.step.predicates.getPositionTest() > 0) {
                n5 = this.step.predicates.getPositionTest();
            }
            if (n5 > n4) {
                XPathError xPathError = new XPathError();
                xPathError.setMissingNode(new QName(this.step.nameSpace, this.step.name));
                xPathError.setXpath(this.createXPath());
                if (node != null && node instanceof XMLDocument) {
                    this.context.getXPathContext().setError(xPathError);
                } else if (node != null && node instanceof XMLElement) {
                    if (this.step.predicates != null && this.step.predicates.getPositionTest() != 0) {
                        xPathError.setPosition(this.step.predicates.getPositionTest());
                    }
                    xPathError.setParentNode(new QName(((XMLElement)node).getNamespaceURI(), ((XMLElement)node).getLocalName()));
                    this.context.getXPathContext().setError(xPathError);
                }
            }
        }
        return false;
    }

    private String createXPath() {
        String string = "";
        String string2 = "";
        StreamNodeSequence streamNodeSequence = this;
        do {
            if (streamNodeSequence.step == null) continue;
            string2 = "/" + streamNodeSequence.step.name;
            if (streamNodeSequence.step.predicates != null && streamNodeSequence.step.predicates.getPositionTest() > 0) {
                string2 = string2 + "[" + streamNodeSequence.step.predicates.getPositionTest() + "]";
            }
            string = string2 + string;
        } while ((streamNodeSequence = streamNodeSequence.ctxSeq) != null);
        return string;
    }

    @Override
    public XMLNode getNode() {
        return this.curNode;
    }
}

