/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.math.BigDecimal;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class XPathConstantExpr
extends XSLExprBase {
    final OXMLItem priExprValue = new XPathItem();
    String normalizedStr;
    private boolean emptySeq = false;

    XPathConstantExpr() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        String string;
        XPathConstantExpr xPathConstantExpr;
        int n2 = xSLParseString.peekToken();
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        if (n2 == 109) {
            xPathConstantExpr = new XPathConstantExpr();
            xSLParseString.nextToken();
            string = xSLParseString.getLiteralValue();
            int n3 = xSLParseString.getLiteralType();
            if (n3 == 303) {
                xPathConstantExpr.setExprType(2);
                xPathConstantExpr.normalizedStr = string;
                xPathConstantExpr.priExprValue.setString(OXMLSequenceType.TSTRING, xPathConstantExpr.normalizedStr);
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithStringParam(123, 2, xPathConstantExpr.normalizedStr, null, null);
                }
                xPathConstantExpr.normalizedStr = "\"" + xPathConstantExpr.normalizedStr + "\"";
            } else if (n3 == 302) {
                xPathConstantExpr.setExprType(32);
                if (XSLExpr.isXPath20Compatible(xSLParseString)) {
                    BigDecimal bigDecimal = new BigDecimal(string);
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsWithDoubleParam(125, 2, 0.0, bigDecimal);
                        xPathCompileEvents.reportEventsWithDoubleParam(237, 2, 0.0, bigDecimal);
                    }
                    xPathConstantExpr.priExprValue.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                } else {
                    double d2 = Double.parseDouble(string);
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsWithDoubleParam(124, 2, d2, null);
                        xPathCompileEvents.reportEventsWithDoubleParam(238, 2, d2, null);
                    }
                    xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d2);
                }
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            } else if (n3 == 301) {
                xPathConstantExpr.setExprType(16);
                double d3 = Double.parseDouble(string);
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithDoubleParam(124, 2, d3, null);
                    xPathCompileEvents.reportEventsWithDoubleParam(238, 2, d3, null);
                }
                xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d3);
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            } else if (n3 == 300) {
                xPathConstantExpr.setExprType(0x100000);
                if (XSLExpr.isXPath20Compatible(xSLParseString)) {
                    try {
                        Integer n4 = Integer.parseInt(string);
                        if (xPathCompileEvents != null) {
                            xPathCompileEvents.reportEventsWithIntParam(126, 2, n4, 0);
                            xPathCompileEvents.reportEventsWithIntParam(236, 2, n4, 0);
                        }
                        xPathConstantExpr.priExprValue.setInt(OXMLSequenceType.TINTEGER, n4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        if (xPathCompileEvents != null) {
                            xPathCompileEvents.reportEventsWithDoubleParam(125, 2, 0.0, bigDecimal);
                            xPathCompileEvents.reportEventsWithDoubleParam(237, 2, 0.0, bigDecimal);
                        }
                        xPathConstantExpr.priExprValue.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    }
                } else {
                    double d4 = Double.parseDouble(string);
                    if (xPathCompileEvents != null) {
                        xPathCompileEvents.reportEventsWithDoubleParam(124, 2, d4, null);
                        xPathCompileEvents.reportEventsWithDoubleParam(238, 2, d4, null);
                    }
                    xPathConstantExpr.priExprValue.setDouble(OXMLSequenceType.TDOUBLE, d4);
                }
                xPathConstantExpr.normalizedStr = "\"" + string + "\"";
            }
        } else if (n2 == 113) {
            string = xSLParseString.getLocalName();
            if (xSLParseString.getFunctionType() == 600 && (string.equals("true") || string.equals("false"))) {
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsWithStringParam(108, 0, xSLParseString.getNamespace(), string, null);
                }
                xSLParseString.nextToken();
                if (xSLParseString.nextToken() != 26) {
                    throw new XPathException(1019, ")", xSLParseString.getCurrentToken());
                }
                xPathConstantExpr = new XPathConstantExpr();
                xPathConstantExpr.setExprType(4);
                ((XPathItem)xPathConstantExpr.priExprValue).setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
                int n5 = xSLParseString.lookUp(string, XSLParseString.functionnames);
                xPathConstantExpr.normalizedStr = n5 + "()";
                xPathConstantExpr.priExprValue.setBoolean(OXMLSequenceType.TBOOLEAN, string.equals("true"));
                if (xPathCompileEvents != null) {
                    xPathCompileEvents.reportEventsNoParam(108, 1);
                }
            } else {
                xPathConstantExpr = null;
            }
        } else {
            xPathConstantExpr = null;
        }
        if (xPathConstantExpr == null || xPathConstantExpr.exprType == 0) {
            string = "expr: " + xPathConstantExpr + (xPathConstantExpr == null ? "" : "  type: " + xPathConstantExpr.exprType);
            throw new IllegalStateException(string);
        }
        xPathConstantExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
        return xPathConstantExpr;
    }

    @Override
    XSLExprBase createCachedExpr() {
        return this;
    }

    @Override
    void cacheSubExpr() {
    }

    @Override
    boolean canCacheExpr() {
        return true;
    }

    @Override
    public boolean isRelIndependent() {
        return true;
    }

    @Override
    public String getNormalizedExpr() {
        return this.normalizedStr;
    }

    void setEmptySequence() {
        this.emptySeq = true;
    }

    @Override
    int checkPosLastFN() {
        this.flag = 0;
        return 0;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        if (this.emptySeq) {
            xPathRuntimeContext.pushExprValue().reset();
            return;
        }
        XPathItem xPathItem = xPathRuntimeContext.allocItem();
        xPathItem.copyItem(this.priExprValue);
        xPathRuntimeContext.pushExprValue().appendItem(xPathItem);
    }

    int getPositionValue() {
        if (super.isExprType(1048632)) {
            return (int)XPathItem.getNumberValue(this.priExprValue);
        }
        return 0;
    }

    OXMLItem getValue() {
        return this.priExprValue;
    }
}

