/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import oracle.i18n.text.OraCollator;
import oracle.xml.xqxp.XQException;

public abstract class OXMLCollator {
    public static final OXMLCollator CODE_POINT_COLLATOR = new OXMLCodePointCollator();

    public static OXMLCollator newInstance(Object object) throws XQException {
        if (object instanceof Collator) {
            return new OXMLJavaCollator((Collator)object);
        }
        if (object instanceof OraCollator) {
            return new OXMLOraCollator((OraCollator)object);
        }
        throw new XQException("FOCH0002");
    }

    public abstract int compare(String var1, String var2);

    public abstract int match(String var1, String var2, boolean var3);

    static class OXMLCodePointCollator
    extends OXMLCollator {
        OXMLCodePointCollator() {
        }

        @Override
        public int compare(String string, String string2) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = 0;
            int n5 = 0;
            while (n4 < n2 && n5 < n3) {
                int n6;
                int n7 = string.codePointAt(n4);
                if (n7 < (n6 = string2.codePointAt(n5))) {
                    return -1;
                }
                if (n7 > n6) {
                    return 1;
                }
                if (Character.isSupplementaryCodePoint(n7)) {
                    n4 += 2;
                    n5 += 2;
                    continue;
                }
                ++n4;
                ++n5;
            }
            if (n2 == n3) {
                return 0;
            }
            if (n2 < n3) {
                return -1;
            }
            return 1;
        }

        @Override
        public int match(String string, String string2, boolean bl) {
            if (bl) {
                return string.indexOf(string2);
            }
            return string.lastIndexOf(string2);
        }
    }

    static class OXMLOraCollator
    extends OXMLCollator {
        OraCollator collator;

        OXMLOraCollator(OraCollator oraCollator) {
            this.collator = oraCollator;
        }

        @Override
        public int compare(String string, String string2) {
            return this.collator.compare(string, string2);
        }

        @Override
        public int match(String string, String string2, boolean bl) throws XQException {
            if (bl) {
                return this.collator.matchFirst(string, string2)[0];
            }
            return this.collator.matchLast(string, string2)[1] - string2.length();
        }
    }

    static class OXMLJavaCollator
    extends OXMLCollator {
        Collator collator;
        boolean ruleBased = false;

        OXMLJavaCollator(Collator collator) {
            this.collator = collator;
            this.ruleBased = collator instanceof RuleBasedCollator;
        }

        @Override
        public int compare(String string, String string2) {
            return this.collator.compare(string, string2);
        }

        @Override
        public int match(String string, String string2, boolean bl) {
            if (!this.ruleBased) {
                throw new XQException();
            }
            CollationElementIterator collationElementIterator = ((RuleBasedCollator)this.collator).getCollationElementIterator(string);
            CollationElementIterator collationElementIterator2 = ((RuleBasedCollator)this.collator).getCollationElementIterator(string2);
            if (this.isEmpty(collationElementIterator2)) {
                return collationElementIterator.getOffset();
            }
            int n2 = 0;
            block0: while (true) {
                int n3;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                while (true) {
                    int n7;
                    n3 = collationElementIterator.getOffset();
                    int n8 = collationElementIterator.next();
                    if (n8 == -1) {
                        if (!this.isEmpty(collationElementIterator2)) {
                            return -1;
                        }
                        return this.getResult(bl, collationElementIterator, n5, n6);
                    }
                    if (n8 == 0) continue;
                    do {
                        if ((n7 = collationElementIterator2.next()) != -1) continue;
                        return this.getResult(bl, collationElementIterator, n5, n6);
                    } while (n7 == 0);
                    if (n7 != n8) break;
                    if (n4 == 0) {
                        n5 = n3;
                    }
                    n6 = n3;
                    ++n4;
                }
                collationElementIterator2.reset();
                collationElementIterator.reset();
                ++n2;
                n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block0;
                    collationElementIterator.next();
                    ++n3;
                }
                break;
            }
        }

        private int getResult(boolean bl, CollationElementIterator collationElementIterator, int n2, int n3) {
            if (bl) {
                return n2;
            }
            collationElementIterator.setOffset(n3);
            collationElementIterator.next();
            return collationElementIterator.getOffset();
        }

        private boolean isEmpty(CollationElementIterator collationElementIterator) {
            int n2;
            while ((n2 = collationElementIterator.next()) != -1) {
                if (n2 == 0) continue;
                collationElementIterator.reset();
                return false;
            }
            collationElementIterator.reset();
            return true;
        }
    }
}

