/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTICompressor
implements XTIConstants {
    static byte[] compressXTINPage(byte[] byArray, int n2) throws XTIException {
        byte[] byArray2 = new byte[4096];
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        if (n2 == 0) {
            XTICompressor.compressRootPage(byArray, byArray2);
            return byArray2;
        }
        block7: for (int i2 = 0; i2 < 4096 && bl; i2 += 32) {
            n3 = byArray[i2] & 0xF;
            switch (n3) {
                case 2: {
                    n4 = XTICompressor.compressAttributeNode(byArray, byArray2, i2, n4, n2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 8: {
                    if (n3 == 4) {
                        boolean bl2 = false;
                    }
                    n4 = XTICompressor.compressTextNode(byArray, byArray2, i2, n4, n2);
                    continue block7;
                }
                case 9: 
                case 11: {
                    n4 = XTICompressor.compressDocumentFragment(byArray, byArray2, i2, n4, n2);
                    continue block7;
                }
                case 1: {
                    n4 = XTICompressor.compressElementNode(byArray, byArray2, i2, n4, n2);
                    continue block7;
                }
                case 7: {
                    n4 = XTICompressor.compressPINode(byArray, byArray2, i2, n4, n2);
                    continue block7;
                }
                default: {
                    bl = false;
                }
            }
        }
        return byArray2;
    }

    static void compressRootPage(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 4096);
    }

    static int compressDocumentFragment(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        byArray2[n3] = byArray[n2];
        byte by = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 12, n3 + 2, n4);
        byArray2[++n3] = by;
        n3 += XTICompressor.getCount(by);
        return ++n3;
    }

    static int compressAttributeNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n3;
        byArray2[n3] = byArray[n2];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n2 + 4, n3 += 3, n4);
        byte by2 = XTICompressor.writeXTICTextAddress(byArray, byArray2, n2 + 12, n3 += XTICompressor.getCount(by), n4);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 20, n3 += XTICompressor.getTextCount(by2), n4);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 24, n3 += XTICompressor.getCount(by3), n4);
        byte by5 = byArray[n2 + 29];
        byArray2[n5 + 1] = (byte)(by << 4 | by2 << 2 | by3);
        byArray2[n5 + 2] = (byte)(by4 << 3 | by5);
        return n3 += XTICompressor.getCount(by4);
    }

    static int compressElementNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n3;
        byArray2[n3] = byArray[n2];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n2 + 4, n3 += 3, n4);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 12, n3 += XTICompressor.getCount(by), n4);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 16, n3 += XTICompressor.getCount(by2), n4);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 20, n3 += XTICompressor.getCount(by3), n4);
        byte by5 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 24, n3 += XTICompressor.getCount(by4), n4);
        byte by6 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 28, n3 += XTICompressor.getCount(by5), n4);
        byArray2[n5 + 1] = (byte)(by << 3 | by2);
        byArray2[n5 + 2] = (byte)(by3 << 6 | by4 << 4 | by5 << 2 | by6);
        return n3 += XTICompressor.getCount(by6);
    }

    static int compressPINode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n3;
        byArray2[n3] = byArray[n2];
        byte by = XTICompressor.writeXTICAddress(byArray, byArray2, n2 + 4, n3 += 3, n4);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 16, n3 += XTICompressor.getCount(by), n4);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 20, n3 += XTICompressor.getCount(by2), n4);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 24, n3 += XTICompressor.getCount(by3), n4);
        byArray2[n5 + 1] = by;
        byArray2[n5 + 2] = (byte)(by2 << 4 | by3 << 2 | by4);
        return n3 += XTICompressor.getCount(by4);
    }

    static int compressTextNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = n3;
        byArray2[n3] = byArray[n2];
        byte by = XTICompressor.writeXTICTextAddress(byArray, byArray2, n2 + 4, n3 += 2, n4);
        byte by2 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 16, n3 += XTICompressor.getTextCount(by), n4);
        byte by3 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 20, n3 += XTICompressor.getCount(by2), n4);
        byte by4 = XTICompressor.writeXTINAddress(byArray, byArray2, n2 + 24, n3 += XTICompressor.getCount(by3), n4);
        byArray2[n5 + 1] = (byte)(by << 6 | by2 << 4 | by3 << 2 | by4);
        return n3 += XTICompressor.getCount(by4);
    }

    private static int getCount(byte by) {
        switch (by) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
        }
        return 0;
    }

    static byte writeXTINAddress(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = XTIUtil.byteArrayToInt(byArray, n2);
        int n6 = (n5 &= Integer.MAX_VALUE) >> 8;
        int n7 = n4 - n6;
        if (n5 == 0) {
            return 0;
        }
        if (n7 == 0) {
            short s2 = (short)(n5 & 0xFF);
            byte[] byArray3 = XTIUtil.shortToByteArray(s2);
            byArray2[n3] = byArray3[0];
            byArray2[n3 + 1] = byArray3[1];
            return 1;
        }
        if (n7 > 0 && n7 <= 128) {
            short s3 = 0;
            s3 = n7 >= 1 ? (short)(n7 - 1) : (short)n7;
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byte[] byArray4 = XTIUtil.shortToByteArray(s3);
            byArray2[n3 + 2] = byArray4[0];
            byArray2[n3 + 3] = byArray4[1];
            return 2;
        }
        byArray2[n3] = byArray[n2];
        byArray2[n3 + 1] = byArray[n2 + 1];
        byArray2[n3 + 2] = byArray[n2 + 2];
        byArray2[n3 + 3] = byArray[n2 + 3];
        return 3;
    }

    static byte writeXTICAddress(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = XTIUtil.byteArrayToInt(byArray, n2 + 4);
        int n6 = XTIUtil.byteArrayToInt(byArray, n2);
        if (n5 == 0 && n6 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            return 1;
        }
        if (n5 == 0 && n6 <= 65535) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 2];
            byArray2[n3 + 3] = byArray[n2 + 3];
            return 2;
        }
        if (n5 <= 255 && n6 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 4];
            byArray2[n3 + 3] = byArray[n2 + 5];
            return 3;
        }
        if (n5 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 2];
            byArray2[n3 + 3] = byArray[n2 + 3];
            byArray2[n3 + 4] = byArray[n2 + 4];
            byArray2[n3 + 5] = byArray[n2 + 5];
            return 4;
        }
        if (n6 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 4];
            byArray2[n3 + 3] = byArray[n2 + 5];
            byArray2[n3 + 4] = byArray[n2 + 6];
            byArray2[n3 + 5] = byArray[n2 + 7];
            return 5;
        }
        byArray2[n3] = byArray[n2];
        byArray2[n3 + 1] = byArray[n2 + 1];
        byArray2[n3 + 2] = byArray[n2 + 2];
        byArray2[n3 + 3] = byArray[n2 + 3];
        byArray2[n3 + 4] = byArray[n2 + 4];
        byArray2[n3 + 5] = byArray[n2 + 5];
        byArray2[n3 + 6] = byArray[n2 + 6];
        byArray2[n3 + 7] = byArray[n2 + 7];
        return 6;
    }

    static byte writeXTICTextAddress(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        int n5 = XTIUtil.byteArrayToInt(byArray, n2 + 4);
        int n6 = XTIUtil.byteArrayToInt(byArray, n2);
        if (n5 == 0 && n6 <= 15) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            return 0;
        }
        if (n5 == 0 && n6 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 2];
            byArray2[n3 + 3] = byArray[n2 + 3];
            return 1;
        }
        if (n5 <= 15 && n6 <= 255) {
            byArray2[n3] = byArray[n2];
            byArray2[n3 + 1] = byArray[n2 + 1];
            byArray2[n3 + 2] = byArray[n2 + 2];
            byArray2[n3 + 3] = byArray[n2 + 3];
            byArray2[n3 + 4] = byArray[n2 + 4];
            byArray2[n3 + 5] = byArray[n2 + 5];
            return 2;
        }
        byArray2[n3] = byArray[n2];
        byArray2[n3 + 1] = byArray[n2 + 1];
        byArray2[n3 + 2] = byArray[n2 + 2];
        byArray2[n3 + 3] = byArray[n2 + 3];
        byArray2[n3 + 4] = byArray[n2 + 4];
        byArray2[n3 + 5] = byArray[n2 + 5];
        byArray2[n3 + 6] = byArray[n2 + 6];
        byArray2[n3 + 7] = byArray[n2 + 7];
        return 3;
    }

    private static int getTextCount(byte by) {
        switch (by) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 8;
            }
        }
        return 0;
    }
}

