/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import oracle.xml.xti.XTIConstants;
import oracle.xml.xti.XTIException;
import oracle.xml.xti.XTIUtil;

public class XTIDecompressor
implements XTIConstants {
    static byte[] uncompressXTINPage(byte[] byArray, int n2) throws XTIException {
        byte[] byArray2 = new byte[8192];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = true;
        if (n2 == 0) {
            XTIDecompressor.decompressRootPage(byArray, byArray2);
            return byArray2;
        }
        while (n3 < 4096 && bl) {
            n4 = byArray[n3] & 0xF;
            switch (n4) {
                case 2: {
                    n3 = XTIDecompressor.decompressAttributeNode(byArray, byArray2, n3, n5, n2);
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    n3 = XTIDecompressor.decompressTextNode(byArray, byArray2, n3, n5, n2);
                    break;
                }
                case 9: 
                case 11: {
                    n3 = XTIDecompressor.decompressDocumentFragment(byArray, byArray2, n3, n5, n2);
                    break;
                }
                case 1: {
                    n3 = XTIDecompressor.decompressElementNode(byArray, byArray2, n3, n5, n2);
                    break;
                }
                case 7: {
                    n3 = XTIDecompressor.decompressPINode(byArray, byArray2, n3, n5, n2);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            ++n5;
        }
        return byArray2;
    }

    static void decompressRootPage(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray, 0, byArray2, 0, 4096);
    }

    static int decompressDocumentFragment(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (byArray[n2] == 0) {
            return ++n2;
        }
        int n5 = 32 * n3;
        byArray2[n5 + 0] = byArray[n2++];
        byte by = byArray[n2++];
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 12, (byte)(by & 3), n4);
        return n2;
    }

    static int decompressAttributeNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (byArray[n2] == 0) {
            return ++n2;
        }
        int n5 = 32 * n3;
        byArray2[n5 + 0] = byArray[n2++];
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        n2 += XTIDecompressor.writeXTICAddress(byArray, byArray2, n2, n5, (byte)((by & 0xF0) >> 4));
        n2 += XTIDecompressor.writeXTICTextAddress(byArray, byArray2, n2, n5 + 12, (byte)((by & 0xC) >> 2));
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 20, (byte)(by & 3), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 24, (byte)((by2 & 0x18) >> 3), n4);
        byArray2[n5 + 28] = (byte)(by2 & 3);
        return n2;
    }

    static int decompressElementNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (byArray[n2] == 0) {
            return ++n2;
        }
        int n5 = 32 * n3;
        byArray2[n5 + 0] = byArray[n2++];
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        n2 += XTIDecompressor.writeXTICAddress(byArray, byArray2, n2, n5, (byte)((by & 0x38) >> 3));
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 12, (byte)(by & 3), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 16, (byte)((by2 & 0xC0) >> 6), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 20, (byte)((by2 & 0x30) >> 4), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 24, (byte)((by2 & 0xC) >> 2), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 28, (byte)(by2 & 3), n4);
        return n2;
    }

    static int decompressPINode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (byArray[n2] == 0) {
            return ++n2;
        }
        int n5 = 32 * n3;
        byArray2[n5 + 0] = byArray[n2++];
        byte by = byArray[n2++];
        byte by2 = byArray[n2++];
        n2 += XTIDecompressor.writeXTICAddress(byArray, byArray2, n2, n5, by);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 16, (byte)((by2 & 0x30) >> 4), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 20, (byte)((by2 & 0xC) >> 2), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 24, (byte)(by2 & 3), n4);
        return n2;
    }

    static int decompressTextNode(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        if (byArray[n2] == 0) {
            return ++n2;
        }
        int n5 = 32 * n3;
        byArray2[n5 + 0] = byArray[n2++];
        byte by = byArray[n2++];
        n2 += XTIDecompressor.writeXTICTextAddress(byArray, byArray2, n2, n5 + 4, (byte)((by & 0xC0) >> 6));
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 16, (byte)((by & 0x30) >> 4), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 20, (byte)((by & 0xC) >> 2), n4);
        n2 += XTIDecompressor.writeXTINAddress(byArray, byArray2, n2, n3, 24, (byte)(by & 3), n4);
        return n2;
    }

    static int writeXTINAddress(byte[] byArray, byte[] byArray2, int n2, int n3, int n4, byte by, int n5) {
        n3 *= 32;
        if (by == 0) {
            return 0;
        }
        if (by == 1) {
            int n6 = XTIUtil.byteArrayToShort(byArray, n2);
            n2 += 2;
            int n7 = 0 | n5 << 8 | n6;
            byte[] byArray3 = XTIUtil.intToByteArray(n7);
            for (int i2 = 0; i2 < 4; ++i2) {
                byArray2[n3 + n4 + i2] = byArray3[i2];
            }
            return 2;
        }
        if (by == 2) {
            byte by2 = byArray[n2++];
            byte by3 = byArray[n2++];
            int n8 = 0;
            n8 = by2 == 0 ? n5 : n5 - (by2 + 1);
            int n9 = 0 | n8 << 8 | by3;
            byte[] byArray4 = XTIUtil.intToByteArray(n9);
            for (int i3 = 0; i3 < 4; ++i3) {
                byArray2[n3 + n4 + i3] = byArray4[i3];
            }
            return 4;
        }
        if (by == 3) {
            byArray2[n3 + n4++] = byArray[n2++];
            byArray2[n3 + n4++] = byArray[n2++];
            byArray2[n3 + n4++] = byArray[n2++];
            byArray2[n3 + n4] = byArray[n2];
            return 4;
        }
        return 0;
    }

    static int writeXTICAddress(byte[] byArray, byte[] byArray2, int n2, int n3, byte by) {
        if (by == 6) {
            byArray2[4 + n3] = byArray[n2++];
            byArray2[5 + n3] = byArray[n2++];
            byArray2[6 + n3] = byArray[n2++];
            byArray2[7 + n3] = byArray[n2++];
            byArray2[8 + n3] = byArray[n2++];
            byArray2[9 + n3] = byArray[n2++];
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 8;
        }
        if (by == 5) {
            byArray2[4 + n3] = byArray[n2++];
            byArray2[5 + n3] = byArray[n2++];
            byArray2[6 + n3] = byArray[n2++];
            byArray2[7 + n3] = byArray[n2++];
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 6;
        }
        if (by == 4) {
            byArray2[6 + n3] = byArray[n2++];
            byArray2[7 + n3] = byArray[n2++];
            byArray2[8 + n3] = byArray[n2++];
            byArray2[9 + n3] = byArray[n2++];
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 6;
        }
        if (by == 3) {
            byArray2[6 + n3] = byArray[n2++];
            byArray2[7 + n3] = byArray[n2++];
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 4;
        }
        if (by == 2) {
            byArray2[8 + n3] = byArray[n2++];
            byArray2[9 + n3] = byArray[n2++];
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 4;
        }
        if (by == 1) {
            byArray2[10 + n3] = byArray[n2++];
            byArray2[11 + n3] = byArray[n2];
            return 2;
        }
        return -1;
    }

    static int writeXTICTextAddress(byte[] byArray, byte[] byArray2, int n2, int n3, byte by) {
        if (by == 3) {
            byArray2[n3] = byArray[n2++];
            byArray2[1 + n3] = byArray[n2++];
            byArray2[2 + n3] = byArray[n2++];
            byArray2[3 + n3] = byArray[n2++];
            byArray2[4 + n3] = byArray[n2++];
            byArray2[5 + n3] = byArray[n2++];
            byArray2[6 + n3] = byArray[n2++];
            byArray2[7 + n3] = byArray[n2];
            return 8;
        }
        if (by == 2) {
            byArray2[n3] = byArray[n2++];
            byArray2[1 + n3] = byArray[n2++];
            byArray2[2 + n3] = byArray[n2++];
            byArray2[3 + n3] = byArray[n2++];
            byArray2[4 + n3] = byArray[n2++];
            byArray2[5 + n3] = byArray[n2];
            return 6;
        }
        if (by == 1) {
            byArray2[n3] = byArray[n2++];
            byArray2[1 + n3] = byArray[n2++];
            byArray2[2 + n3] = byArray[n2++];
            byArray2[3 + n3] = byArray[n2];
            return 4;
        }
        if (by == 0) {
            byArray2[n3] = byArray[n2++];
            byArray2[1 + n3] = byArray[n2];
            return 2;
        }
        return 0;
    }
}

