/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xti;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import oracle.xml.xti.XTIException;

public class XTIUtil {
    static byte[] intToByteArray(int n2) {
        return new byte[]{(byte)(n2 >>> 24), (byte)(n2 >>> 16), (byte)(n2 >>> 8), (byte)n2};
    }

    static byte[] longToByteArray(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    static long byteArrayToLong(byte[] byArray, int n2) {
        long l2 = byArray[n2];
        for (int i2 = 1; i2 < 8; ++i2) {
            l2 = l2 << 8 | (long)(byArray[n2 + i2] & 0xFF);
        }
        return l2;
    }

    static void intToByteArray(int n2, byte[] byArray, int n3) {
        byArray[n3] = (byte)(n2 >>> 24);
        byArray[n3 + 1] = (byte)(n2 >>> 16);
        byArray[n3 + 2] = (byte)(n2 >>> 8);
        byArray[n3 + 3] = (byte)n2;
    }

    static int byteArrayToInt(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 <<= 8;
        n3 |= byArray[n2++] & 0xFF;
        n3 <<= 8;
        n3 |= byArray[n2++] & 0xFF;
        n3 <<= 8;
        return n3 |= byArray[n2] & 0xFF;
    }

    static byte[] shortToByteArray(int n2) {
        return new byte[]{(byte)(n2 >>> 8), (byte)n2};
    }

    static int byteArrayToShort(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 <<= 8;
        return n3 |= byArray[n2] & 0xFF;
    }

    static boolean isPureWhiteSpace(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (cArray[i2] == ' ' || cArray[i2] == '\n' || cArray[i2] == '\r' || cArray[i2] == '\t') continue;
            return false;
        }
        return true;
    }

    static boolean isFlag(int n2, int n3) {
        return (n2 & n3) >= n3;
    }

    static int getXTICSizePerPage(int n2) {
        int n3;
        switch (n2) {
            case 1: {
                n3 = 4091;
                break;
            }
            case 2: {
                n3 = 4091;
                break;
            }
            case 0: {
                n3 = 4089;
                break;
            }
            default: {
                n3 = 4091;
            }
        }
        return n3;
    }

    static void printBytesArrayinChars(byte[] byArray, int n2, int n3) {
        System.out.println();
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            if (byArray[i2] >= 32) {
                System.out.print((char)byArray[i2] + " ");
            } else {
                System.out.print(byArray[i2] + " ");
            }
            if (++n4 != 50) continue;
            System.out.println();
            n4 = 0;
        }
        System.out.println();
    }

    static String getStringFromArray(byte[] byArray, int n2) throws XTIException {
        try {
            int n3 = 0;
            int n4 = n2;
            if (n4 < 5) {
                n4 = 5;
            }
            while (byArray[n4] != 0) {
                ++n3;
                ++n4;
            }
            String string = XTIUtil.getXTICString(byArray, n2, n3);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XTIException(unsupportedEncodingException);
        }
    }

    static String getQNameFromArray(byte[] byArray, int n2) throws XTIException {
        try {
            int n3 = 0;
            int n4 = n2;
            if (n4 < 5) {
                n4 = 5;
            }
            while (byArray[n4] != 0) {
                ++n3;
                ++n4;
            }
            String string = XTIUtil.getXTICString4QName(byArray, n2, n3);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XTIException(unsupportedEncodingException);
        }
    }

    static String getXTICString(byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        return new String(byArray, n2, n3, "UTF-8");
    }

    static String getXTICString4QName(byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        if (byArray[n2] == 1 && byArray[n2 + 1] == 58) {
            return new String(byArray, n2 + 2, n3 - 2, "UTF-8");
        }
        byte by = byArray[n2];
        if (by < n3 && by > 1 && byArray[n2 + by] == 58) {
            return new String(byArray, n2 + 1, n3 - 1, "UTF-8");
        }
        return new String(byArray, n2, n3, "UTF-8");
    }

    public static void printVector(Vector vector) {
        System.out.println();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string = vector.get(i2).toString();
            System.out.print(string + "->");
        }
        System.out.println();
    }
}

