/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class SubstitutionGroupHandler {
    private static final XSElementDecl[] EMPTY_GROUP = new XSElementDecl[0];
    private final XSElementDeclHelper fXSElementDeclHelper;
    Hashtable fSubGroupsB = new Hashtable();
    private static final OneSubGroup[] EMPTY_VECTOR = new OneSubGroup[0];
    Hashtable fSubGroups = new Hashtable();

    public SubstitutionGroupHandler(XSElementDeclHelper xSElementDeclHelper) {
        this.fXSElementDeclHelper = xSElementDeclHelper;
    }

    public XSElementDecl getMatchingElemDecl(QName qName, XSElementDecl xSElementDecl) {
        if (qName.localpart == xSElementDecl.fName && qName.uri == xSElementDecl.fTargetNamespace) {
            return xSElementDecl;
        }
        if (xSElementDecl.fScope != 1) {
            return null;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            return null;
        }
        XSElementDecl xSElementDecl2 = this.fXSElementDeclHelper.getGlobalElementDecl(qName);
        if (xSElementDecl2 == null) {
            return null;
        }
        if (this.substitutionGroupOK(xSElementDecl2, xSElementDecl, xSElementDecl.fBlock)) {
            return xSElementDecl2;
        }
        return null;
    }

    protected boolean substitutionGroupOK(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2, short s2) {
        if (xSElementDecl == xSElementDecl2) {
            return true;
        }
        if ((s2 & 4) != 0) {
            return false;
        }
        XSElementDecl xSElementDecl3 = xSElementDecl.fSubGroup;
        while (xSElementDecl3 != null && xSElementDecl3 != xSElementDecl2) {
            xSElementDecl3 = xSElementDecl3.fSubGroup;
        }
        if (xSElementDecl3 == null) {
            return false;
        }
        return this.typeDerivationOK(xSElementDecl.fType, xSElementDecl2.fType, s2);
    }

    private boolean typeDerivationOK(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, short s2) {
        short s3 = 0;
        short s4 = s2;
        XSTypeDefinition xSTypeDefinition3 = xSTypeDefinition;
        while (xSTypeDefinition3 != xSTypeDefinition2 && xSTypeDefinition3 != SchemaGrammar.fAnyType) {
            s3 = xSTypeDefinition3.getTypeCategory() == 15 ? (short)(s3 | ((XSComplexTypeDecl)xSTypeDefinition3).fDerivedBy) : (short)(s3 | 2);
            if ((xSTypeDefinition3 = xSTypeDefinition3.getBaseType()) == null) {
                xSTypeDefinition3 = SchemaGrammar.fAnyType;
            }
            if (xSTypeDefinition3.getTypeCategory() != 15) continue;
            s4 = (short)(s4 | ((XSComplexTypeDecl)xSTypeDefinition3).fBlock);
        }
        if (xSTypeDefinition3 != xSTypeDefinition2) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition;
            if (xSTypeDefinition2.getTypeCategory() == 16 && (xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition2).getVariety() == 3) {
                XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
                int n2 = xSObjectList.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!this.typeDerivationOK(xSTypeDefinition, (XSTypeDefinition)xSObjectList.item(i2), s2)) continue;
                    return true;
                }
            }
            return false;
        }
        return (s3 & s4) == 0;
    }

    public boolean inSubstitutionGroup(XSElementDecl xSElementDecl, XSElementDecl xSElementDecl2) {
        return this.substitutionGroupOK(xSElementDecl, xSElementDecl2, xSElementDecl2.fBlock);
    }

    public void reset() {
        this.fSubGroupsB.clear();
        this.fSubGroups.clear();
    }

    public void addSubstitutionGroup(XSElementDecl[] xSElementDeclArray) {
        for (int i2 = xSElementDeclArray.length - 1; i2 >= 0; --i2) {
            XSElementDecl xSElementDecl = xSElementDeclArray[i2];
            XSElementDecl xSElementDecl2 = xSElementDecl.fSubGroup;
            Vector<XSElementDecl> vector = (Vector<XSElementDecl>)this.fSubGroupsB.get(xSElementDecl2);
            if (vector == null) {
                vector = new Vector<XSElementDecl>();
                this.fSubGroupsB.put(xSElementDecl2, vector);
            }
            vector.addElement(xSElementDecl);
        }
    }

    public XSElementDecl[] getSubstitutionGroup(XSElementDecl xSElementDecl) {
        Object v2 = this.fSubGroups.get(xSElementDecl);
        if (v2 != null) {
            return (XSElementDecl[])v2;
        }
        if ((xSElementDecl.fBlock & 4) != 0) {
            this.fSubGroups.put(xSElementDecl, EMPTY_GROUP);
            return EMPTY_GROUP;
        }
        OneSubGroup[] oneSubGroupArray = this.getSubGroupB(xSElementDecl, new OneSubGroup());
        int n2 = oneSubGroupArray.length;
        int n3 = 0;
        XSElementDecl[] xSElementDeclArray = new XSElementDecl[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((xSElementDecl.fBlock & oneSubGroupArray[i2].dMethod) != 0) continue;
            xSElementDeclArray[n3++] = oneSubGroupArray[i2].sub;
        }
        if (n3 < n2) {
            XSElementDecl[] xSElementDeclArray2 = new XSElementDecl[n3];
            System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, n3);
            xSElementDeclArray = xSElementDeclArray2;
        }
        this.fSubGroups.put(xSElementDecl, xSElementDeclArray);
        return xSElementDeclArray;
    }

    private OneSubGroup[] getSubGroupB(XSElementDecl xSElementDecl, OneSubGroup oneSubGroup) {
        int n2;
        Object v2 = this.fSubGroupsB.get(xSElementDecl);
        if (v2 == null) {
            this.fSubGroupsB.put(xSElementDecl, EMPTY_VECTOR);
            return EMPTY_VECTOR;
        }
        if (v2 instanceof OneSubGroup[]) {
            return (OneSubGroup[])v2;
        }
        Vector vector = (Vector)v2;
        Vector<OneSubGroup> vector2 = new Vector<OneSubGroup>();
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            XSElementDecl xSElementDecl2 = (XSElementDecl)vector.elementAt(i2);
            if (!this.getDBMethods(xSElementDecl2.fType, xSElementDecl.fType, oneSubGroup)) continue;
            short s2 = oneSubGroup.dMethod;
            short s3 = oneSubGroup.bMethod;
            vector2.addElement(new OneSubGroup(xSElementDecl2, oneSubGroup.dMethod, oneSubGroup.bMethod));
            OneSubGroup[] oneSubGroupArray = this.getSubGroupB(xSElementDecl2, oneSubGroup);
            for (n2 = oneSubGroupArray.length - 1; n2 >= 0; --n2) {
                short s4 = (short)(s2 | oneSubGroupArray[n2].dMethod);
                short s5 = (short)(s3 | oneSubGroupArray[n2].bMethod);
                if ((s4 & s5) != 0) continue;
                vector2.addElement(new OneSubGroup(oneSubGroupArray[n2].sub, s4, s5));
            }
        }
        OneSubGroup[] oneSubGroupArray = new OneSubGroup[vector2.size()];
        for (n2 = vector2.size() - 1; n2 >= 0; --n2) {
            oneSubGroupArray[n2] = (OneSubGroup)vector2.elementAt(n2);
        }
        this.fSubGroupsB.put(xSElementDecl, oneSubGroupArray);
        return oneSubGroupArray;
    }

    private boolean getDBMethods(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2, OneSubGroup oneSubGroup) {
        int n2 = 0;
        short s2 = 0;
        while (xSTypeDefinition != xSTypeDefinition2 && xSTypeDefinition != SchemaGrammar.fAnyType) {
            n2 = xSTypeDefinition.getTypeCategory() == 15 ? (int)((short)(n2 | ((XSComplexTypeDecl)xSTypeDefinition).fDerivedBy)) : (int)((short)(n2 | 2));
            if ((xSTypeDefinition = xSTypeDefinition.getBaseType()) == null) {
                xSTypeDefinition = SchemaGrammar.fAnyType;
            }
            if (xSTypeDefinition.getTypeCategory() != 15) continue;
            s2 = (short)(s2 | ((XSComplexTypeDecl)xSTypeDefinition).fBlock);
        }
        if (xSTypeDefinition != xSTypeDefinition2 || n2 & s2) {
            return false;
        }
        oneSubGroup.dMethod = (short)n2;
        oneSubGroup.bMethod = s2;
        return true;
    }

    private static final class OneSubGroup {
        XSElementDecl sub;
        short dMethod;
        short bMethod;

        OneSubGroup() {
        }

        OneSubGroup(XSElementDecl xSElementDecl, short s2, short s3) {
            this.sub = xSElementDecl;
            this.dMethod = s2;
            this.bMethod = s3;
        }
    }
}

