/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Vector;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private static final short STATE_CHILD = 1;
    private final XSElementDecl[] fAllElements;
    private final boolean[] fIsOptionalElement;
    private final boolean fHasOptionalContent;
    private int fNumElements = 0;

    public XSAllCM(boolean bl, int n2) {
        this.fHasOptionalContent = bl;
        this.fAllElements = new XSElementDecl[n2];
        this.fIsOptionalElement = new boolean[n2];
    }

    public void addElement(XSElementDecl xSElementDecl, boolean bl) {
        this.fAllElements[this.fNumElements] = xSElementDecl;
        this.fIsOptionalElement[this.fNumElements] = bl;
        ++this.fNumElements;
    }

    @Override
    public int[] startContentModel() {
        int[] nArray = new int[this.fNumElements + 1];
        for (int i2 = 0; i2 <= this.fNumElements; ++i2) {
            nArray[i2] = 0;
        }
        return nArray;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fNumElements && (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[i2])) == null; ++i2) {
        }
        return xSElementDecl;
    }

    @Override
    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        if (nArray[0] < 0) {
            nArray[0] = -2;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = 1;
        XSElementDecl xSElementDecl = null;
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (nArray[i2 + 1] != 0 || (xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[i2])) == null) continue;
            nArray[i2 + 1] = 1;
            return xSElementDecl;
        }
        nArray[0] = -1;
        return this.findMatchingDecl(qName, substitutionGroupHandler);
    }

    @Override
    public boolean endContentModel(int[] nArray) {
        int n2 = nArray[0];
        if (n2 == -1 || n2 == -2) {
            return false;
        }
        if (this.fHasOptionalContent && n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (this.fIsOptionalElement[i2] || nArray[i2 + 1] != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            for (int i3 = i2 + 1; i3 < this.fNumElements; ++i3) {
                if (!XSConstraints.overlapUPA(this.fAllElements[i2], this.fAllElements[i3], substitutionGroupHandler)) continue;
                throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[i2].toString(), this.fAllElements[i3].toString()});
            }
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] nArray) {
        Vector<XSElementDecl> vector = new Vector<XSElementDecl>();
        for (int i2 = 0; i2 < this.fNumElements; ++i2) {
            if (nArray[i2 + 1] != 0) continue;
            vector.addElement(this.fAllElements[i2]);
        }
        return vector;
    }

    @Override
    public int[] occurenceInfo(int[] nArray) {
        return null;
    }

    @Override
    public String getTermName(int n2) {
        return null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return false;
    }
}

