/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.SAXException;

public class XML11Serializer
extends XMLSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;

    public XML11Serializer() {
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputFormat outputFormat) {
        super(outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(Writer writer, OutputFormat outputFormat) {
        super(writer, outputFormat);
        this._format.setVersion("1.1");
    }

    public XML11Serializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputStream, outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setVersion("1.1");
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            ElementState elementState = this.content();
            if (elementState.inCData || elementState.doCData) {
                if (!elementState.inCData) {
                    this._printer.printText("<![CDATA[");
                    elementState.inCData = true;
                }
                int n4 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                int n5 = n2 + n3;
                for (int i2 = n2; i2 < n5; ++i2) {
                    char c2 = cArray[i2];
                    if (c2 == ']' && i2 + 2 < n5 && cArray[i2 + 1] == ']' && cArray[i2 + 2] == '>') {
                        this._printer.printText("]]]]><![CDATA[>");
                        i2 += 2;
                        continue;
                    }
                    if (!XML11Char.isXML11Valid(c2)) {
                        if (++i2 < n5) {
                            this.surrogates(c2, cArray[i2], true);
                            continue;
                        }
                        this.fatalError("The character '" + c2 + "' is an invalid XML character");
                        continue;
                    }
                    if (this._encodingInfo.isPrintable(c2) && XML11Char.isXML11ValidLiteral(c2)) {
                        this._printer.printText(c2);
                        continue;
                    }
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(c2));
                    this._printer.printText(";<![CDATA[");
                }
                this._printer.setNextIndent(n4);
            } else if (elementState.preserveSpace) {
                int n6 = this._printer.getNextIndent();
                this._printer.setNextIndent(0);
                this.printText(cArray, n2, n3, true, elementState.unescaped);
                this._printer.setNextIndent(n6);
            } else {
                this.printText(cArray, n2, n3, false, elementState.unescaped);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    @Override
    protected void printEscaped(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (!XML11Char.isXML11Valid(c2)) {
                if (++i2 < n2) {
                    this.surrogates(c2, string.charAt(i2), false);
                    continue;
                }
                this.fatalError("The character '" + (char)c2 + "' is an invalid XML character");
                continue;
            }
            if (c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\u0085' || c2 == '\u2028') {
                this.printHex(c2);
                continue;
            }
            if (c2 == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (c2 == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (c2 == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (c2 >= ' ' && this._encodingInfo.isPrintable(c2)) {
                this._printer.printText(c2);
                continue;
            }
            this.printHex(c2);
        }
    }

    @Override
    protected final void printCDATAText(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ']' && i2 + 2 < n2 && string.charAt(i2 + 1) == ']' && string.charAt(i2 + 2) == '>') {
                if (this.fDOMErrorHandler != null) {
                    String string2;
                    if ((this.features & 0x10) == 0 && (this.features & 2) == 0) {
                        string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "EndingCDATA", null);
                        this.modifyDOMError(string2, (short)3, null, this.fCurrentNode);
                        boolean bl = this.fDOMErrorHandler.handleError(this.fDOMError);
                        if (!bl) {
                            throw new IOException();
                        }
                    } else {
                        string2 = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "SplittingCDATA", null);
                        this.modifyDOMError(string2, (short)1, null, this.fCurrentNode);
                        this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                }
                this._printer.printText("]]]]><![CDATA[>");
                i2 += 2;
                continue;
            }
            if (!XML11Char.isXML11Valid(c2)) {
                if (++i2 < n2) {
                    this.surrogates(c2, string.charAt(i2), true);
                    continue;
                }
                this.fatalError("The character '" + c2 + "' is an invalid XML character");
                continue;
            }
            if (this._encodingInfo.isPrintable(c2) && XML11Char.isXML11ValidLiteral(c2)) {
                this._printer.printText(c2);
                continue;
            }
            this._printer.printText("]]>&#x");
            this._printer.printText(Integer.toHexString(c2));
            this._printer.printText(";<![CDATA[");
        }
    }

    @Override
    protected final void printXMLChar(int n2) throws IOException {
        if (n2 == 13 || n2 == 133 || n2 == 8232) {
            this.printHex(n2);
        } else if (n2 == 60) {
            this._printer.printText("&lt;");
        } else if (n2 == 38) {
            this._printer.printText("&amp;");
        } else if (n2 == 62) {
            this._printer.printText("&gt;");
        } else if (this._encodingInfo.isPrintable((char)n2) && XML11Char.isXML11ValidLiteral(n2)) {
            this._printer.printText((char)n2);
        } else {
            this.printHex(n2);
        }
    }

    @Override
    protected final void surrogates(int n2, int n3, boolean bl) throws IOException {
        if (XMLChar.isHighSurrogate(n2)) {
            if (!XMLChar.isLowSurrogate(n3)) {
                this.fatalError("The character '" + (char)n3 + "' is an invalid XML character");
            } else {
                int n4 = XMLChar.supplemental((char)n2, (char)n3);
                if (!XML11Char.isXML11Valid(n4)) {
                    this.fatalError("The character '" + (char)n4 + "' is an invalid XML character");
                } else if (bl && this.content().inCData) {
                    this._printer.printText("]]>&#x");
                    this._printer.printText(Integer.toHexString(n4));
                    this._printer.printText(";<![CDATA[");
                } else {
                    this.printHex(n4);
                }
            }
        } else {
            this.fatalError("The character '" + (char)n2 + "' is an invalid XML character");
        }
    }

    @Override
    protected void printText(String string, boolean bl, boolean bl2) throws IOException {
        int n2 = string.length();
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (!XML11Char.isXML11Valid(c2)) {
                    if (++i2 < n2) {
                        this.surrogates(c2, string.charAt(i2), true);
                        continue;
                    }
                    this.fatalError("The character '" + c2 + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c2)) {
                    this._printer.printText(c2);
                    continue;
                }
                this.printXMLChar(c2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                char c3 = string.charAt(i3);
                if (!XML11Char.isXML11Valid(c3)) {
                    if (++i3 < n2) {
                        this.surrogates(c3, string.charAt(i3), true);
                        continue;
                    }
                    this.fatalError("The character '" + c3 + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c3)) {
                    this._printer.printText(c3);
                    continue;
                }
                this.printXMLChar(c3);
            }
        }
    }

    @Override
    protected void printText(char[] cArray, int n2, int n3, boolean bl, boolean bl2) throws IOException {
        if (bl) {
            while (n3-- > 0) {
                char c2;
                if (!XML11Char.isXML11Valid(c2 = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c2, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c2 + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c2)) {
                    this._printer.printText(c2);
                    continue;
                }
                this.printXMLChar(c2);
            }
        } else {
            while (n3-- > 0) {
                char c3;
                if (!XML11Char.isXML11Valid(c3 = cArray[n2++])) {
                    if (n3-- > 0) {
                        this.surrogates(c3, cArray[n2++], true);
                        continue;
                    }
                    this.fatalError("The character '" + c3 + "' is an invalid XML character");
                    continue;
                }
                if (bl2 && XML11Char.isXML11ValidLiteral(c3)) {
                    this._printer.printText(c3);
                    continue;
                }
                this.printXMLChar(c3);
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        return true;
    }
}

