/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.quarkus.extensions.ollama;

import com.redhat.quarkus.extensions.ollama.OllamaConstants;
import com.redhat.quarkus.extensions.ollama.client.OllamaClient;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.commons.metadata.ValueHint;
import org.eclipse.lsp4mp.commons.utils.StringUtils;
import org.eclipse.lsp4mp.extensions.ExtendedMicroProfileProjectInfo;
import org.eclipse.lsp4mp.extensions.ItemMetadataProvider;
import org.eclipse.lsp4mp.model.Node;
import org.eclipse.lsp4mp.model.PropertiesModel;
import org.eclipse.lsp4mp.model.Property;

public class OllamaItemMetadataProvider
implements ItemMetadataProvider {
    private ExtendedMicroProfileProjectInfo projectInfo;
    private OllamaClient ollamaClient;

    public OllamaItemMetadataProvider(ExtendedMicroProfileProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        boolean available = this.projectInfo.getProperties().stream().anyMatch(p -> OllamaConstants.OLLAMA_MODEL_ID_KEYS.contains(p.getName()));
        if (available) {
            OllamaConstants.OLLAMA_MODEL_ID_KEYS.forEach(modelIdKey -> {
                ItemHint hint = new ItemHint();
                hint.setName(modelIdKey);
                hint.setValues(Collections.emptyList());
                projectInfo.getHints().add(hint);
            });
            this.ollamaClient = new OllamaClient();
        }
    }

    public boolean isAvailable() {
        return this.ollamaClient != null;
    }

    public void update(PropertiesModel document) {
        String baseUrl;
        if (document == null) {
            return;
        }
        if (this.ollamaClient != null && this.hasModelProperty(document) && (this.ollamaClient.update(baseUrl = OllamaItemMetadataProvider.getSearchBaseUrl(document)) || this.ollamaClient.needToRefreshModels())) {
            List models = this.ollamaClient.getModels().stream().map(m -> {
                ValueHint model = new ValueHint();
                String modelId = m.getName();
                if (modelId.endsWith(":latest")) {
                    modelId = modelId.substring(0, modelId.length() - 7);
                }
                model.setValue(modelId);
                return model;
            }).collect(Collectors.toList());
            OllamaConstants.OLLAMA_MODEL_ID_KEYS.forEach(modelIdKey -> {
                ItemHint hint = this.projectInfo.getHint(new String[]{modelIdKey});
                hint.setValues(models);
            });
        }
    }

    private boolean hasModelProperty(PropertiesModel document) {
        for (String modelIdKey : OllamaConstants.OLLAMA_MODEL_ID_KEYS) {
            if (OllamaItemMetadataProvider.getProperty(document, modelIdKey) == null) continue;
            return true;
        }
        return false;
    }

    public List<ItemMetadata> getProperties() {
        return null;
    }

    private static Property getProperty(PropertiesModel document, String propertyName) {
        for (Node node : document.getChildren()) {
            Property property;
            if (node.getNodeType() != Node.NodeType.PROPERTY || !propertyName.equals((property = (Property)node).getPropertyName())) continue;
            return property;
        }
        return null;
    }

    private static String getSearchBaseUrl(PropertiesModel document) {
        String propertyValue;
        Property baseUrlProperty = OllamaItemMetadataProvider.getProperty(document, "quarkus.langchain4j.ollama.base-url");
        if (baseUrlProperty != null && StringUtils.hasText((String)(propertyValue = baseUrlProperty.getPropertyValue()))) {
            return propertyValue;
        }
        return "http://localhost:11434";
    }
}

