/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.rsp.api.dao;

public class Status {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int CANCEL = 8;
    private int severity = 0;
    private String plugin;
    private int code;
    private String message;
    private String trace = null;

    public Status() {
    }

    public Status(int severity, String plugin, int code, String message, String trace) {
        this.setSeverity(severity);
        this.setPlugin(plugin);
        this.setCode(code);
        this.setMessage(message);
        this.setTrace(trace);
    }

    public Status(int severity, String plugin, String message, String trace) {
        this.setSeverity(severity);
        this.setPlugin(plugin);
        this.setMessage(message);
        this.setTrace(trace);
        this.setCode(0);
    }

    public Status(int severity, String plugin, String message) {
        this.setSeverity(severity);
        this.setPlugin(plugin);
        this.setMessage(message);
        this.setCode(0);
        this.setTrace(null);
    }

    public int getCode() {
        return this.code;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getMessage() {
        return this.message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.plugin);
        buf.append(" code=");
        buf.append(this.code);
        buf.append(' ');
        buf.append(this.message);
        buf.append(' ');
        buf.append(this.trace);
        return buf.toString();
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }
}

