/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.validators;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class MultiASTVisitor
extends ASTVisitor {
    private static final Logger LOGGER = Logger.getLogger(MultiASTVisitor.class.getName());
    private final Collection<ASTVisitor> visitors;

    public MultiASTVisitor(Collection<ASTVisitor> visitors) {
        this.visitors = visitors;
    }

    public boolean visit(SingleMemberAnnotation node) {
        boolean result = false;
        for (ASTVisitor visitor : this.visitors) {
            try {
                result |= visitor.visit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while visiting node with " + visitor.getClass().getName(), e);
            }
        }
        return result;
    }

    public void endVisit(SingleMemberAnnotation node) {
        for (ASTVisitor visitor : this.visitors) {
            try {
                visitor.endVisit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while end visiting node with " + visitor.getClass().getName(), e);
            }
        }
    }

    public boolean visit(NormalAnnotation node) {
        boolean result = false;
        for (ASTVisitor visitor : this.visitors) {
            try {
                result |= visitor.visit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while visiting node with " + visitor.getClass().getName(), e);
            }
        }
        return result;
    }

    public void endVisit(NormalAnnotation node) {
        for (ASTVisitor visitor : this.visitors) {
            try {
                visitor.endVisit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while end visiting node with " + visitor.getClass().getName(), e);
            }
        }
    }

    public boolean visit(TypeDeclaration node) {
        boolean result = false;
        for (ASTVisitor visitor : this.visitors) {
            try {
                result |= visitor.visit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while visiting node with " + visitor.getClass().getName(), e);
            }
        }
        return result;
    }

    public void endVisit(TypeDeclaration node) {
        for (ASTVisitor visitor : this.visitors) {
            try {
                visitor.endVisit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while end visiting node with " + visitor.getClass().getName(), e);
            }
        }
    }

    public boolean visit(MethodDeclaration node) {
        boolean result = false;
        for (ASTVisitor visitor : this.visitors) {
            try {
                result |= visitor.visit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while visiting node with " + visitor.getClass().getName(), e);
            }
        }
        return result;
    }

    public void endVisit(MethodDeclaration node) {
        for (ASTVisitor visitor : this.visitors) {
            try {
                visitor.endVisit(node);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while end visiting node with " + visitor.getClass().getName(), e);
            }
        }
    }
}

