"""
This type stub file was generated by pyright.
"""

from IPython.core import magic_arguments
from IPython.core.magic import Magics, cell_magic, line_cell_magic, line_magic, magics_class
from IPython.testing.skipdoctest import skip_doctest

"""Implementation of magic functions for interaction with the OS.

Note: this module is named 'osm' instead of 'os' to avoid a collision with the
builtin.
"""
@magics_class
class OSMagics(Magics):
    """Magics to interact with the underlying OS (shell-type functionality).
    """
    cd_force_quiet = ...
    def __init__(self, shell=..., **kwargs) -> None:
        ...
    
    def isexec(self, file):
        """
        Test for executable file on non POSIX system
        """
        ...
    
    @skip_doctest
    @line_magic
    def alias(self, parameter_s=...): # -> None:
        """Define an alias for a system command.

        '%alias alias_name cmd' defines 'alias_name' as an alias for 'cmd'

        Then, typing 'alias_name params' will execute the system command 'cmd
        params' (from your underlying operating system).

        Aliases have lower precedence than magic functions and Python normal
        variables, so if 'foo' is both a Python variable and an alias, the
        alias can not be executed until 'del foo' removes the Python variable.

        You can use the %l specifier in an alias definition to represent the
        whole line when the alias is called.  For example::

          In [2]: alias bracket echo "Input in brackets: <%l>"
          In [3]: bracket hello world
          Input in brackets: <hello world>

        You can also define aliases with parameters using %s specifiers (one
        per parameter)::

          In [1]: alias parts echo first %s second %s
          In [2]: %parts A B
          first A second B
          In [3]: %parts A
          Incorrect number of arguments: 2 expected.
          parts is an alias to: 'echo first %s second %s'

        Note that %l and %s are mutually exclusive.  You can only use one or
        the other in your aliases.

        Aliases expand Python variables just like system calls using ! or !!
        do: all expressions prefixed with '$' get expanded.  For details of
        the semantic rules, see PEP-215:
        https://peps.python.org/pep-0215/.  This is the library used by
        IPython for variable expansion.  If you want to access a true shell
        variable, an extra $ is necessary to prevent its expansion by
        IPython::

          In [6]: alias show echo
          In [7]: PATH='A Python string'
          In [8]: show $PATH
          A Python string
          In [9]: show $$PATH
          /usr/local/lf9560/bin:/usr/local/intel/compiler70/ia32/bin:...

        You can use the alias facility to access all of $PATH.  See the %rehashx
        function, which automatically creates aliases for the contents of your
        $PATH.

        If called with no parameters, %alias prints the current alias table
        for your system.  For posix systems, the default aliases are 'cat',
        'cp', 'mv', 'rm', 'rmdir', and 'mkdir', and other platform-specific
        aliases are added.  For windows-based systems, the default aliases are
        'copy', 'ddir', 'echo', 'ls', 'ldir', 'mkdir', 'ren', and 'rmdir'.

        You can see the definition of alias by adding a question mark in the
        end::

          In [1]: cat?
          Repr: <alias cat for 'cat'>"""
        ...
    
    @line_magic
    def unalias(self, parameter_s=...): # -> None:
        """Remove an alias"""
        ...
    
    @line_magic
    def rehashx(self, parameter_s=...): # -> None:
        """Update the alias table with all executable files in $PATH.

        rehashx explicitly checks that every entry in $PATH is a file
        with execute access (os.X_OK).

        Under Windows, it checks executability as a match against a
        '|'-separated string of extensions, stored in the IPython config
        variable win_exec_ext.  This defaults to 'exe|com|bat'.

        This function also resets the root module cache of module completer,
        used on slow filesystems.
        """
        ...
    
    @skip_doctest
    @line_magic
    def pwd(self, parameter_s=...):
        """Return the current working directory path.

        Examples
        --------
        ::

          In [9]: pwd
          Out[9]: '/home/tsuser/sprint/ipython'
        """
        ...
    
    @skip_doctest
    @line_magic
    def cd(self, parameter_s=...):
        """Change the current working directory.

        This command automatically maintains an internal list of directories
        you visit during your IPython session, in the variable ``_dh``. The
        command :magic:`%dhist` shows this history nicely formatted. You can
        also do ``cd -<tab>`` to see directory history conveniently.
        Usage:

          - ``cd 'dir'``: changes to directory 'dir'.
          - ``cd -``: changes to the last visited directory.
          - ``cd -<n>``: changes to the n-th directory in the directory history.
          - ``cd --foo``: change to directory that matches 'foo' in history
          - ``cd -b <bookmark_name>``: jump to a bookmark set by %bookmark
          - Hitting a tab key after ``cd -b`` allows you to tab-complete
            bookmark names.

          .. note::
            ``cd <bookmark_name>`` is enough if there is no directory
            ``<bookmark_name>``, but a bookmark with the name exists.

        Options:

        -q               Be quiet. Do not print the working directory after the
                         cd command is executed. By default IPython's cd
                         command does print this directory, since the default
                         prompts do not display path information.

        .. note::
           Note that ``!cd`` doesn't work for this purpose because the shell
           where ``!command`` runs is immediately discarded after executing
           'command'.

        Examples
        --------
        ::

          In [10]: cd parent/child
          /home/tsuser/parent/child
        """
        ...
    
    @line_magic
    def env(self, parameter_s=...): # -> None:
        """Get, set, or list environment variables.

        Usage:\\

          :``%env``: lists all environment variables/values
          :``%env var``: get value for var
          :``%env var val``: set value for var
          :``%env var=val``: set value for var
          :``%env var=$val``: set value for var, using python expansion if possible
        """
        ...
    
    @line_magic
    def set_env(self, parameter_s): # -> None:
        """Set environment variables.  Assumptions are that either "val" is a
        name in the user namespace, or val is something that evaluates to a
        string.

        Usage:\\
          :``%set_env var val``: set value for var
          :``%set_env var=val``: set value for var
          :``%set_env var=$val``: set value for var, using python expansion if possible
        """
        ...
    
    @line_magic
    def pushd(self, parameter_s=...):
        """Place the current dir on stack and change directory.

        Usage:\\
          %pushd ['dirname']
        """
        ...
    
    @line_magic
    def popd(self, parameter_s=...): # -> None:
        """Change to directory popped off the top of the stack.
        """
        ...
    
    @line_magic
    def dirs(self, parameter_s=...):
        """Return the current directory stack."""
        ...
    
    @line_magic
    def dhist(self, parameter_s=...): # -> None:
        """Print your history of visited directories.

        %dhist       -> print full history\\
        %dhist n     -> print last n entries only\\
        %dhist n1 n2 -> print entries between n1 and n2 (n2 not included)\\

        This history is automatically maintained by the %cd command, and
        always available as the global list variable _dh. You can use %cd -<n>
        to go to directory number <n>.

        Note that most of time, you should view directory history by entering
        cd -<TAB>.

        """
        ...
    
    @skip_doctest
    @line_magic
    def sc(self, parameter_s=...): # -> None:
        """Shell capture - run shell command and capture output (DEPRECATED use !).

        DEPRECATED. Suboptimal, retained for backwards compatibility.

        You should use the form 'var = !command' instead. Example:

         "%sc -l myfiles = ls ~" should now be written as

         "myfiles = !ls ~"

        myfiles.s, myfiles.l and myfiles.n still apply as documented
        below.

        --
        %sc [options] varname=command

        IPython will run the given command using commands.getoutput(), and
        will then update the user's interactive namespace with a variable
        called varname, containing the value of the call.  Your command can
        contain shell wildcards, pipes, etc.

        The '=' sign in the syntax is mandatory, and the variable name you
        supply must follow Python's standard conventions for valid names.

        (A special format without variable name exists for internal use)

        Options:

          -l: list output.  Split the output on newlines into a list before
          assigning it to the given variable.  By default the output is stored
          as a single string.

          -v: verbose.  Print the contents of the variable.

        In most cases you should not need to split as a list, because the
        returned value is a special type of string which can automatically
        provide its contents either as a list (split on newlines) or as a
        space-separated string.  These are convenient, respectively, either
        for sequential processing or to be passed to a shell command.

        For example::

            # Capture into variable a
            In [1]: sc a=ls *py

            # a is a string with embedded newlines
            In [2]: a
            Out[2]: 'setup.py\\nwin32_manual_post_install.py'

            # which can be seen as a list:
            In [3]: a.l
            Out[3]: ['setup.py', 'win32_manual_post_install.py']

            # or as a whitespace-separated string:
            In [4]: a.s
            Out[4]: 'setup.py win32_manual_post_install.py'

            # a.s is useful to pass as a single command line:
            In [5]: !wc -l $a.s
              146 setup.py
              130 win32_manual_post_install.py
              276 total

            # while the list form is useful to loop over:
            In [6]: for f in a.l:
               ...:      !wc -l $f
               ...:
            146 setup.py
            130 win32_manual_post_install.py

        Similarly, the lists returned by the -l option are also special, in
        the sense that you can equally invoke the .s attribute on them to
        automatically get a whitespace-separated string from their contents::

            In [7]: sc -l b=ls *py

            In [8]: b
            Out[8]: ['setup.py', 'win32_manual_post_install.py']

            In [9]: b.s
            Out[9]: 'setup.py win32_manual_post_install.py'

        In summary, both the lists and strings used for output capture have
        the following special attributes::

            .l (or .list) : value as list.
            .n (or .nlstr): value as newline-separated string.
            .s (or .spstr): value as space-separated string.
        """
        ...
    
    @line_cell_magic
    def sx(self, line=..., cell=...): # -> None:
        """Shell execute - run shell command and capture output (!! is short-hand).

        %sx command

        IPython will run the given command using commands.getoutput(), and
        return the result formatted as a list (split on '\\n').  Since the
        output is _returned_, it will be stored in ipython's regular output
        cache Out[N] and in the '_N' automatic variables.

        Notes:

        1) If an input line begins with '!!', then %sx is automatically
        invoked.  That is, while::

          !ls

        causes ipython to simply issue system('ls'), typing::

          !!ls

        is a shorthand equivalent to::

          %sx ls

        2) %sx differs from %sc in that %sx automatically splits into a list,
        like '%sc -l'.  The reason for this is to make it as easy as possible
        to process line-oriented shell output via further python commands.
        %sc is meant to provide much finer control, but requires more
        typing.

        3) Just like %sc -l, this is a list with special attributes:
        ::

          .l (or .list) : value as list.
          .n (or .nlstr): value as newline-separated string.
          .s (or .spstr): value as whitespace-separated string.

        This is very useful when trying to use such lists as arguments to
        system commands."""
        ...
    
    system = ...
    bang = ...
    @line_magic
    def bookmark(self, parameter_s=...): # -> None:
        """Manage IPython's bookmark system.

        %bookmark <name>       - set bookmark to current dir
        %bookmark <name> <dir> - set bookmark to <dir>
        %bookmark -l           - list all bookmarks
        %bookmark -d <name>    - remove bookmark
        %bookmark -r           - remove all bookmarks

        You can later on access a bookmarked folder with::

          %cd -b <name>

        or simply '%cd <name>' if there is no directory called <name> AND
        there is such a bookmark defined.

        Your bookmarks persist through IPython sessions, but they are
        associated with each profile."""
        ...
    
    @line_magic
    def pycat(self, parameter_s=...): # -> None:
        """Show a syntax-highlighted file through a pager.

        This magic is similar to the cat utility, but it will assume the file
        to be Python source and will show it with syntax highlighting.

        This magic command can either take a local filename, an url,
        an history range (see %history) or a macro as argument.

        If no parameter is given, prints out history of current session up to
        this point. ::

        %pycat myscript.py
        %pycat 7-27
        %pycat myMacro
        %pycat http://www.example.com/myscript.py
        """
        ...
    
    @magic_arguments.magic_arguments()
    @magic_arguments.argument('-a', '--append', action='store_true', default=False, help='Append contents of the cell to an existing file. ' 'The file will be created if it does not exist.')
    @magic_arguments.argument('filename', type=str, help='file to write')
    @cell_magic
    def writefile(self, line, cell): # -> None:
        """Write the contents of the cell to a file.

        The file will be overwritten unless the -a (--append) flag is specified.
        """
        ...
    


