"""
This type stub file was generated by pyright.
"""

from IPython.core import magic_arguments
from IPython.core.magic import Magics, line_magic, magics_class
from IPython.terminal.interactiveshell import TerminalInteractiveShell
from typing import Set

"""
An embedded IPython shell.
"""
class KillEmbedded(Exception):
    ...


KillEmbeded = KillEmbedded
@magics_class
class EmbeddedMagics(Magics):
    @line_magic
    @magic_arguments.magic_arguments()
    @magic_arguments.argument('-i', '--instance', action='store_true', help='Kill instance instead of call location')
    @magic_arguments.argument('-x', '--exit', action='store_true', help='Also exit the current session')
    @magic_arguments.argument('-y', '--yes', action='store_true', help='Do not ask confirmation')
    def kill_embedded(self, parameter_s=...): # -> None:
        """%kill_embedded : deactivate for good the current embedded IPython

        This function (after asking for confirmation) sets an internal flag so
        that an embedded IPython will never activate again for the given call
        location. This is useful to permanently disable a shell that is being
        called inside a loop: once you've figured out what you needed from it,
        you may then kill it and the program will then continue to run without
        the interactive shell interfering again.

        Kill Instance Option:

            If for some reasons you need to kill the location where the instance
            is created and not called, for example if you create a single
            instance in one place and debug in many locations, you can use the
            ``--instance`` option to kill this specific instance. Like for the
            ``call location`` killing an "instance" should work even if it is
            recreated within a loop.

        .. note::

            This was the default behavior before IPython 5.2

        """
        ...
    
    @line_magic
    def exit_raise(self, parameter_s=...): # -> None:
        """%exit_raise Make the current embedded kernel exit and raise and exception.

        This function sets an internal flag so that an embedded IPython will
        raise a `IPython.terminal.embed.KillEmbedded` Exception on exit, and then exit the current I. This is
        useful to permanently exit a loop that create IPython embed instance.
        """
        ...
    


class _Sentinel:
    def __init__(self, repr) -> None:
        ...
    
    def __repr__(self):
        ...
    


class InteractiveShellEmbed(TerminalInteractiveShell):
    dummy_mode = ...
    exit_msg = ...
    embedded = ...
    should_raise = ...
    display_banner = ...
    exit_msg = ...
    term_title = ...
    _inactive_locations: Set[str] = ...
    @property
    def embedded_active(self):
        ...
    
    @embedded_active.setter
    def embedded_active(self, value): # -> None:
        ...
    
    def __init__(self, **kw) -> None:
        ...
    
    def init_sys_modules(self): # -> None:
        """
        Explicitly overwrite :mod:`IPython.core.interactiveshell` to do nothing.
        """
        ...
    
    def init_magics(self): # -> None:
        ...
    
    def __call__(self, header=..., local_ns=..., module=..., dummy=..., stack_depth=..., compile_flags=..., **kw): # -> None:
        """Activate the interactive interpreter.

        __call__(self,header='',local_ns=None,module=None,dummy=None) -> Start
        the interpreter shell with the given local and global namespaces, and
        optionally print a header string at startup.

        The shell can be globally activated/deactivated using the
        dummy_mode attribute. This allows you to turn off a shell used
        for debugging globally.

        However, *each* time you call the shell you can override the current
        state of dummy_mode with the optional keyword parameter 'dummy'. For
        example, if you set dummy mode on with IPShell.dummy_mode = True, you
        can still have a specific call work by making it as IPShell(dummy=False).
        """
        ...
    
    def mainloop(self, local_ns=..., module=..., stack_depth=..., compile_flags=...): # -> None:
        """Embeds IPython into a running python program.

        Parameters
        ----------
        local_ns, module
            Working local namespace (a dict) and module (a module or similar
            object). If given as None, they are automatically taken from the scope
            where the shell was called, so that program variables become visible.
        stack_depth : int
            How many levels in the stack to go to looking for namespaces (when
            local_ns or module is None). This allows an intermediate caller to
            make sure that this function gets the namespace from the intended
            level in the stack. By default (0) it will get its locals and globals
            from the immediate caller.
        compile_flags
            A bit field identifying the __future__ features
            that are enabled, as passed to the builtin :func:`compile` function.
            If given as None, they are automatically taken from the scope where
            the shell was called.

        """
        ...
    


def embed(*, header=..., compile_flags=..., **kwargs): # -> None:
    """Call this to embed IPython at the current point in your program.

    The first invocation of this will create a :class:`terminal.embed.InteractiveShellEmbed`
    instance and then call it.  Consecutive calls just call the already
    created instance.

    If you don't want the kernel to initialize the namespace
    from the scope of the surrounding function,
    and/or you want to load full IPython configuration,
    you probably want `IPython.start_ipython()` instead.

    Here is a simple example::

        from IPython import embed
        a = 10
        b = 20
        embed(header='First time')
        c = 30
        d = 40
        embed()

    Parameters
    ----------

    header : str
        Optional header string to print at startup.
    compile_flags
        Passed to the `compile_flags` parameter of :py:meth:`terminal.embed.InteractiveShellEmbed.mainloop()`,
        which is called when the :class:`terminal.embed.InteractiveShellEmbed` instance is called.
    **kwargs : various, optional
        Any other kwargs will be passed to the :class:`terminal.embed.InteractiveShellEmbed` constructor.
        Full customization can be done by passing a traitlets :class:`Config` in as the
        `config` argument (see :ref:`configure_start_ipython` and :ref:`terminal_options`).
    """
    ...

