from typing import Any, TypeAlias

from django.contrib.auth.base_user import AbstractBaseUser
from django.contrib.auth.models import AnonymousUser, Permission, User
from django.db.models.base import Model
from django.http.request import HttpRequest

_AnyUser: TypeAlias = Model | AnonymousUser

UserModel: Any

class BaseBackend:
    def authenticate(
        self,
        request: HttpRequest,
        username: str | None = ...,
        password: str | None = ...,
        **kwargs: Any
    ) -> AbstractBaseUser | None: ...
    async def aauthenticate(
        self,
        request: HttpRequest,
        username: str | None = ...,
        password: str | None = ...,
        **kwargs: Any
    ) -> AbstractBaseUser | None: ...
    def get_user(self, user_id: int) -> AbstractBaseUser | None: ...
    async def aget_user(self, user_id: int) -> AbstractBaseUser | None: ...
    def get_user_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    async def aget_user_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    def get_group_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    async def aget_group_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    def get_all_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    async def aget_all_permissions(
        self, user_obj: _AnyUser, obj: Model | None = ...
    ) -> set[str]: ...
    def has_perm(
        self, user_obj: _AnyUser, perm: str, obj: Model | None = ...
    ) -> bool: ...
    async def ahas_perm(
        self, user_obj: _AnyUser, perm: str, obj: Model | None = ...
    ) -> bool: ...

class ModelBackend(BaseBackend):
    def has_module_perms(self, user_obj: _AnyUser, app_label: str) -> bool: ...
    async def ahas_module_perms(self, user_obj: _AnyUser, app_label: str) -> bool: ...
    def user_can_authenticate(self, user: _AnyUser | None) -> bool: ...
    def with_perm(
        self,
        perm: str | Permission,
        is_active: bool = ...,
        include_superusers: bool = ...,
        obj: Model | None = ...,
    ) -> Any: ...

class AllowAllUsersModelBackend(ModelBackend): ...

class RemoteUserBackend(ModelBackend):
    create_unknown_user: bool = ...
    def clean_username(self, username: str) -> str: ...
    def configure_user(self, request: HttpRequest, user: User) -> User: ...
    async def aconfigure_user(self, request: HttpRequest, user: User) -> User: ...

class AllowAllUsersRemoteUserBackend(RemoteUserBackend): ...
