from collections.abc import Iterator, Mapping
from typing import Any, Protocol

from django.http.request import HttpRequest
from django.utils.safestring import SafeText

# Source: https://github.com/django/deps/blob/main/final/0182-multiple-template-engines.rst#backends-api
class _BaseTemplate(Protocol):
    def render(
        self,
        context: Mapping[str, Any] | None = ...,
        request: HttpRequest | None = ...,
    ) -> SafeText | str: ...

class BaseEngine:
    name: str = ...
    dirs: list[str] = ...
    app_dirs: bool = ...
    def __init__(self, params: Mapping[str, Any]) -> None: ...
    @property
    def app_dirname(self) -> str: ...
    def from_string(self, template_code: str) -> _BaseTemplate: ...
    def get_template(self, template_name: str) -> _BaseTemplate: ...
    @property
    def template_dirs(self) -> tuple[str]: ...
    def iter_template_filenames(self, template_name: str) -> Iterator[str]: ...
