from abc import abstractmethod
from collections.abc import Iterator
from typing import Any

from django.db.backends.base.base import BaseDatabaseWrapper
from django.utils.functional import cached_property

class ConnectionProxy:
    """Proxy for accessing a connection object's attributes."""

    def __init__(self, connections: BaseConnectionHandler, alias: str) -> None: ...
    def __getattr__(self, item: str) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __delattr__(self, name: str) -> None: ...
    def __contains__(self, key: str) -> bool: ...
    def __eq__(self, other: object) -> bool: ...

class ConnectionDoesNotExist(Exception): ...

class BaseConnectionHandler:
    settings_name: str | None
    exception_class: type[Exception]
    thread_critical: bool

    def __init__(self, settings: dict[str, dict[str, Any]] | None = None) -> None: ...
    @cached_property
    def settings(self) -> dict[str, dict[str, Any]]: ...
    def configure_settings(
        self, settings: dict[str, dict[str, Any]] | None
    ) -> dict[str, dict[str, Any]]: ...
    @abstractmethod
    def create_connection(self, alias: str) -> BaseDatabaseWrapper: ...
    def __getitem__(self, alias: str) -> BaseDatabaseWrapper: ...
    def __setitem__(self, key: str, value: BaseDatabaseWrapper) -> None: ...
    def __delitem__(self, key: str) -> None: ...
    def __iter__(self) -> Iterator[str]: ...
    def all(self, initialized_only: bool = False) -> list[BaseDatabaseWrapper]: ...
    def close_all(self) -> None: ...
