import datetime

import numpy as np
from dateutil import rrule
from dateutil.relativedelta import relativedelta

from .ticker import Formatter, Locator
from .units import ConversionInterface

UTC: datetime.timezone = ...
EPOCH_OFFSET: float = ...
JULIAN_OFFSET: float = ...
MICROSECONDLY: int = ...
HOURS_PER_DAY: int = ...
MIN_PER_HOUR: int = ...
SEC_PER_MIN: int = ...
MONTHS_PER_YEAR: int = ...
DAYS_PER_WEEK: int = ...
DAYS_PER_MONTH: int = ...
DAYS_PER_YEAR: int = ...
MINUTES_PER_DAY: int = ...
SEC_PER_HOUR: int = ...
SEC_PER_DAY: int = ...
SEC_PER_WEEK: int = ...
MUSECONDS_PER_DAY: int = ...
MO: rrule.weekday = ...
TU: rrule.weekday = ...
WE: rrule.weekday = ...
TH: rrule.weekday = ...
FR: rrule.weekday = ...
SA: rrule.weekday = ...
SU: rrule.weekday = ...
WEEKDAYS: tuple[rrule.weekday] = ...
YEARLY: int = ...
MONTHLY: int = ...
WEEKLY: int = ...
DAILY: int = ...
HOURLY: int = ...
MINUTELY: int = ...
SECONDLY: int = ...

def set_epoch(epoch: str): ...
def get_epoch() -> str: ...
def datestr2num(d: str, default: datetime.datetime = ...): ...
def date2num(d: datetime.datetime | np.datetime64) -> float: ...
def julian2num(j: float) -> float: ...
def num2julian(n: float) -> float: ...
def num2date(x: float, tz: str | datetime.tzinfo = ...) -> datetime.datetime: ...
def num2timedelta(x) -> tuple[datetime.timedelta, list[datetime.timedelta]]: ...
def drange(
    dstart: datetime.datetime | datetime.date,
    dend: datetime.datetime | datetime.date,
    delta: datetime.timedelta,
) -> np.ndarray: ...

class DateFormatter(Formatter):
    def __init__(self, fmt: str, tz: str | datetime.tzinfo = ..., *, usetex: bool = ...) -> None: ...
    def __call__(self, x, pos=...): ...
    def set_tzinfo(self, tz: str | datetime.tzinfo): ...

class ConciseDateFormatter(Formatter):
    formats: list[str] = ...
    offset_formats: list[str] = ...
    zero_formats: list[str] = ...

    def __init__(
        self,
        locator: Locator,
        tz: str | datetime.tzinfo = ...,
        formats: list[str] = ...,
        offset_formats: list[str] = ...,
        zero_formats: list[str] = ...,
        show_offset: bool = ...,
        *,
        usetex: bool = ...,
    ) -> None: ...
    def __call__(self, x, pos=...): ...
    def format_ticks(self, values) -> None: ...
    def get_offset(self): ...
    def format_data_short(self, value): ...

class AutoDateFormatter(Formatter):
    def __init__(
        self, locator: Locator, tz: str | datetime.tzinfo = ..., defaultfmt: str = ..., *, usetex: bool = ...
    ) -> None: ...
    def __call__(self, x, pos=...): ...

class rrulewrapper:
    def __init__(self, freq: int, tzinfo: datetime.tzinfo | None = ..., **kwargs) -> None: ...
    def set(self, **kwargs) -> None: ...
    def __getattr__(self, name): ...
    def __setstate__(self, state) -> None: ...

class DateLocator(Locator):
    hms0d = ...
    def __init__(self, tz: str | datetime.tzinfo = ...) -> None: ...
    def set_tzinfo(self, tz: str | datetime.tzinfo) -> None: ...
    def datalim_to_dt(self): ...
    def viewlim_to_dt(self): ...
    def nonsingular(self, vmin, vmax): ...

class RRuleLocator(DateLocator):
    def __init__(self, o, tz: str | datetime.tzinfo = ...) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    @staticmethod
    def get_unit_generic(freq): ...

class AutoDateLocator(DateLocator):
    def __init__(
        self,
        tz: str | datetime.tzinfo = ...,
        minticks: int = ...,
        maxticks: int = ...,
        interval_multiples: bool = True,
    ) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...
    def nonsingular(self, vmin, vmax): ...
    def get_locator(self, dmin, dmax): ...

class YearLocator(RRuleLocator):
    def __init__(self, base=..., month=..., day=..., tz: str | datetime.tzinfo = ...) -> None: ...

class MonthLocator(RRuleLocator):
    def __init__(self, bymonth=..., bymonthday=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class WeekdayLocator(RRuleLocator):
    def __init__(self, byweekday=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class DayLocator(RRuleLocator):
    def __init__(self, bymonthday=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class HourLocator(RRuleLocator):
    def __init__(self, byhour=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class MinuteLocator(RRuleLocator):
    def __init__(self, byminute=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class SecondLocator(RRuleLocator):
    def __init__(self, bysecond=..., interval=..., tz: str | datetime.tzinfo = ...) -> None: ...

class MicrosecondLocator(DateLocator):
    def __init__(self, interval=..., tz: str | datetime.tzinfo = ...) -> None: ...
    def set_axis(self, axis) -> None: ...
    def set_view_interval(self, vmin: float, vmax: float) -> None: ...
    def set_data_interval(self, vmin: float, vmax: float) -> None: ...
    def __call__(self): ...
    def tick_values(self, vmin, vmax): ...

def epoch2num(e: list[float]) -> np.ndarray: ...
def num2epoch(d: list[float]) -> np.ndarray: ...
def date_ticker_factory(span, tz: str | datetime.tzinfo = ..., numticks=...): ...

class DateConverter(ConversionInterface):
    def __init__(self, *, interval_multiples=...) -> None: ...
    def axisinfo(self, unit: None | datetime.tzinfo, axis): ...
    @staticmethod
    def convert(value, unit, axis): ...
    @staticmethod
    def default_units(x, axis): ...

class ConciseDateConverter(DateConverter):
    def __init__(self, formats=..., zero_formats=..., offset_formats=..., show_offset=..., *, interval_multiples=...) -> None: ...
    def axisinfo(self, unit, axis): ...

class _SwitchableDateConverter:
    def axisinfo(self, *args, **kwargs): ...
    def default_units(self, *args, **kwargs): ...
    def convert(self, *args, **kwargs): ...

__all__ = (
    "datestr2num",
    "date2num",
    "num2date",
    "num2timedelta",
    "drange",
    "set_epoch",
    "get_epoch",
    "DateFormatter",
    "ConciseDateFormatter",
    "AutoDateFormatter",
    "DateLocator",
    "RRuleLocator",
    "AutoDateLocator",
    "YearLocator",
    "MonthLocator",
    "WeekdayLocator",
    "DayLocator",
    "HourLocator",
    "MinuteLocator",
    "SecondLocator",
    "MicrosecondLocator",
    "rrule",
    "MO",
    "TU",
    "WE",
    "TH",
    "FR",
    "SA",
    "SU",
    "YEARLY",
    "MONTHLY",
    "WEEKLY",
    "DAILY",
    "HOURLY",
    "MINUTELY",
    "SECONDLY",
    "MICROSECONDLY",
    "relativedelta",
    "DateConverter",
    "ConciseDateConverter",
    "rrulewrapper",
)
