from enum import Enum
from typing import (
    Final,
    Literal,
    TypeAlias,
    TypeGuard,
)

import numpy as np

class _NoDefault(Enum):
    no_default = ...

no_default: Final = _NoDefault.no_default
_NoDefaultDoNotUse: TypeAlias = Literal[_NoDefault.no_default]  # noqa: PYI047

def infer_dtype(value: object, skipna: bool = True) -> str: ...
def is_iterator(obj: object) -> bool: ...
def is_scalar(val: object) -> bool: ...
def is_list_like(obj: object, allow_sets: bool = True) -> bool: ...
def is_complex(val: object) -> TypeGuard[complex]: ...
def is_bool(val: object) -> TypeGuard[bool | np.bool_]: ...
def is_integer(val: object) -> TypeGuard[int | np.integer]: ...
def is_float(val: object) -> TypeGuard[float | np.floating]: ...
