from typing import Literal

from numpy.typing import NDArray

from .._shared.utils import deprecate_kwarg

def skeletonize(image, *, method: Literal["zhang", "lee"] | None = None) -> NDArray: ...
def skeletonize_2d(image) -> NDArray: ...

# --------- Skeletonization and thinning based on Guo and Hall 1989 ---------

def _generate_thin_luts(): ...

G123_LUT = ...

G123P_LUT = ...

@deprecate_kwarg({"max_iter": "max_num_iter"}, removed_version="1.0", deprecated_version="0.19")
def thin(image, max_num_iter=None) -> NDArray: ...

# --------- Skeletonization by medial axis transform --------

_eight_connect = ...

def medial_axis(image, mask=None, return_distance: bool = False, *, random_state=None) -> tuple[NDArray, NDArray]: ...
def _pattern_of(index): ...
def _table_lookup(image, table): ...
def skeletonize_3d(image) -> NDArray: ...
