from typing import Any, Callable

from numpy import ndarray

from .._typing import ArrayLike, Float, MatrixLike
from ..base import BaseEstimator

class _MultimetricScorer:
    def __init__(self, *, scorers: dict, raise_exc: bool = True) -> None: ...
    def __call__(self, estimator, *args, **kwargs) -> dict[str, Float]: ...

class _BaseScorer:
    def __init__(self, score_func: Callable, sign: int, kwargs) -> None: ...
    def __call__(
        self,
        estimator: Any,
        X: MatrixLike | ArrayLike,
        y_true: ArrayLike,
        sample_weight: None | ArrayLike = None,
    ) -> Float: ...

class _PredictScorer(_BaseScorer): ...
class _ProbaScorer(_BaseScorer): ...
class _ThresholdScorer(_BaseScorer): ...

def get_scorer(scoring: _PredictScorer | None | str | Callable) -> Callable: ...
def check_scoring(
    estimator: BaseEstimator,
    scoring: _PredictScorer | None | str | Callable = None,
    *,
    allow_none: bool = False,
) -> Callable: ...
def make_scorer(
    score_func: Callable,
    *,
    greater_is_better: bool = True,
    needs_proba: bool = False,
    needs_threshold: bool = False,
    **kwargs,
) -> Callable: ...

# Standard regression scores
explained_variance_scorer = ...
r2_scorer = ...
max_error_scorer = ...
neg_mean_squared_error_scorer = ...
neg_mean_squared_log_error_scorer = ...
neg_mean_absolute_error_scorer = ...
neg_mean_absolute_percentage_error_scorer = ...
neg_median_absolute_error_scorer = ...
neg_root_mean_squared_error_scorer = ...
neg_root_mean_squared_log_error_scorer = ...
neg_mean_poisson_deviance_scorer = ...

neg_mean_gamma_deviance_scorer = ...

# Standard Classification Scores
accuracy_scorer = ...
balanced_accuracy_scorer = ...
matthews_corrcoef_scorer = ...

def positive_likelihood_ratio(y_true, y_pred): ...
def negative_likelihood_ratio(y_true, y_pred): ...

positive_likelihood_ratio_scorer = ...
neg_negative_likelihood_ratio_scorer = ...

# Score functions that need decision values
top_k_accuracy_scorer = ...
roc_auc_scorer = ...
average_precision_scorer = ...
roc_auc_ovo_scorer = ...
roc_auc_ovo_weighted_scorer = ...
roc_auc_ovr_scorer = ...
roc_auc_ovr_weighted_scorer = ...

# Score function for probabilistic classification
neg_log_loss_scorer = ...
neg_brier_score_scorer = ...
brier_score_loss_scorer = ...

# Clustering scores
adjusted_rand_scorer = ...
rand_scorer = ...
homogeneity_scorer = ...
completeness_scorer = ...
v_measure_scorer = ...
mutual_info_scorer = ...
adjusted_mutual_info_scorer = ...
normalized_mutual_info_scorer = ...
fowlkes_mallows_scorer = ...

_SCORERS = ...

def get_scorer_names() -> list[str] | ndarray: ...

SCORERS = ...
