from typing import Final, NamedTuple

SIMPLE_METHODS = ...
COMPOSITE_METHODS = ...
METHODS = ...

def _routing_enabled(): ...
def _raise_for_params(params, owner, method) -> None: ...
def _raise_for_unsupported_routing(obj, method, **kwargs) -> None: ...

class _RoutingNotSupportedMixin:
    def get_metadata_routing(self) -> None: ...

UNUSED: Final = "$UNUSED$"
WARN: Final = "$WARN$"
UNCHANGED: Final = "$UNCHANGED$"
VALID_REQUEST_VALUES = ...

def request_is_alias(item): ...
def request_is_valid(item): ...

class MethodMetadataRequest:
    owner = ...
    method = ...
    def __init__(self, owner, method, requests=None) -> None: ...
    @property
    def requests(self): ...
    def add_request(self, *, param, alias): ...

class MetadataRequest:
    owner = ...
    def __init__(self, owner) -> None: ...
    def consumes(self, method, params): ...
    def __getattr__(self, name): ...

class RouterMappingPair(NamedTuple):
    mapping = ...
    router = ...

class MethodPair(NamedTuple):
    caller = ...
    callee = ...

class MethodMapping:
    def __init__(self) -> None: ...
    def __iter__(self): ...
    def add(self, *, caller, callee): ...

class MetadataRouter:
    owner = ...
    def __init__(self, owner) -> None: ...
    def add_self_request(self, obj): ...
    def add(self, *, method_mapping, **objs): ...
    def consumes(self, method, params): ...
    def route_params(self, *, caller, params): ...
    def validate_metadata(self, *, method, params) -> None: ...
    def __iter__(self): ...

def get_routing_for_object(obj=None): ...

REQUESTER_DOC: Final[str]
REQUESTER_DOC_PARAM: Final[str]
REQUESTER_DOC_RETURN: Final[str]

class RequestMethod:
    name = ...
    keys = ...
    validate_keys = ...
    def __init__(self, name, keys, validate_keys: bool = True) -> None: ...
    def __get__(self, instance, owner): ...

class _MetadataRequester:
    def __init_subclass__(cls, **kwargs) -> None: ...
    def get_metadata_routing(self) -> MetadataRequest: ...
    # This code is never run in runtime, but it's here for type checking.
    # Type checkers fail to understand that the `set_{method}_request`
    # methods are dynamically generated, and they complain that they are
    # not defined. We define them here to make type checkers happy.
    # During type checking analyzers assume this to be True.
    # The following list of defined methods mirrors the list of methods
    # in SIMPLE_METHODS.
    def set_fit_request(self, **kwargs): ...
    def set_partial_fit_request(self, **kwargs): ...
    def set_predict_request(self, **kwargs): ...
    def set_predict_proba_request(self, **kwargs): ...
    def set_predict_log_proba_request(self, **kwargs): ...
    def set_decision_function_request(self, **kwargs): ...
    def set_score_request(self, **kwargs): ...
    def set_split_request(self, **kwargs): ...
    def set_transform_request(self, **kwargs): ...
    def set_inverse_transform_request(self, **kwargs): ...

def process_routing(_obj, _method, /, **kwargs): ...
