import sys
from functools import lru_cache
from typing import Any, Literal
from typing_extensions import Self, TypeAlias

from sympy.core.basic import Basic
from sympy.core.cache import cacheit
from sympy.core.decorators import _sympifyit as _sympifyit
from sympy.core.expr import AtomicExpr, Expr
from sympy.core.mul import Mul
from sympy.core.singleton import Singleton
from sympy.series.order import Order

if sys.version_info >= (3, 10):
    from types import NotImplementedType
else:
    NotImplementedType: TypeAlias = Any

_LOG2 = ...

def comp(z1, z2, tol=...) -> bool: ...
def mpf_norm(
    mpf, prec
) -> tuple[Literal[0], int | Any, Literal[0], Literal[0]] | tuple[Any, Any | Literal[1], Any, Any | Literal[1]]: ...

_errdict = ...

def seterr(divide=...) -> None: ...

_floatpat = ...

@lru_cache(1024)
def igcd(*args) -> int: ...

igcd2 = ...

def igcd_lehmer(a, b) -> int: ...
def ilcm(*args) -> Literal[0]: ...
def igcdex(
    a, b
) -> (
    tuple[Literal[0], Literal[1], Literal[0]]
    | tuple[Literal[0], Any, Any]
    | tuple[Any, Literal[0], Any]
    | tuple[Literal[-1, 1, 0], Literal[0, -1, 1], Any]
): ...
def mod_inverse(a, m) -> int: ...

class Number(AtomicExpr):
    is_commutative = ...
    is_number = ...
    is_Number = ...
    __slots__ = ...
    _prec = ...
    kind = ...
    def __new__(cls, *obj) -> Number | Integer | Rational | Float: ...
    def could_extract_minus_sign(self) -> bool: ...
    def invert(self, other, *gens, **args) -> int | Any: ...
    def __divmod__(self, other) -> tuple[Any, Any] | NotImplementedType | tuple: ...
    def __rdivmod__(self, other) -> NotImplementedType | tuple[Any, Any] | tuple: ...
    def __float__(self) -> float: ...
    def floor(self): ...
    def ceiling(self): ...
    def __floor__(self): ...
    def __ceil__(self): ...
    @classmethod
    def class_key(cls) -> tuple[Literal[1], Literal[0], Literal["Number"]]: ...
    @cacheit
    def sort_key(
        self, order=...
    ) -> tuple[tuple[Literal[1], Literal[0], Literal["Number"]], tuple[Literal[0], tuple[()]], tuple[()], Self]: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other): ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other): ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> NotImplementedType: ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other): ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def is_constant(self, *wrt, **flags) -> Literal[True]: ...
    def as_coeff_mul(
        self, *deps, rational=..., **kwargs
    ) -> tuple[Self, tuple[()]] | tuple[Any, tuple[Any | Mul]] | tuple[Any, tuple[Self]]: ...
    def as_coeff_add(self, *deps) -> tuple[Self, tuple[()]] | tuple[Any, tuple[Self]]: ...
    def as_coeff_Mul(self, rational=...) -> tuple[Any, Self] | tuple[Self, Any] | tuple[Any, Any]: ...
    def as_coeff_Add(self, rational=...) -> tuple[Self, Any] | tuple[Any, Self]: ...
    def gcd(self, other) -> Any: ...
    def lcm(self, other) -> Any: ...
    def cofactors(self, other) -> Any: ...

class Float(Number):
    __slots__ = ...
    _mpf_: tuple[int, int, int, int]
    is_rational = ...
    is_irrational = ...
    is_number = ...
    is_real = ...
    is_extended_real = ...
    is_Float = ...
    def __new__(cls, num, dps=..., precision=...): ...
    def __getnewargs_ex__(self) -> tuple[tuple[tuple[int, str, int, int]], dict[str, Any]]: ...
    def floor(self) -> Integer: ...
    def ceiling(self) -> Integer: ...
    def __floor__(self) -> Integer: ...
    def __ceil__(self) -> Integer: ...
    @property
    def num(self): ...
    def __bool__(self) -> bool: ...
    def __neg__(self) -> Self | Float: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> Float | NotImplementedType: ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __mod__(self, other) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __rmod__(self, other) -> Float: ...
    def __abs__(self) -> Float: ...
    def __int__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def epsilon_eq(self, other, epsilon=...): ...
    def __format__(self, format_spec) -> str: ...

RealNumber = Float

class Rational(Number):
    is_real = ...
    is_integer = ...
    is_rational = ...
    is_number = ...
    __slots__ = ...
    p: int
    q: int
    is_Rational = ...
    @cacheit
    def __new__(cls, p, q=..., gcd=...) -> Rational | Integer | Self: ...
    def limit_denominator(self, max_denominator=...) -> Rational: ...
    def __getnewargs__(self) -> tuple[int, int]: ...
    def __neg__(self) -> Rational | Integer: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other) -> Rational | Integer | Float: ...

    __radd__ = ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other) -> Rational | Integer | Float: ...
    @_sympifyit("other", NotImplemented)
    def __rsub__(self, other) -> Rational | Integer | Float | Order: ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> Rational | Integer | Float | NotImplementedType: ...

    __rmul__ = ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other) -> Rational | Integer: ...
    @_sympifyit("other", NotImplemented)
    def __rtruediv__(self, other) -> Rational | Integer: ...
    @_sympifyit("other", NotImplemented)
    def __mod__(self, other) -> Rational | Integer | Float: ...
    @_sympifyit("other", NotImplemented)
    def __rmod__(self, other) -> Rational | Integer | Float: ...
    def __abs__(self) -> Rational | Integer: ...
    def __int__(self) -> int: ...
    def floor(self) -> Integer: ...
    def ceiling(self) -> Integer: ...
    def __floor__(self) -> Integer: ...
    def __ceil__(self) -> Integer: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def factors(
        self, limit=..., use_trial=..., use_rho=..., use_pm1=..., verbose=..., visual=...
    ) -> Order | dict[Any, int] | list[Any]: ...
    @property
    def numerator(self) -> int: ...
    @property
    def denominator(self) -> int: ...
    @_sympifyit("other", NotImplemented)
    def gcd(self, other) -> Rational | Integer | Any: ...
    @_sympifyit("other", NotImplemented)
    def lcm(self, other) -> Rational | Integer | Any: ...
    def as_numer_denom(self) -> tuple[Any | Integer, Any | Integer]: ...
    def as_content_primitive(
        self, radical=..., clear=...
    ) -> tuple[Self, Any] | tuple[Rational | Any | Integer, Any] | tuple[Any, Any]: ...
    def as_coeff_Mul(self, rational=...) -> tuple[Self, Any]: ...
    def as_coeff_Add(self, rational=...) -> tuple[Self, Any]: ...

class Integer(Rational):
    q = ...
    is_integer = ...
    is_number = ...
    is_Integer = ...
    __slots__ = ...
    @cacheit
    def __new__(cls, i) -> Self: ...
    def __getnewargs__(self) -> tuple[int]: ...
    def __int__(self) -> int: ...
    def floor(self) -> Integer: ...
    def ceiling(self) -> Integer: ...
    def __floor__(self) -> Integer: ...
    def __ceil__(self) -> Integer: ...
    def __neg__(self) -> Integer: ...
    def __abs__(self) -> Self | Integer: ...
    def __divmod__(self, other) -> tuple | tuple[Any, Any] | NotImplementedType: ...
    def __rdivmod__(self, other) -> tuple | tuple[Any, Any] | NotImplementedType: ...
    def __add__(self, other) -> Integer | Rational | Float | Order: ...
    def __radd__(self, other) -> Integer | Rational: ...
    def __sub__(self, other) -> Integer | Rational | Float: ...
    def __rsub__(self, other) -> Integer | Rational | Float | Order: ...
    def __mul__(self, other) -> Integer | Rational | Float | NotImplementedType: ...
    def __rmul__(self, other) -> Integer | Rational: ...
    def __mod__(self, other) -> Integer | Rational | Float: ...
    def __rmod__(self, other) -> Integer | Rational | Float: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def as_numer_denom(self) -> tuple[Self, Any]: ...
    @_sympifyit("other", NotImplemented)
    def __floordiv__(self, other) -> NotImplementedType | Integer | tuple: ...
    def __rfloordiv__(self, other) -> Integer: ...
    def __lshift__(self, other) -> Integer | NotImplementedType: ...
    def __rlshift__(self, other) -> Integer | NotImplementedType: ...
    def __rshift__(self, other) -> Integer | NotImplementedType: ...
    def __rrshift__(self, other) -> Integer | NotImplementedType: ...
    def __and__(self, other) -> Integer | NotImplementedType: ...
    def __rand__(self, other) -> Integer | NotImplementedType: ...
    def __xor__(self, other) -> Integer | NotImplementedType: ...
    def __rxor__(self, other) -> Integer | NotImplementedType: ...
    def __or__(self, other) -> Integer | NotImplementedType: ...
    def __ror__(self, other) -> Integer | NotImplementedType: ...
    def __invert__(self) -> Integer: ...

class AlgebraicNumber(Expr):
    __slots__ = ...
    is_AlgebraicNumber = ...
    is_algebraic = ...
    is_number = ...
    kind = ...
    free_symbols: set[Basic] = ...
    def __new__(cls, expr, coeffs=..., alias=..., **args) -> Self: ...
    def __hash__(self) -> int: ...
    @property
    def is_aliased(self) -> bool: ...
    def as_poly(self, x=...): ...
    def as_expr(self, x=...): ...
    def coeffs(self) -> list[Any]: ...
    def native_coeffs(self): ...
    def to_algebraic_integer(self) -> Self | AlgebraicNumber: ...
    def field_element(self, coeffs) -> AlgebraicNumber: ...
    @property
    def is_primitive_element(self) -> bool: ...
    def primitive_element(self) -> Self | AlgebraicNumber: ...
    def to_primitive_element(self, radicals=...) -> Self | AlgebraicNumber: ...
    def minpoly_of_element(self) -> Any: ...
    def to_root(self, radicals=..., minpoly=...) -> Any | None: ...

class RationalConstant(Rational):
    __slots__ = ...
    def __new__(cls) -> Self: ...

class IntegerConstant(Integer):
    __slots__ = ...
    def __new__(cls) -> Self: ...

class Zero(IntegerConstant, metaclass=Singleton):
    p = ...
    q = ...
    is_positive = ...
    is_negative = ...
    is_zero = ...
    is_number = ...
    is_comparable = ...
    __slots__ = ...
    def __getnewargs__(self) -> tuple[()]: ...
    @staticmethod
    def __abs__(): ...
    @staticmethod
    def __neg__(): ...
    def __bool__(self) -> Literal[False]: ...

class One(IntegerConstant, metaclass=Singleton):
    is_number = ...
    is_positive = ...
    p = ...
    q = ...
    __slots__ = ...
    def __getnewargs__(self) -> tuple[()]: ...
    @staticmethod
    def __abs__(): ...
    @staticmethod
    def __neg__(): ...
    @staticmethod
    def factors(limit=..., use_trial=..., use_rho=..., use_pm1=..., verbose=..., visual=...) -> dict[Any, Any]: ...

class NegativeOne(IntegerConstant, metaclass=Singleton):
    is_number = ...
    p = ...
    q = ...
    __slots__ = ...
    def __getnewargs__(self) -> tuple[()]: ...
    @staticmethod
    def __abs__(): ...
    @staticmethod
    def __neg__(): ...

class Half(RationalConstant, metaclass=Singleton):
    is_number = ...
    p = ...
    q = ...
    __slots__ = ...
    def __getnewargs__(self) -> tuple[()]: ...
    @staticmethod
    def __abs__(): ...

class Infinity(Number, metaclass=Singleton):
    is_commutative = ...
    is_number = ...
    is_complex = ...
    is_extended_real = ...
    is_infinite = ...
    is_comparable = ...
    is_extended_positive = ...
    is_prime = ...
    __slots__ = ...
    def __new__(cls) -> Self: ...
    def evalf(self, prec=..., **options) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other) -> Self: ...

    __radd__ = ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __rsub__(self, other): ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> Self | NotImplementedType: ...

    __rmul__ = ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other) -> Self: ...
    def __abs__(self): ...
    def __neg__(self): ...
    def __hash__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

    __gt__ = ...
    __ge__ = ...
    __lt__ = ...
    __le__ = ...
    @_sympifyit("other", NotImplemented)
    def __mod__(self, other) -> NotImplementedType: ...

    __rmod__ = ...
    def floor(self) -> Self: ...
    def ceiling(self) -> Self: ...

oo = ...

class NegativeInfinity(Number, metaclass=Singleton):
    is_extended_real = ...
    is_complex = ...
    is_commutative = ...
    is_infinite = ...
    is_comparable = ...
    is_extended_negative = ...
    is_number = ...
    is_prime = ...
    __slots__ = ...
    def __new__(cls) -> Self: ...
    def evalf(self, prec=..., **options) -> Float: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other) -> Self: ...

    __radd__ = ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __rsub__(self, other): ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> Self | NotImplementedType: ...

    __rmul__ = ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other) -> Self: ...
    def __abs__(self): ...
    def __neg__(self): ...
    def __hash__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

    __gt__ = ...
    __ge__ = ...
    __lt__ = ...
    __le__ = ...
    @_sympifyit("other", NotImplemented)
    def __mod__(self, other) -> NotImplementedType: ...

    __rmod__ = ...
    def floor(self) -> Self: ...
    def ceiling(self) -> Self: ...
    def as_powers_dict(self) -> dict[Any, int]: ...

class NaN(Number, metaclass=Singleton):
    is_commutative = ...
    is_extended_real = ...
    is_real = ...
    is_rational = ...
    is_algebraic = ...
    is_transcendental = ...
    is_integer = ...
    is_comparable = ...
    is_finite = ...
    is_zero = ...
    is_prime = ...
    is_positive = ...
    is_negative = ...
    is_number = ...
    __slots__ = ...
    def __new__(cls) -> Self: ...
    def __neg__(self) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __add__(self, other) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __sub__(self, other) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __mul__(self, other) -> Self: ...
    @_sympifyit("other", NotImplemented)
    def __truediv__(self, other) -> Self: ...
    def floor(self) -> Self: ...
    def ceiling(self) -> Self: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...

    __gt__ = ...
    __ge__ = ...
    __lt__ = ...
    __le__ = ...

nan = ...

class ComplexInfinity(AtomicExpr, metaclass=Singleton):
    is_commutative = ...
    is_infinite = ...
    is_number = ...
    is_prime = ...
    is_complex = ...
    is_extended_real = ...
    kind = ...
    __slots__ = ...
    def __new__(cls) -> Self: ...
    @staticmethod
    def __abs__(): ...
    def floor(self) -> Self: ...
    def ceiling(self) -> Self: ...
    @staticmethod
    def __neg__(): ...

zoo = ...

class NumberSymbol(AtomicExpr):
    is_commutative = ...
    is_finite = ...
    is_number = ...
    __slots__ = ...
    is_NumberSymbol = ...
    kind = ...
    def __new__(cls) -> Self: ...
    def approximation(self, number_cls) -> None: ...
    def __eq__(self, other) -> bool: ...
    def __ne__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
    def __int__(self) -> int: ...
    def __hash__(self) -> int: ...

class Exp1(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    is_algebraic = ...
    is_transcendental = ...
    __slots__ = ...
    @staticmethod
    def __abs__(): ...
    def __int__(self) -> int: ...
    def approximation_interval(self, number_cls) -> tuple[Any | Integer, Any | Integer] | None: ...

E = ...

class Pi(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    is_algebraic = ...
    is_transcendental = ...
    __slots__ = ...
    @staticmethod
    def __abs__(): ...
    def __int__(self) -> int: ...
    def approximation_interval(
        self, number_cls
    ) -> tuple[Any | Integer, Any | Integer] | tuple[Rational | Any | Integer, Rational | Any | Integer] | None: ...

pi = ...

class GoldenRatio(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    is_algebraic = ...
    is_transcendental = ...
    __slots__ = ...
    def __int__(self) -> int: ...
    def approximation_interval(self, number_cls) -> tuple[Any, Rational | Any | Integer] | None: ...

    _eval_rewrite_as_sqrt = ...

class TribonacciConstant(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    is_algebraic = ...
    is_transcendental = ...
    __slots__ = ...
    def __int__(self) -> int: ...
    def approximation_interval(self, number_cls) -> tuple[Any, Rational | Any | Integer] | None: ...

    _eval_rewrite_as_sqrt = ...

class EulerGamma(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    __slots__ = ...
    def __int__(self) -> int: ...
    def approximation_interval(self, number_cls) -> tuple[Any, Any] | tuple[Any, Rational | Any | Integer] | None: ...

class Catalan(NumberSymbol, metaclass=Singleton):
    is_real = ...
    is_positive = ...
    is_negative = ...
    is_irrational = ...
    is_number = ...
    __slots__ = ...
    def __int__(self) -> int: ...
    def approximation_interval(self, number_cls) -> tuple[Any, Any] | tuple[Rational | Any | Integer, Any] | None: ...

class ImaginaryUnit(AtomicExpr, metaclass=Singleton):
    is_commutative = ...
    is_imaginary = ...
    is_finite = ...
    is_number = ...
    is_algebraic = ...
    is_transcendental = ...
    kind = ...
    __slots__ = ...
    @staticmethod
    def __abs__(): ...
    def as_base_exp(self) -> tuple[Any, Any]: ...

I = ...

def equal_valued(x, y) -> Literal[False]: ...
def sympify_fractions(f) -> Rational | Integer: ...
def sympify_mpz(x) -> Integer: ...
def sympify_mpq(x) -> Rational | Integer: ...
def sympify_mpmath_mpq(x) -> Rational | Integer: ...
def sympify_mpmath(x) -> Float: ...
def sympify_complex(a): ...

_illegal = ...
