from collections.abc import Generator, Iterator
from typing import Any
from typing_extensions import Self

from sympy.core import Function, Tuple
from sympy.core.basic import Basic

Undefined = ...

class ExprCondPair(Tuple):
    def __new__(cls, expr, cond) -> Self: ...
    @property
    def expr(self) -> Basic: ...
    @property
    def cond(self) -> Basic: ...
    @property
    def is_commutative(self) -> bool | None: ...
    def __iter__(self) -> Iterator[Basic]: ...

class Piecewise(Function):
    nargs = ...
    is_Piecewise = ...
    def __new__(cls, *args, **options) -> Self: ...
    @classmethod
    def eval(cls, *_args) -> Self | None: ...
    def doit(self, **hints) -> Self: ...
    def piecewise_integrate(self, x, **kwargs) -> Self: ...

    _eval_is_finite = ...
    _eval_is_complex = ...
    _eval_is_even = ...
    _eval_is_imaginary = ...
    _eval_is_integer = ...
    _eval_is_irrational = ...
    _eval_is_negative = ...
    _eval_is_nonnegative = ...
    _eval_is_nonpositive = ...
    _eval_is_nonzero = ...
    _eval_is_odd = ...
    _eval_is_polar = ...
    _eval_is_positive = ...
    _eval_is_extended_real = ...
    _eval_is_extended_positive = ...
    _eval_is_extended_negative = ...
    _eval_is_extended_nonzero = ...
    _eval_is_extended_nonpositive = ...
    _eval_is_extended_nonnegative = ...
    _eval_is_real = ...
    _eval_is_zero = ...
    def as_expr_set_pairs(self, domain=...) -> list[Any]: ...

def piecewise_fold(expr, evaluate=...) -> Basic | Piecewise: ...
def piecewise_simplify_arguments(expr, **kwargs): ...

_blessed = ...

def piecewise_simplify(expr, **kwargs) -> Piecewise: ...
def piecewise_exclusive(expr, *, skip_nan=..., deep=...) -> Piecewise: ...
