from typing import Any, Callable, Literal
from typing_extensions import Self

from sympy.core.basic import Basic
from sympy.core.decorators import _sympifyit, call_highest_priority
from sympy.core.expr import Expr
from sympy.core.function import UndefinedFunction
from sympy.core.logic import FuzzyBool
from sympy.matrices import Matrix
from sympy.matrices.expressions.applyfunc import ElementwiseApplyFunction
from sympy.matrices.expressions.determinant import Determinant
from sympy.matrices.expressions.inverse import Inverse
from sympy.matrices.expressions.matadd import MatAdd
from sympy.matrices.expressions.matmul import MatMul
from sympy.matrices.expressions.matpow import MatPow
from sympy.matrices.expressions.slice import MatrixSlice
from sympy.matrices.expressions.special import GenericIdentity, GenericZeroMatrix, Identity
from sympy.matrices.expressions.transpose import Transpose
from sympy.matrices.immutable import ImmutableDenseMatrix
from sympy.matrices.kind import MatrixKind
from sympy.series.order import Order

class MatrixExpr(Expr):
    __slots__: tuple[str, ...] = ...
    _iterable = ...
    _op_priority = ...
    is_Matrix: bool = ...
    is_MatrixExpr: bool = ...
    is_Identity: FuzzyBool = ...
    is_Inverse = ...
    is_Transpose = ...
    is_ZeroMatrix = ...
    is_MatAdd = ...
    is_MatMul = ...
    is_commutative = ...
    is_number = ...
    is_symbol = ...
    is_scalar = ...
    kind: MatrixKind = ...
    def __new__(cls, *args, **kwargs) -> Self: ...
    @property
    def shape(self) -> tuple[Expr, Expr]: ...
    def __neg__(self) -> GenericIdentity | Order | object: ...
    def __abs__(self): ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__radd__")
    def __add__(self, other) -> MatAdd | GenericZeroMatrix: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__add__")
    def __radd__(self, other) -> MatAdd | GenericZeroMatrix: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__rsub__")
    def __sub__(self, other) -> MatAdd | GenericZeroMatrix: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__sub__")
    def __rsub__(self, other) -> MatAdd | GenericZeroMatrix: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__rmul__")
    def __mul__(self, other) -> GenericIdentity | Order | object: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__rmul__")
    def __matmul__(self, other) -> GenericIdentity | Order | object: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__mul__")
    def __rmul__(self, other) -> GenericIdentity | Order | object: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__mul__")
    def __rmatmul__(self, other) -> GenericIdentity | Order | object: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__rpow__")
    def __pow__(self, other) -> Inverse | Basic | Identity | Any | MatPow: ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__pow__")
    def __rpow__(self, other): ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__rtruediv__")
    def __truediv__(self, other): ...
    @_sympifyit("other", NotImplemented)
    @call_highest_priority("__truediv__")
    def __rtruediv__(self, other): ...
    @property
    def rows(self) -> Expr: ...
    @property
    def cols(self) -> Expr: ...
    @property
    def is_square(self) -> bool | None: ...
    def as_real_imag(self, deep=..., **hints) -> tuple[Any, Any]: ...
    def adjoint(self) -> type[UndefinedFunction]: ...
    def as_coeff_Mul(self, rational=...) -> tuple[Any, Self]: ...
    def conjugate(self) -> type[UndefinedFunction]: ...
    def transpose(self) -> Any | Transpose: ...
    @property
    def T(self) -> Any | Transpose: ...
    def inverse(self) -> Inverse: ...
    def inv(self) -> Inverse: ...
    def det(self) -> Determinant: ...
    @property
    def I(self) -> Inverse: ...
    def valid_index(self, i, j) -> Literal[False]: ...
    def __getitem__(self, key) -> MatrixSlice: ...
    def as_explicit(self) -> ImmutableDenseMatrix: ...
    def as_mutable(self) -> Matrix: ...
    def __array__(self): ...
    def equals(self, other) -> bool: ...
    def canonicalize(self) -> Self: ...
    def as_coeff_mmul(self) -> tuple[Any, GenericIdentity | Any | Order | object | MatMul]: ...
    @staticmethod
    def from_index_summation(expr, first_index=..., last_index=..., dimensions=...): ...
    def applyfunc(self, func) -> MatrixExpr | ElementwiseApplyFunction: ...

def get_postprocessor(cls) -> Callable[..., Any]: ...

class MatrixElement(Expr):
    parent = ...
    i = ...
    j = ...
    _diff_wrt = ...
    is_symbol = ...
    is_commutative = ...
    def __new__(cls, name, n, m) -> Self: ...
    @property
    def symbol(self) -> Basic: ...
    def doit(self, **hints): ...
    @property
    def indices(self) -> tuple[Basic, ...]: ...

class MatrixSymbol(MatrixExpr):
    is_commutative = ...
    is_symbol = ...
    _diff_wrt = ...
    def __new__(cls, name, n, m) -> Self: ...
    @property
    def shape(self) -> tuple[Basic, Basic]: ...
    @property
    def name(self): ...
    @property
    def free_symbols(self) -> set[Self]: ...

def matrix_symbols(expr) -> list[Any]: ...

class _LeftRightArgs:
    def __init__(self, lines, higher=...) -> None: ...
    @property
    def first_pointer(self): ...
    @first_pointer.setter
    def first_pointer(self, value) -> None: ...
    @property
    def second_pointer(self): ...
    @second_pointer.setter
    def second_pointer(self, value) -> None: ...
    def transpose(self) -> Self: ...
    def build(self) -> list[Any]: ...
    def matrix_form(self) -> Literal[1]: ...
    def rank(self) -> int: ...
    def append_first(self, other) -> None: ...
    def append_second(self, other) -> None: ...
