from typing import Any, Literal

from sympy.polys.rings import PolyElement
from sympy.polys.rootisolation import RealInterval
from sympy.utilities import public

@public
class IPolys:
    symbols = ...
    ngens = ...
    domain = ...
    order = ...
    gens = ...
    def drop(self, gen) -> None: ...
    def clone(self, symbols=..., domain=..., order=...) -> None: ...
    def to_ground(self) -> None: ...
    def ground_new(self, element) -> None: ...
    def domain_new(self, element) -> None: ...
    def from_dict(self, d) -> None: ...
    def wrap(self, element) -> PolyElement | None: ...
    def to_dense(self, element) -> list[Any] | list[list[Any]]: ...
    def from_dense(self, element) -> None: ...
    def dup_add_term(self, f, c, i) -> None: ...
    def dmp_add_term(self, f, c, i) -> None: ...
    def dup_sub_term(self, f, c, i) -> None: ...
    def dmp_sub_term(self, f, c, i) -> None: ...
    def dup_mul_term(self, f, c, i) -> None: ...
    def dmp_mul_term(self, f, c, i) -> None: ...
    def dup_add_ground(self, f, c) -> None: ...
    def dmp_add_ground(self, f, c) -> None: ...
    def dup_sub_ground(self, f, c) -> None: ...
    def dmp_sub_ground(self, f, c) -> None: ...
    def dup_mul_ground(self, f, c) -> None: ...
    def dmp_mul_ground(self, f, c) -> None: ...
    def dup_quo_ground(self, f, c) -> None: ...
    def dmp_quo_ground(self, f, c) -> None: ...
    def dup_exquo_ground(self, f, c) -> None: ...
    def dmp_exquo_ground(self, f, c) -> None: ...
    def dup_lshift(self, f, n) -> None: ...
    def dup_rshift(self, f, n) -> None: ...
    def dup_abs(self, f) -> None: ...
    def dmp_abs(self, f) -> None: ...
    def dup_neg(self, f) -> None: ...
    def dmp_neg(self, f) -> None: ...
    def dup_add(self, f, g) -> None: ...
    def dmp_add(self, f, g) -> None: ...
    def dup_sub(self, f, g) -> None: ...
    def dmp_sub(self, f, g) -> None: ...
    def dup_add_mul(self, f, g, h) -> None: ...
    def dmp_add_mul(self, f, g, h) -> None: ...
    def dup_sub_mul(self, f, g, h) -> None: ...
    def dmp_sub_mul(self, f, g, h) -> None: ...
    def dup_mul(self, f, g) -> None: ...
    def dmp_mul(self, f, g) -> None: ...
    def dup_sqr(self, f) -> None: ...
    def dmp_sqr(self, f) -> None: ...
    def dup_pow(self, f, n) -> None: ...
    def dmp_pow(self, f, n) -> None: ...
    def dup_pdiv(self, f, g) -> tuple[None, None]: ...
    def dup_prem(self, f, g) -> None: ...
    def dup_pquo(self, f, g) -> None: ...
    def dup_pexquo(self, f, g) -> None: ...
    def dmp_pdiv(self, f, g) -> tuple[None, None]: ...
    def dmp_prem(self, f, g) -> None: ...
    def dmp_pquo(self, f, g) -> None: ...
    def dmp_pexquo(self, f, g) -> None: ...
    def dup_rr_div(self, f, g) -> tuple[None, None]: ...
    def dmp_rr_div(self, f, g) -> tuple[None, None]: ...
    def dup_ff_div(self, f, g) -> tuple[None, None]: ...
    def dmp_ff_div(self, f, g) -> tuple[None, None]: ...
    def dup_div(self, f, g) -> tuple[None, None]: ...
    def dup_rem(self, f, g) -> None: ...
    def dup_quo(self, f, g) -> None: ...
    def dup_exquo(self, f, g) -> None: ...
    def dmp_div(self, f, g) -> tuple[None, None]: ...
    def dmp_rem(self, f, g) -> None: ...
    def dmp_quo(self, f, g) -> None: ...
    def dmp_exquo(self, f, g) -> None: ...
    def dup_max_norm(self, f): ...
    def dmp_max_norm(self, f): ...
    def dup_l1_norm(self, f) -> int: ...
    def dmp_l1_norm(self, f) -> int: ...
    def dup_l2_norm_squared(self, f) -> int: ...
    def dmp_l2_norm_squared(self, f) -> int: ...
    def dup_expand(self, polys) -> None: ...
    def dmp_expand(self, polys) -> None: ...
    def dup_LC(self, f): ...
    def dmp_LC(self, f): ...
    def dup_TC(self, f): ...
    def dmp_TC(self, f): ...
    def dmp_ground_LC(self, f): ...
    def dmp_ground_TC(self, f): ...
    def dup_degree(self, f) -> int: ...
    def dmp_degree(self, f) -> int: ...
    def dmp_degree_in(self, f, j) -> int: ...
    def dup_integrate(self, f, m) -> None: ...
    def dmp_integrate(self, f, m) -> None: ...
    def dup_diff(self, f, m) -> None: ...
    def dmp_diff(self, f, m) -> None: ...
    def dmp_diff_in(self, f, m, j) -> None: ...
    def dmp_integrate_in(self, f, m, j) -> None: ...
    def dup_eval(self, f, a): ...
    def dmp_eval(self, f, a): ...
    def dmp_eval_in(self, f, a, j): ...
    def dmp_diff_eval_in(self, f, m, a, j): ...
    def dmp_eval_tail(self, f, A): ...
    def dup_trunc(self, f, p) -> None: ...
    def dmp_trunc(self, f, g) -> None: ...
    def dmp_ground_trunc(self, f, p) -> None: ...
    def dup_monic(self, f) -> None: ...
    def dmp_ground_monic(self, f) -> None: ...
    def dup_extract(self, f, g) -> tuple[Any, None, None]: ...
    def dmp_ground_extract(self, f, g) -> tuple[Any, None, None]: ...
    def dup_real_imag(self, f) -> tuple[None, None]: ...
    def dup_mirror(self, f) -> None: ...
    def dup_scale(self, f, a) -> None: ...
    def dup_shift(self, f, a) -> None: ...
    def dup_transform(self, f, p, q) -> None: ...
    def dup_compose(self, f, g) -> None: ...
    def dmp_compose(self, f, g) -> None: ...
    def dup_decompose(self, f) -> list[None]: ...
    def dmp_lift(self, f): ...
    def dup_sign_variations(self, f) -> int: ...
    def dup_clear_denoms(self, f, convert=...) -> tuple[Any, None]: ...
    def dmp_clear_denoms(self, f, convert=...) -> tuple[Any, None]: ...
    def dup_revert(self, f, n) -> None: ...
    def dup_half_gcdex(self, f, g) -> tuple[None, None]: ...
    def dmp_half_gcdex(self, f, g) -> tuple[None, None]: ...
    def dup_gcdex(self, f, g) -> tuple[None, None, None]: ...
    def dmp_gcdex(self, f, g) -> tuple[None, None, None]: ...
    def dup_invert(self, f, g) -> None: ...
    def dmp_invert(self, f, g) -> None: ...
    def dup_euclidean_prs(self, f, g) -> list[None]: ...
    def dmp_euclidean_prs(self, f, g) -> list[None]: ...
    def dup_primitive_prs(self, f, g) -> list[None]: ...
    def dmp_primitive_prs(self, f, g) -> list[None]: ...
    def dup_inner_subresultants(self, f, g) -> tuple[list[None], list[Any]]: ...
    def dmp_inner_subresultants(self, f, g) -> tuple[list[None], list[list[list[Any]] | Any | list[Any]]]: ...
    def dup_subresultants(self, f, g) -> list[None]: ...
    def dmp_subresultants(self, f, g) -> list[None]: ...
    def dup_prs_resultant(self, f, g) -> tuple[Any, list[None]]: ...
    def dmp_prs_resultant(self, f, g) -> tuple[Any, list[None]]: ...
    def dmp_zz_modular_resultant(self, f, g, p): ...
    def dmp_zz_collins_resultant(self, f, g): ...
    def dmp_qq_collins_resultant(self, f, g): ...
    def dup_resultant(self, f, g) -> tuple[Any, list[Any]]: ...
    def dmp_resultant(
        self, f, g
    ) -> tuple[Any, list[Any]] | tuple[list[list[Any]], list[Any]] | tuple[list[list[Any]] | Any | list[Any], list[Any]]: ...
    def dup_discriminant(self, f): ...
    def dmp_discriminant(self, f): ...
    def dup_rr_prs_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dup_ff_prs_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dmp_rr_prs_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dmp_ff_prs_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dup_zz_heu_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dmp_zz_heu_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dup_qq_heu_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dmp_qq_heu_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dup_inner_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dmp_inner_gcd(self, f, g) -> tuple[None, None, None]: ...
    def dup_gcd(self, f, g) -> None: ...
    def dmp_gcd(self, f, g) -> None: ...
    def dup_rr_lcm(self, f, g) -> None: ...
    def dup_ff_lcm(self, f, g) -> None: ...
    def dup_lcm(self, f, g) -> None: ...
    def dmp_rr_lcm(self, f, g) -> None: ...
    def dmp_ff_lcm(self, f, g) -> None: ...
    def dmp_lcm(self, f, g) -> None: ...
    def dup_content(self, f): ...
    def dup_primitive(self, f) -> tuple[Any, None]: ...
    def dmp_content(self, f): ...
    def dmp_primitive(self, f) -> tuple[Any, None]: ...
    def dmp_ground_content(self, f): ...
    def dmp_ground_primitive(self, f) -> tuple[Any, None]: ...
    def dup_cancel(self, f, g, include=...) -> tuple[Any | list[Any], Any | list[Any], None, None] | tuple[None, None]: ...
    def dmp_cancel(self, f, g, include=...) -> tuple[Any | list[Any], Any | list[Any], None, None] | tuple[None, None]: ...
    def dup_trial_division(self, f, factors) -> list[tuple[None, Any]]: ...
    def dmp_trial_division(self, f, factors) -> list[tuple[None, Any]]: ...
    def dup_zz_mignotte_bound(self, f): ...
    def dmp_zz_mignotte_bound(self, f): ...
    def dup_zz_hensel_step(self, m, f, g, h, s, t) -> tuple[None, None, None, None]: ...
    def dup_zz_hensel_lift(self, p, f, f_list, l) -> list[None]: ...
    def dup_zz_zassenhaus(self, f) -> list[tuple[None, Any]]: ...
    def dup_zz_irreducible_p(self, f) -> Literal[True] | None: ...
    def dup_cyclotomic_p(self, f, irreducible=...) -> bool: ...
    def dup_zz_cyclotomic_poly(self, n) -> None: ...
    def dup_zz_cyclotomic_factor(self, f) -> list[None] | None: ...
    def dmp_zz_wang_non_divisors(self, E, cs, ct) -> list[Any] | None: ...
    def dmp_zz_wang_lead_coeffs(self, f, T, cs, E, H, A) -> tuple[None, list[Any], list[Any]]: ...
    def dup_zz_diophantine(self, F, m, p) -> list[None]: ...
    def dmp_zz_diophantine(self, F, c, A, d, p) -> list[None]: ...
    def dmp_zz_wang_hensel_lifting(self, f, H, LC, A, p) -> list[None]: ...
    def dmp_zz_wang(self, f, mod=..., seed=...) -> list[None]: ...
    def dup_zz_factor_sqf(self, f) -> tuple[Any, list[None]]: ...
    def dup_zz_factor(self, f) -> tuple[Any, list[tuple[None, Literal[1]]]]: ...
    def dmp_zz_factor(self, f) -> tuple[Any, list[tuple[None, Literal[1]]]]: ...
    def dup_qq_i_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_qq_i_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_zz_i_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_zz_i_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_ext_factor(self, f) -> tuple[Any, list[tuple[None, Any | int]]]: ...
    def dmp_ext_factor(self, f) -> tuple[Any, list[tuple[None, Any | int]]]: ...
    def dup_gf_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_gf_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_factor_list(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_factor_list_include(self, f) -> list[tuple[None, Any | Literal[1]]]: ...
    def dmp_factor_list(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_factor_list_include(self, f) -> list[tuple[None, Any | Literal[1]]]: ...
    def dup_irreducible_p(self, f) -> bool: ...
    def dmp_irreducible_p(self, f) -> bool: ...
    def dup_sturm(self, f) -> list[None]: ...
    def dup_sqf_p(self, f) -> bool: ...
    def dmp_sqf_p(self, f) -> bool: ...
    def dup_sqf_norm(self, f) -> tuple[int, None, Any]: ...
    def dmp_sqf_norm(self, f) -> tuple[int, None, Any]: ...
    def dup_gf_sqf_part(self, f) -> None: ...
    def dmp_gf_sqf_part(self, f) -> None: ...
    def dup_sqf_part(self, f) -> None: ...
    def dmp_sqf_part(self, f) -> None: ...
    def dup_gf_sqf_list(self, f, all=...) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_gf_sqf_list(self, f, all=...) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_sqf_list(self, f, all=...) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dup_sqf_list_include(self, f, all=...) -> list[tuple[None, Literal[1]]]: ...
    def dmp_sqf_list(self, f, all=...) -> tuple[Any, list[tuple[None, Any]]]: ...
    def dmp_sqf_list_include(self, f, all=...) -> list[tuple[None, Literal[1]]]: ...
    def dup_gff_list(self, f) -> list[tuple[None, Any]]: ...
    def dmp_gff_list(self, f) -> list[tuple[None, Any]]: ...
    def dup_root_upper_bound(self, f) -> None: ...
    def dup_root_lower_bound(self, f) -> None: ...
    def dup_step_refine_real_root(
        self, f, M, fast=...
    ) -> (
        tuple[Any, tuple[Any, Any, Any, Any]]
        | tuple[list[Any], tuple[Any, Any, Any, Any]]
        | tuple[list[Any] | Any, tuple[Any, Any, Any, Any]]
    ): ...
    def dup_inner_refine_real_root(
        self, f, M, eps=..., steps=..., disjoint=..., fast=..., mobius=...
    ) -> tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]: ...
    def dup_outer_refine_real_root(
        self, f, s, t, eps=..., steps=..., disjoint=..., fast=...
    ) -> tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]: ...
    def dup_refine_real_root(
        self, f, s, t, eps=..., steps=..., disjoint=..., fast=...
    ) -> tuple[Any, Any] | tuple[Any | list[Any], Any | tuple[Any, Any, Any, Any]]: ...
    def dup_inner_isolate_real_roots(
        self, f, eps=..., fast=...
    ) -> list[Any] | list[tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]]: ...
    def dup_inner_isolate_positive_roots(
        self, f, eps=..., inf=..., sup=..., fast=..., mobius=...
    ) -> list[Any] | list[tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]]: ...
    def dup_inner_isolate_negative_roots(
        self, f, inf=..., sup=..., eps=..., fast=..., mobius=...
    ) -> list[Any] | list[tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]]: ...
    def dup_isolate_real_roots_sqf(
        self, f, eps=..., inf=..., sup=..., fast=..., blackbox=...
    ) -> list[Any] | list[tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]] | list[RealInterval]: ...
    def dup_isolate_real_roots(
        self, f, eps=..., inf=..., sup=..., basis=..., fast=...
    ) -> list[Any] | list[tuple[tuple[Any, Any], Any, Any] | tuple[Any, Any]]: ...
    def dup_isolate_real_roots_list(
        self, polys, eps=..., inf=..., sup=..., strict=..., basis=..., fast=...
    ) -> list[tuple[tuple[Any, Any], Any, Any] | tuple[tuple[Any, Any], dict[Any, Any]]]: ...
    def dup_count_real_roots(self, f, inf=..., sup=...) -> int: ...
    def dup_count_complex_roots(self, f, inf=..., sup=..., exclude=...) -> int: ...
    def dup_isolate_complex_roots_sqf(self, f, eps=..., inf=..., sup=..., blackbox=...): ...
    def dup_isolate_all_roots_sqf(
        self, f, eps=..., inf=..., sup=..., fast=..., blackbox=...
    ) -> tuple[
        list[Any] | list[tuple[Any, Any] | tuple[Any | list[Any], tuple[Any, Any, Any, Any]]] | list[RealInterval], Any
    ]: ...
    def dup_isolate_all_roots(
        self, f, eps=..., inf=..., sup=..., fast=...
    ) -> tuple[list[tuple[tuple[Any | list[Any], Any | tuple[Any, Any, Any, Any]], Any]], list[tuple[tuple[Any, Any], Any]]]: ...
    def fateman_poly_F_1(self) -> tuple[None, ...]: ...
    def fateman_poly_F_2(self) -> tuple[None, ...]: ...
    def fateman_poly_F_3(self) -> tuple[None, ...]: ...
    def to_gf_dense(self, element): ...
    def from_gf_dense(self, element) -> None: ...
    def gf_degree(self, f) -> int: ...
    def gf_LC(self, f): ...
    def gf_TC(self, f): ...
    def gf_strip(self, f) -> None: ...
    def gf_trunc(self, f) -> None: ...
    def gf_normal(self, f) -> None: ...
    def gf_from_dict(self, f) -> None: ...
    def gf_to_dict(self, f, symmetric=...) -> dict[Any, Any]: ...
    def gf_from_int_poly(self, f) -> None: ...
    def gf_to_int_poly(self, f, symmetric=...) -> list[Any]: ...
    def gf_neg(self, f) -> None: ...
    def gf_add_ground(self, f, a) -> None: ...
    def gf_sub_ground(self, f, a) -> None: ...
    def gf_mul_ground(self, f, a) -> None: ...
    def gf_quo_ground(self, f, a) -> None: ...
    def gf_add(self, f, g) -> None: ...
    def gf_sub(self, f, g) -> None: ...
    def gf_mul(self, f, g) -> None: ...
    def gf_sqr(self, f) -> None: ...
    def gf_add_mul(self, f, g, h) -> None: ...
    def gf_sub_mul(self, f, g, h) -> None: ...
    def gf_expand(self, F) -> None: ...
    def gf_div(self, f, g) -> tuple[None, None]: ...
    def gf_rem(self, f, g) -> None: ...
    def gf_quo(self, f, g) -> None: ...
    def gf_exquo(self, f, g) -> None: ...
    def gf_lshift(self, f, n) -> None: ...
    def gf_rshift(self, f, n) -> None: ...
    def gf_pow(self, f, n) -> None: ...
    def gf_pow_mod(self, f, n, g) -> None: ...
    def gf_cofactors(self, f, g) -> tuple[None, None, None]: ...
    def gf_gcd(self, f, g) -> None: ...
    def gf_lcm(self, f, g) -> None: ...
    def gf_gcdex(self, f, g) -> None: ...
    def gf_monic(self, f) -> None: ...
    def gf_diff(self, f) -> None: ...
    def gf_eval(self, f, a): ...
    def gf_multi_eval(self, f, A) -> list[Any]: ...
    def gf_compose(self, f, g) -> None: ...
    def gf_compose_mod(self, g, h, f) -> None: ...
    def gf_trace_map(self, a, b, c, n, f) -> tuple[None, None]: ...
    def gf_random(self, n) -> None: ...
    def gf_irreducible(self, n) -> None: ...
    def gf_irred_p_ben_or(self, f) -> bool: ...
    def gf_irred_p_rabin(self, f) -> bool: ...
    def gf_irreducible_p(self, f) -> bool: ...
    def gf_sqf_p(self, f) -> bool: ...
    def gf_sqf_part(self, f) -> None: ...
    def gf_sqf_list(self, f, all=...) -> tuple[Any, list[tuple[None, Any]]]: ...
    def gf_Qmatrix(self, f) -> list[list[Any]]: ...
    def gf_berlekamp(self, f) -> list[None]: ...
    def gf_ddf_zassenhaus(self, f) -> list[tuple[None, Any]]: ...
    def gf_edf_zassenhaus(self, f, n) -> list[None]: ...
    def gf_ddf_shoup(self, f) -> list[tuple[None, Any]]: ...
    def gf_edf_shoup(self, f, n) -> list[None]: ...
    def gf_zassenhaus(self, f) -> list[None]: ...
    def gf_shoup(self, f) -> list[None]: ...
    def gf_factor_sqf(self, f, method=...) -> tuple[Any, list[None]]: ...
    def gf_factor(self, f) -> tuple[Any, list[tuple[None, Any]]]: ...
