from ctypes import Structure
from typing import ClassVar

# Based on Pyglet code

##############################################################################
# cocoatypes.py

__LP64__ = ...
__i386__ = ...

PyObjectEncoding: str = ...

def encoding_for_ctype(vartype): ...

NSIntegerEncoding = ...
NSUIntegerEncoding = ...
CGFloatEncoding = ...

CGImageEncoding: str = ...
NSZoneEncoding: str = ...

class NSPoint(Structure):
    _fields_: ClassVar[list]

CGPoint = NSPoint

class NSSize(Structure):
    _fields_: ClassVar[list]

CGSize = NSSize

class NSRect(Structure):
    _fields_: ClassVar[list]

CGRect = NSRect

NSTimeInterval = ...
CFIndex = ...
UniChar = ...
unichar = ...
CGGlyph = ...

class CFRange(Structure):
    _fields_: ClassVar[list]

class NSRange(Structure):
    _fields_: ClassVar[list]

CFTypeID = ...
CFNumberType = ...

##############################################################################
# runtime.py

__LP64__ = ...
__i386__ = ...

objc = ...

class OBJC_METHOD_DESCRIPTION(Structure):
    _fields_ = ...

def ensure_bytes(x): ...
def get_selector(name): ...
def get_class(name): ...
def get_object_class(obj): ...
def get_metaclass(name): ...
def get_superclass_of_object(obj): ...
def x86_should_use_stret(restype): ...
def should_use_fpret(restype): ...
def send_message(receiver, selName, *args, **kwargs): ...

class OBJC_SUPER(Structure):
    _fields_: ClassVar[list]

OBJC_SUPER_PTR = ...

def send_super(receiver, selName, *args, **kwargs): ...

cfunctype_table: dict = ...

def parse_type_encoding(encoding): ...
def cfunctype_for_encoding(encoding): ...
def create_subclass(superclass, name): ...
def register_subclass(subclass): ...
def add_method(cls, selName, method, types): ...
def add_ivar(cls, name, vartype): ...
def set_instance_variable(obj, varname, value, vartype): ...
def get_instance_variable(obj, varname, vartype): ...

class ObjCMethod:
    typecodes: dict = ...
    cfunctype_table: dict = ...

    def __init__(self, method): ...
    def ctype_for_encoding(self, encoding): ...
    def get_prototype(self): ...
    def __repr__(self): ...
    def get_callable(self): ...
    def __call__(self, objc_id, *args): ...

class ObjCBoundMethod:
    def __init__(self, method, objc_id): ...
    def __repr__(self): ...
    def __call__(self, *args): ...

class ObjCClass:
    _registered_classes: dict = ...

    def __new__(cls, class_name_or_ptr): ...
    def __repr__(self): ...
    def cache_instance_methods(self): ...
    def cache_class_methods(self): ...
    def get_instance_method(self, name): ...
    def get_class_method(self, name): ...
    def __getattr__(self, name): ...

class ObjCInstance:
    _cached_objects: dict = ...

    def __new__(cls, object_ptr): ...
    def __repr__(self): ...
    def __getattr__(self, name): ...

def convert_method_arguments(encoding, args): ...

class ObjCSubclass:
    def __init__(self, superclass, name, register=True): ...
    def register(self): ...
    def add_ivar(self, varname, vartype): ...
    def add_method(self, method, name, encoding): ...
    def add_class_method(self, method, name, encoding): ...
    def rawmethod(self, encoding): ...
    def method(self, encoding): ...
    def classmethod(self, encoding): ...

##############################################################################
# cocoalibs.py

cf = ...

kCFStringEncodingUTF8: int = ...

CFAllocatorRef = ...
CFStringEncoding = ...

def CFSTR(string): ...
def get_NSString(string): ...
def cfstring_to_string(cfstring): ...

# CFNumber.h
kCFNumberSInt8Type: int = ...
kCFNumberSInt16Type: int = ...
kCFNumberSInt32Type: int = ...
kCFNumberSInt64Type: int = ...
kCFNumberFloat32Type: int = ...
kCFNumberFloat64Type: int = ...
kCFNumberCharType: int = ...
kCFNumberShortType: int = ...
kCFNumberIntType: int = ...
kCFNumberLongType: int = ...
kCFNumberLongLongType: int = ...
kCFNumberFloatType: int = ...
kCFNumberDoubleType: int = ...
kCFNumberCFIndexType: int = ...
kCFNumberNSIntegerType: int = ...
kCFNumberCGFloatType: int = ...
kCFNumberMaxType: int = ...

def cfnumber_to_number(cfnumber): ...

# Dictionary of cftypes matched to the method converting them to python values.
known_cftypes: dict = ...

def cftype_to_value(cftype): ...
def cfset_to_set(cfset): ...
def cfarray_to_list(cfarray): ...

kCFRunLoopDefaultMode = ...

######################################################################

# APPLICATION KIT

# Even though we don't use this directly, it must be loaded so that
# we can find the NSApplication, NSWindow, and NSView classes.
appkit = ...

NSDefaultRunLoopMode = ...
NSEventTrackingRunLoopMode = ...
NSApplicationDidHideNotification = ...
NSApplicationDidUnhideNotification = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSEvent.h
# NSAnyEventMask = 0xFFFFFFFFL     # NSUIntegerMax
# Commented out b/c not Py3k compatible

NSKeyDown: int = ...
NSKeyUp: int = ...
NSFlagsChanged: int = ...
NSApplicationDefined: int = ...

NSAlphaShiftKeyMask = ...
NSShiftKeyMask = ...
NSControlKeyMask = ...
NSAlternateKeyMask = ...
NSCommandKeyMask = ...
NSNumericPadKeyMask = ...
NSHelpKeyMask = ...
NSFunctionKeyMask = ...

NSInsertFunctionKey: int = ...
NSDeleteFunctionKey: int = ...
NSHomeFunctionKey: int = ...
NSBeginFunctionKey: int = ...
NSEndFunctionKey: int = ...
NSPageUpFunctionKey: int = ...
NSPageDownFunctionKey: int = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSWindow.h
NSBorderlessWindowMask: int = ...
NSTitledWindowMask = ...
NSClosableWindowMask = ...
NSMiniaturizableWindowMask = ...
NSResizableWindowMask = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSPanel.h
NSUtilityWindowMask = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSGraphics.h
NSBackingStoreRetained: int = ...
NSBackingStoreNonretained: int = ...
NSBackingStoreBuffered: int = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSTrackingArea.h
NSTrackingMouseEnteredAndExited: int = ...
NSTrackingMouseMoved: int = ...
NSTrackingCursorUpdate: int = ...
NSTrackingActiveInActiveApp: int = ...

# /System/Library/Frameworks/AppKit.framework/Headers/NSOpenGL.h
NSOpenGLPFAAllRenderers: int = ...  # choose from all available renderers
NSOpenGLPFADoubleBuffer: int = ...  # choose a double buffered pixel format
NSOpenGLPFAStereo: int = ...  # stereo buffering supported
NSOpenGLPFAAuxBuffers: int = ...  # number of aux buffers
NSOpenGLPFAColorSize: int = ...  # number of color buffer bits
NSOpenGLPFAAlphaSize: int = ...  # number of alpha component bits
NSOpenGLPFADepthSize: int = ...  # number of depth buffer bits
NSOpenGLPFAStencilSize: int = ...  # number of stencil buffer bits
NSOpenGLPFAAccumSize: int = ...  # number of accum buffer bits
NSOpenGLPFAMinimumPolicy: int = ...  # never choose smaller buffers than requested
NSOpenGLPFAMaximumPolicy: int = ...  # choose largest buffers of type requested
NSOpenGLPFAOffScreen: int = ...  # choose an off-screen capable renderer
NSOpenGLPFAFullScreen: int = ...  # choose a full-screen capable renderer
NSOpenGLPFASampleBuffers: int = ...  # number of multi sample buffers
NSOpenGLPFASamples: int = ...  # number of samples per multi sample buffer
NSOpenGLPFAAuxDepthStencil: int = ...  # each aux buffer has its own depth stencil
NSOpenGLPFAColorFloat: int = ...  # color buffers store floating point pixels
NSOpenGLPFAMultisample: int = ...  # choose multisampling
NSOpenGLPFASupersample: int = ...  # choose supersampling
NSOpenGLPFASampleAlpha: int = ...  # request alpha filtering
NSOpenGLPFARendererID: int = ...  # request renderer by ID
NSOpenGLPFASingleRenderer: int = ...  # choose a single renderer for all screens
NSOpenGLPFANoRecovery: int = ...  # disable all failure recovery systems
NSOpenGLPFAAccelerated: int = ...  # choose a hardware accelerated renderer
NSOpenGLPFAClosestPolicy: int = ...  # choose the closest color buffer to request
NSOpenGLPFARobust: int = ...  # renderer does not need failure recovery
NSOpenGLPFABackingStore: int = ...  # back buffer contents are valid after swap
NSOpenGLPFAMPSafe: int = ...  # renderer is multi-processor safe
NSOpenGLPFAWindow: int = ...  # can be used to render to an onscreen window
NSOpenGLPFAMultiScreen: int = ...  # single window can span multiple screens
NSOpenGLPFACompliant: int = ...  # renderer is opengl compliant
NSOpenGLPFAScreenMask: int = ...  # bit mask of supported physical screens
NSOpenGLPFAPixelBuffer: int = ...  # can be used to render to a pbuffer
# can be used to render offline to a pbuffer
NSOpenGLPFARemotePixelBuffer: int = ...
NSOpenGLPFAAllowOfflineRenderers: int = ...  # allow use of offline renderers
# choose a hardware accelerated compute device
NSOpenGLPFAAcceleratedCompute: int = ...
# number of virtual screens in this format
NSOpenGLPFAVirtualScreenCount: int = ...

NSOpenGLCPSwapInterval: int = ...

# /System/Library/Frameworks/ApplicationServices.framework/Frameworks/...
#     CoreGraphics.framework/Headers/CGImage.h
kCGImageAlphaNone: int = ...
kCGImageAlphaPremultipliedLast: int = ...
kCGImageAlphaPremultipliedFirst: int = ...
kCGImageAlphaLast: int = ...
kCGImageAlphaFirst: int = ...
kCGImageAlphaNoneSkipLast: int = ...
kCGImageAlphaNoneSkipFirst: int = ...
kCGImageAlphaOnly: int = ...

kCGBitmapAlphaInfoMask: int = ...
kCGBitmapFloatComponents = ...

kCGBitmapByteOrderMask: int = ...
kCGBitmapByteOrderDefault = ...
kCGBitmapByteOrder16Little = ...
kCGBitmapByteOrder32Little = ...
kCGBitmapByteOrder16Big = ...
kCGBitmapByteOrder32Big = ...

# NSApplication.h
NSApplicationPresentationDefault: int = ...
NSApplicationPresentationHideDock = ...
NSApplicationPresentationHideMenuBar = ...
NSApplicationPresentationDisableProcessSwitching = ...
NSApplicationPresentationDisableHideApplication = ...

# NSRunningApplication.h
NSApplicationActivationPolicyRegular: int = ...
NSApplicationActivationPolicyAccessory: int = ...
NSApplicationActivationPolicyProhibited: int = ...

######################################################################

# QUARTZ / COREGRAPHICS

quartz = ...

CGDirectDisplayID = ...  # CGDirectDisplay.h
CGError = ...  # CGError.h
CGBitmapInfo = ...  # CGImage.h

# /System/Library/Frameworks/ApplicationServices.framework/Frameworks/...
#     ImageIO.framework/Headers/CGImageProperties.h
kCGImagePropertyGIFDictionary = ...
kCGImagePropertyGIFDelayTime = ...

# /System/Library/Frameworks/ApplicationServices.framework/Frameworks/...
#     CoreGraphics.framework/Headers/CGColorSpace.h
kCGRenderingIntentDefault: int = ...

######################################################################

# CORETEXT
ct = ...

# Types
CTFontOrientation = ...  # CTFontDescriptor.h
CTFontSymbolicTraits = ...  # CTFontTraits.h

# CoreText constants
kCTFontAttributeName = ...
kCTFontFamilyNameAttribute = ...
kCTFontSymbolicTrait = ...
kCTFontWeightTrait = ...
kCTFontTraitsAttribute = ...

# constants from CTFontTraits.h
kCTFontItalicTrait = ...
kCTFontBoldTrait = ...

######################################################################

# FOUNDATION

# foundation = cdll.LoadLibrary(util.find_library('Foundation'))

# foundation.NSMouseInRect.restype = c_bool
# foundation.NSMouseInRect.argtypes = [NSPoint, NSRect, c_bool]
