# Quarkus Tools for Visual Studio Code
This extension provides tools to get you up and running with Quarkus
application development in Visual Studio Code.

Maven 3.5.3+ supported

[Create a new Maven based Quarkus project]() or open an existing Quarkus project to get started.
<!-- The link for "Create a new Quarkus project" above would ideally start the wizard to
generate a new Quarkus project -->

## Requirements
The [Java Extension Pack](https://marketplace.visualstudio.com/items?itemName=vscjava.vscode-java-pack) is highly recommended.

* Java JDK (or JRE) 8 or more recent
* [Language Support for Java(TM) by Red Hat](https://marketplace.visualstudio.com/items?itemName=redhat.java)
* [Debugger for Java](https://marketplace.visualstudio.com/items?itemName=vscjava.vscode-java-debug)

## New to Quarkus?
Refer to the Quarkus Getting Started guide. The guide provides instructions from
starting your first project, to creating a native executable. 

[View Getting Started guide](https://quarkus.io/get-started/)

[View Quarkus Cheat-Sheet](https://lordofthejars.github.io/quarkus-cheat-sheet/)

## Documentation
The Quarkus guides from quarkus.io/guides provides detailed documentation and
tutorials for different use cases.

[View guides]()

## Sample projects
Explore a wide variety of Quarkus quickstart projects, each focusing on a different aspect
of Quarkus application development.

[View quickstart projects](https://github.com/quarkusio/quarkus-quickstarts)

## Getting help
Keep in touch with the Quarkus community; there are many ways to reach out.

[View community links](https://quarkus.io/community/)
<!---
Instead of the GitHub link I think it would be nice if it links to a page showing all 
of the quick start projects, similiar to the IBM's "Follow Tutorials" link
-->

<!---
Since there are so many guides, it would be better to link to a VS Code webview
showing all the guides.
-->


<!---
All the guides are below:
-->

<!-- ### Core
* Configuring Your Application
* Application Initialization and Termination
* Contexts and Dependency Injection
* Testing Your Application
* Configuring Logging
* Using SSL With Native Images
* Context Propagation
### Web
* Writing REST JSON Services
* Validation with Hibernate Validator
* Using the REST Client
* Using JWT RBAC
* Using WebSockets
* Using OpenAPI and Swagger UI
* Undertow Reference Documentation
* Using Fault Tolerance
### Data
* Configuring your datasources
* Using Hibernate ORM and JPA
* Simplified Hibernate ORM with Panache
* Hibernate Search + Elasticsearch
* Using Infinispan Client
* Using Transactions
* Validation with Hibernate Validator
* Schema Migration with Flyway
* Reactive Postgres Client
* MongoDB Client
* Neo4j Client
### Messaging
* Using Apache Kafka
* Using AMQP with Reactive Messaging
* Using Apache Kafka Streams
* Asynchronous Message Passing
### Security
* Using Security
* Using JWT RBAC
* Using Keycloak to Protect JAX-RS Applications
* Using OAuth2 RBAC
### Business Automation
* Using Kogito to add business automation capabilities to an application
### Cloud
* Deploying Native Applications on Kubernetes or OpenShift
* Deploying Native Applications on Knative Kubernetes or OpenShift
* Generating Kubernetes Resources
* Using the Kubernetes Client to Interact with a Kubernetes Cluster
* Deploying to OpenShift using S2I
* Deploying to Microsoft Azure Cloud
### Observability
* Using Health Check
* Using OpenTracing
* Collecting Metrics
* Using Fault Tolerance
### Serialization
* Writing REST JSON Services
### Tooling
* Building Applications with Maven
* Building Applications with Gradle
* Measuring the coverage of your tests
### Migration
* Using the Quarkus Extension for Spring DI API
* Using the Quarkus Extension for Spring Web API
* Using the Quarkus Extension for Spring Data JPA API
### Writing Extensions
* Writing Your Own Extension
* Writing Native Applications
### Alternative Languages
* Using Kotlin
### Miscellaneous
* Scheduling Periodic Tasks
* Sending Emails
* Extracting Content with Apache Tika
* Using Vert.x
* Measuring Performance -->