import { ExtensionContext } from "vscode";
import { Level, Recommendation, RecommendationModel, RecommendationsTelemetryService, UserChoice } from "../recommendationModel";
import { IRecommendationService } from "../recommendationService";
import { IStorageService } from "../storageService";
export declare const filterUnique: (value: any, index: number, self: any[]) => boolean;
/**
* Command string to render markdown string to html string
*/
export declare const COMMAND_MARKDOWN_API_RENDER = "markdown.api.render";
export declare enum IgnoreBehavior {
    StartupOnly = "StartupOnly",
    All = "All",
    SingleRecommendation = "SingleRecommendation"
}
export declare class RecommendationServiceImpl implements IRecommendationService {
    private storageService;
    private extensionContext;
    private telemetryService;
    constructor(context: ExtensionContext, telemetryService?: RecommendationsTelemetryService);
    protected createStorageService(context: ExtensionContext): IStorageService;
    protected getRecommendationWorkingDir(context: ExtensionContext): string;
    register(toAdd: Recommendation[]): Promise<void>;
    create(extensionId: string, extensionDisplayName: string, description: string, shouldShowOnStartup: boolean): Recommendation;
    addRecommendationsToModel(toAdd: Recommendation[]): Promise<boolean>;
    protected findRecommendation(needleFrom: string, needleTo: string, haystack: Recommendation[]): Recommendation | undefined;
    show(toExtension: string, ignoreTimelock: boolean, overrideDescription?: string, level?: Level, hideNever?: boolean): Promise<UserChoice | undefined>;
    showStartupRecommendations(): Promise<void>;
    protected showStartupRecommendationsForSingleExtension(model: RecommendationModel, id: string): Promise<void>;
    protected safeDescriptionWithPeriod(description: string): string;
    protected linkToMore(id: string): string;
    protected collectMessage(id: string, displayName: string, recommendationsForId: Recommendation[]): string;
    protected collectShowNowMessage(id: string, displayName: string, primary: Recommendation, recommendationsForId: Recommendation[]): string;
    protected collectMultiCountMessage(id: string, displayName: string, recommendationsForId: Recommendation[]): string;
    protected findMode(arr: string[]): string | undefined;
    protected displaySingleRecommendation(id: string, extensionDisplayName: string, recommenderList: string[], msg: string, level: Level, ignoreBehavior: IgnoreBehavior, hideNever: boolean, singleRec?: Recommendation): Promise<UserChoice | undefined>;
    protected timelockRecommendationFor(id: string): Promise<void>;
    protected registerSingleMarkdownCommand(): Promise<void>;
    protected getSingleMarkdownCommandId(): string;
    protected runShowMarkdownCommand(id: string): Promise<void>;
    protected markIgnored(id: string, startupOnly: boolean): Promise<void>;
    protected markIgnoredSingleRec(rec: Recommendation): Promise<void>;
    protected fireTelemetrySuccess(target: string, recommenderList: string[], choice: string): Promise<void>;
}
//# sourceMappingURL=recommendationServiceImpl.d.ts.map