"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SegmentInitializer = void 0;
const logger_1 = require("./logger");
const analytics_node_1 = __importDefault(require("analytics-node"));
const extensions_1 = require("./extensions");
const IS_DEBUG = startedInDebugMode();
let DEFAULT_SEGMENT_KEY;
var SegmentInitializer;
(function (SegmentInitializer) {
    function initialize(clientPackageJson) {
        let segmentWriteKey = getSegmentKey(clientPackageJson);
        if (!segmentWriteKey) {
            //Using the default key
            if (!DEFAULT_SEGMENT_KEY) {
                const defaultPackageJson = require('../../package.json');
                DEFAULT_SEGMENT_KEY = getSegmentKey(defaultPackageJson);
            }
            segmentWriteKey = DEFAULT_SEGMENT_KEY;
        }
        if (segmentWriteKey) {
            /*
              flushAt: Number ->  The number of messages to enqueue before flushing.
              flushInterval: Number ->    The number of milliseconds to wait before flushing the queue automatically.
              ref: https://segment.com/docs/connections/sources/catalog/libraries/server/node/#configuration
              */
            let analytics = new analytics_node_1.default(segmentWriteKey, {
                flushAt: 10,
                flushInterval: 10000,
            });
            return analytics;
        }
        else {
            logger_1.Logger.log('Missing segmentWriteKey from package.json OR package.json in vscode-commons');
            return undefined;
        }
    }
    SegmentInitializer.initialize = initialize;
})(SegmentInitializer = exports.SegmentInitializer || (exports.SegmentInitializer = {}));
function startedInDebugMode() {
    const args = process.execArgv;
    return hasDebugFlag(args);
}
// exported for tests
function hasDebugFlag(args) {
    return args
        // See https://nodejs.org/en/docs/guides/debugging-getting-started/
        && args.some(arg => /^--inspect/.test(arg) || /^--debug/.test(arg));
}
function getSegmentKey(packageJson) {
    const extensionId = (0, extensions_1.getExtensionId)(packageJson);
    let keyKey = 'segmentWriteKeyDebug';
    try {
        let clientSegmentKey = undefined;
        if (IS_DEBUG) {
            clientSegmentKey = packageJson[keyKey];
        }
        else {
            keyKey = 'segmentWriteKey';
            clientSegmentKey = packageJson[keyKey];
        }
        if (clientSegmentKey) {
            logger_1.Logger.log(`'${extensionId}' ${keyKey} : ${clientSegmentKey}`);
        }
        return clientSegmentKey;
    }
    catch (error) {
        logger_1.Logger.log(`Unable to get '${extensionId}' ${keyKey}: ${error}`);
    }
    return undefined;
}
//# sourceMappingURL=segmentInitializer.js.map