import { Wizard } from './Wizard';
import { IWizard } from './IWizard';
import { IWizardPage } from './IWizardPage';
import * as vscode from 'vscode';
import { MesssageMapping, Template, HandlerResponse } from "./pageImpl";
import { WebviewWizardPage } from './WebviewWizardPage';
import { IWizardWorkflowManager } from './IWizardWorkflowManager';
import { IWizardPageRenderer } from './IWizardPageRenderer';
export declare class WebviewWizard extends Wizard implements IWizard {
    context: vscode.ExtensionContext;
    readyMapping: MesssageMapping;
    backPressedMapping: MesssageMapping;
    nextPressedMapping: MesssageMapping;
    finishPressedMapping: MesssageMapping;
    openFileDialogMapping: MesssageMapping;
    validateMapping: MesssageMapping;
    currentPage: IWizardPage | null;
    previousParameters: any;
    id: string;
    type: string;
    title: string;
    imageString: string | undefined;
    description: string | undefined;
    definition: WizardDefinition;
    initialData: Map<string, string>;
    isDirty: boolean;
    constructor(id: string, type: string, context2: vscode.ExtensionContext, definition: WizardDefinition, initialData: Map<string, string>);
    private createValidationTemplates;
    canFinishInternal(parameters: any): boolean;
    getActualPreviousPage(data: any): IWizardPage | null;
    getActualNextPage(data: any): IWizardPage | null;
    backImpl(parameters: any): HandlerResponse;
    nextImpl(parameters: any): HandlerResponse;
    finishImpl(data: any): Promise<HandlerResponse>;
    openFileDialogMappingImpl(data: any): Promise<HandlerResponse>;
    updateWizardPanelTitle(): void;
    close(): void;
    getShowCurrentPageTemplates(parameters: any): Template[];
    getDefaultWizardHeader(): string;
    getDefaultWizardPageHeader(): string;
    generateValidationTemplates(parameters: any): Template[];
    validateAndUpdatePageComplete(parameters: any): void;
    getCurrentPageName(): string | undefined;
    getCurrentPageId(): string;
    getCurrentPageDescription(): string | undefined;
    getCurrentPageContent(parameters: any): string;
    getCurrentPage(): WebviewWizardPage | null;
    open(): void;
    addPages(): void;
    getUpdatedWizardControls(parameters: any, validate: boolean): string;
    showDirtyState(def: WizardDefinition): boolean;
}
export declare function createButton(id: string | undefined, onclick: string | undefined, enabled: boolean, text: string): string;
export declare type WizardPageValidator = (parameters: any, previousParameters?: any) => ValidatorResponse;
export declare type WizardPageFieldOptionProvider = (parameters?: any) => string[];
export interface WizardPageFieldOptionLabelProvider {
    getItems(parameters?: any): any;
    getValueItem?(item: any): string;
    getLabelItem(item: any): string;
}
export declare const UPDATE_TITLE: string;
export declare enum SEVERITY {
    OTHER = 1,
    INFO = 2,
    WARN = 3,
    ERROR = 4
}
export declare enum BUTTONS {
    PREVIOUS = 1,
    NEXT = 2,
    FINISH = 3
}
export interface ButtonItem {
    id: BUTTONS;
    label: string;
}
export interface ValidatorResponseItem {
    template: Template;
    severity: SEVERITY;
}
export interface ValidatorResponse {
    items: ValidatorResponseItem[];
    fieldRefresh?: Map<string, FieldDefinitionState>;
}
export interface WizardDefinition {
    title: string;
    description?: string;
    bannerIconString?: string;
    hideWizardHeader?: boolean;
    pages: WizardPageDefinition[];
    workflowManager?: IWizardWorkflowManager;
    renderer?: IWizardPageRenderer;
    buttons?: ButtonItem[];
    showDirtyState?: boolean;
}
export interface WizardPageDefinition {
    id: string;
    title?: string;
    description?: string;
    hideWizardPageHeader?: boolean;
    fields: (WizardPageFieldDefinition | WizardPageSectionDefinition)[];
    validator?: WizardPageValidator;
}
export interface WizardPageSectionDefinition {
    id: string;
    label: string;
    description?: string;
    childFields: WizardPageFieldDefinition[];
}
export declare function isWizardPageSectionDefinition(def: WizardPageFieldDefinition | WizardPageSectionDefinition): def is WizardPageSectionDefinition;
export declare function isWizardPageFieldDefinition(def: WizardPageFieldDefinition | WizardPageSectionDefinition): def is WizardPageFieldDefinition;
export interface WizardPageFieldDefinition {
    id: string;
    type: string;
    label: string;
    description?: string;
    initialValue?: string;
    placeholder?: string;
    focus?: boolean;
    executableJavascriptOnModification?: string;
    properties?: any;
    optionProvider?: WizardPageFieldOptionProvider | WizardPageFieldOptionLabelProvider;
    dialogOptions?: vscode.OpenDialogOptions;
    initialState?: FieldDefinitionState;
}
export interface FieldDefinitionState {
    enabled?: boolean;
    visible?: boolean;
}
//# sourceMappingURL=WebviewWizard.d.ts.map