"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWizardPageFieldDefinition = exports.isWizardPageSectionDefinition = exports.BUTTONS = exports.SEVERITY = exports.UPDATE_TITLE = exports.createButton = exports.WebviewWizard = void 0;
const Wizard_1 = require("./Wizard");
const vscode = __importStar(require("vscode"));
const pageImpl_1 = require("./pageImpl");
const WebviewWizardPage_1 = require("./WebviewWizardPage");
class WebviewWizard extends Wizard_1.Wizard {
    constructor(id, type, context2, definition, initialData) {
        super();
        this.currentPage = null;
        this.previousParameters = {};
        this.isDirty = false;
        this.initialData = initialData;
        this.definition = definition;
        this.id = id;
        this.imageString = definition.bannerIconString;
        this.type = type;
        this.title = definition.title;
        this.description = definition.description;
        this.context = context2;
        this.readyMapping = {
            command: "ready",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                var _a;
                // Get templates for the first page content and validation result
                const templates = this.getShowCurrentPageTemplates(parameters);
                templates.push(...this.createValidationTemplates(parameters));
                return {
                    returnObject: {
                        focusedField: (_a = this.currentPage) === null || _a === void 0 ? void 0 : _a.getFocusedField()
                    },
                    templates: templates
                };
            })
        };
        this.nextPressedMapping = {
            command: "nextPressed",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                return this.nextImpl(parameters);
            })
        };
        this.backPressedMapping = {
            command: "backPressed",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                return this.backImpl(parameters);
            })
        };
        this.finishPressedMapping = {
            command: "finishPressed",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                return this.finishImpl(parameters);
            })
        };
        this.openFileDialogMapping = {
            command: "openFileDialog",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                return this.openFileDialogMappingImpl(parameters);
            })
        };
        this.validateMapping = {
            command: "validate",
            handler: (parameters) => __awaiter(this, void 0, void 0, function* () {
                if (!this.isDirty) {
                    this.isDirty = true;
                    this.updateWizardPanelTitle();
                }
                return {
                    returnObject: {},
                    templates: this.createValidationTemplates(parameters)
                };
            })
        };
    }
    createValidationTemplates(parameters) {
        const validations = this.generateValidationTemplates(parameters);
        validations.push({ id: "wizardControls", content: this.getUpdatedWizardControls(parameters, false) });
        this.previousParameters = parameters;
        return validations;
    }
    canFinishInternal(parameters) {
        var ret;
        if (this.definition.workflowManager === undefined || this.definition.workflowManager.canFinish === undefined) {
            ret = super.canFinish();
        }
        else {
            ret = this.definition.workflowManager.canFinish(this, parameters !== undefined ? parameters : {});
        }
        return ret;
    }
    getActualPreviousPage(data) {
        let previousPage = null;
        if (this.currentPage === null) {
            previousPage = this.getStartingPage();
        }
        else if (this.definition.workflowManager !== undefined
            && this.definition.workflowManager.getPreviousPage) {
            previousPage = this.definition.workflowManager.getPreviousPage(this.currentPage, data === undefined ? {} : data);
        }
        else {
            previousPage = this.getPreviousPage(this.currentPage);
        }
        return previousPage;
    }
    getActualNextPage(data) {
        let nextPage = null;
        if (this.currentPage === null) {
            nextPage = this.getStartingPage();
        }
        else if (this.definition.workflowManager !== undefined
            && this.definition.workflowManager.getNextPage) {
            nextPage = this.definition.workflowManager.getNextPage(this.currentPage, data === undefined ? {} : data);
        }
        else {
            nextPage = this.getNextPage(this.currentPage);
        }
        return nextPage;
    }
    backImpl(parameters) {
        var _a;
        this.currentPage = this.getActualPreviousPage(parameters);
        // Get templates for the previous page content and validation result
        const templates = this.getShowCurrentPageTemplates(parameters);
        templates.push(...this.createValidationTemplates(parameters));
        return {
            returnObject: {
                focusedField: (_a = this.currentPage) === null || _a === void 0 ? void 0 : _a.getFocusedField()
            },
            templates: templates
        };
    }
    nextImpl(parameters) {
        var _a;
        let nextPage = this.getActualNextPage(parameters);
        this.currentPage = nextPage;
        // Get templates for the next page content and validation result
        const templates = this.getShowCurrentPageTemplates(parameters);
        templates.push(...this.createValidationTemplates(parameters));
        return {
            returnObject: {
                focusedField: (_a = this.currentPage) === null || _a === void 0 ? void 0 : _a.getFocusedField()
            },
            templates: templates
        };
    }
    finishImpl(data) {
        return __awaiter(this, void 0, void 0, function* () {
            let resp = null;
            if (this.definition.workflowManager !== undefined) {
                resp = yield this.definition.workflowManager.performFinish(this, data);
            }
            if (resp == null) {
                this.close();
                return {
                    returnObject: {},
                    templates: []
                };
            }
            else {
                if (resp.close) {
                    this.close();
                }
                if (resp.success) {
                    this.isDirty = false;
                }
                const templatesToReturn = [];
                for (const oneTemplate of resp.templates) {
                    if (oneTemplate.id === exports.UPDATE_TITLE && oneTemplate.content !== undefined) {
                        this.title = oneTemplate.content;
                    }
                    templatesToReturn.push(oneTemplate);
                }
                // Handle title changes
                this.updateWizardPanelTitle();
                return {
                    returnObject: resp.returnObject,
                    templates: templatesToReturn
                };
            }
        });
    }
    openFileDialogMappingImpl(data) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const options = data.options;
            const result = yield vscode.window.showOpenDialog(options);
            return {
                returnObject: {
                    fieldId: data.fieldId,
                    fsPath: result && ((_a = result[0]) === null || _a === void 0 ? void 0 : _a.fsPath)
                }
            };
        });
    }
    updateWizardPanelTitle() {
        const dirty = this.showDirtyState(this.definition);
        pageImpl_1.updatePanelTitle(this.id, this.title + (dirty ? " ●" : ""));
    }
    close() {
        pageImpl_1.disposeWizard(this.id);
    }
    getShowCurrentPageTemplates(parameters) {
        var _a;
        let ret = [];
        if (this.definition.hideWizardHeader === true) {
            ret.push({ id: "wizardHeader", content: "&nbsp;" });
        }
        else {
            ret.push({ id: "wizardHeader", content: this.getDefaultWizardHeader() });
            ret.push({ id: "wizardTitle", content: this.title });
            ret.push({ id: "wizardDescription", content: this.description === undefined ? "" : this.description });
            if (this.imageString !== undefined) {
                ret.push({ id: "wizardBanner", content: this.imageString });
            }
        }
        if (this.getCurrentPage() !== null) {
            let pageDef = (_a = this.getCurrentPage()) === null || _a === void 0 ? void 0 : _a.getPageDefinition();
            if ((pageDef === null || pageDef === void 0 ? void 0 : pageDef.hideWizardPageHeader) === true) {
                ret.push({ id: "wizardPageHeader", content: "&nbsp;" });
            }
            else {
                ret.push({ id: "wizardPageHeader", content: this.getDefaultWizardPageHeader() });
                ret.push({ id: "pageTitle", content: this.getCurrentPageName() });
                ret.push({ id: "pageDescription", content: this.getCurrentPageDescription() === undefined ? "" : this.getCurrentPageDescription() });
            }
        }
        ret.push({ id: "content", content: this.getCurrentPageContent(parameters) });
        ret.push({ id: "wizardControls", content: this.getUpdatedWizardControls(parameters, true) });
        return ret;
    }
    getDefaultWizardHeader() {
        return '<div id="wizardBanner"></div>\n' +
            '<h2 id="wizardTitle" class="section__title section__title--primary"></h2>\n' +
            '<p id="wizardDescription" class="blurb ml-0 mr-0"></p>\n';
    }
    getDefaultWizardPageHeader() {
        return '<h2 id="pageTitle" class="section__title section__title--primary"></h2>\n' +
            '<p id="pageDescription" class="blurb ml-0 mr-0"></p>\n' +
            '<hr />\n';
    }
    generateValidationTemplates(parameters) {
        return this.getCurrentPage() !== null ? this.getCurrentPage().getValidationTemplates(parameters, this.previousParameters) : [];
    }
    validateAndUpdatePageComplete(parameters) {
        this.getCurrentPage().validateAndUpdatePageComplete(parameters, this.previousParameters);
    }
    getCurrentPageName() {
        return (this.currentPage === null ? "" : this.currentPage.getName());
    }
    getCurrentPageId() {
        return (this.currentPage === null ? "" : this.currentPage.getId());
    }
    getCurrentPageDescription() {
        return (this.currentPage === null ? "" : this.currentPage.getDescription());
    }
    getCurrentPageContent(parameters) {
        const page = this.getCurrentPage();
        if (page === null) {
            return "";
        }
        return page.getContentAsHTML(parameters);
    }
    getCurrentPage() {
        const cur = super.getPage(this.getCurrentPageId());
        if (cur instanceof WebviewWizardPage_1.WebviewWizardPage) {
            return cur;
        }
        return null;
    }
    open() {
        super.open();
        this.currentPage = this.getStartingPage();
        pageImpl_1.createOrShowWizard(this.id, this.type, this.title, this.context, [this.readyMapping, this.validateMapping, this.backPressedMapping,
            this.nextPressedMapping, this.finishPressedMapping, this.openFileDialogMapping]);
        // organize initial data
        const fieldsData = new Map();
        for (const page of this.definition.pages) {
            page.fields.forEach(definition => {
                if (isWizardPageSectionDefinition(definition)) {
                    for (const child of definition.childFields) {
                        if (child.initialValue != undefined) {
                            fieldsData.set(child.id, child.initialValue);
                        }
                    }
                }
                else if (isWizardPageFieldDefinition(definition)) {
                    if (definition.initialValue != undefined) {
                        fieldsData.set(definition.id, definition.initialValue);
                    }
                }
            });
        }
        pageImpl_1.sendInitialData(this.id, new Map([...fieldsData, ...this.initialData]));
    }
    addPages() {
        for (let d of this.definition.pages) {
            let page = new WebviewWizardPage_1.WebviewWizardPage(d, this.definition);
            page.setWizard(this);
            this.addPage(page);
        }
    }
    getUpdatedWizardControls(parameters, validate) {
        if (validate) {
            // Don't care about return value here, just want pageComplete to be set
            this.validateAndUpdatePageComplete(parameters);
        }
        let hasPrevious = (this.currentPage !== null &&
            this.getActualPreviousPage(this.currentPage) !== null);
        let hasNext = (this.currentPage !== null && this.currentPage.isPageComplete() &&
            this.getActualNextPage(parameters) !== null);
        let canFinishNow = this.canFinishInternal(parameters);
        let ret = "";
        if (this.definition.buttons) {
            for (let button of this.definition.buttons) {
                if (button.id == BUTTONS.PREVIOUS) {
                    ret = ret + createButton("buttonBack", "backPressed()", hasPrevious, button.label);
                }
                if (button.id == BUTTONS.NEXT) {
                    ret = ret + createButton("buttonNext", "nextPressed()", hasNext, button.label);
                }
                if (button.id == BUTTONS.FINISH) {
                    ret = ret + createButton("buttonFinish", "finishPressed()", canFinishNow, button.label);
                }
            }
        }
        else {
            ret = createButton("buttonBack", "backPressed()", hasPrevious, "Back") +
                createButton("buttonNext", "nextPressed()", hasNext, "Next") +
                createButton("buttonFinish", "finishPressed()", canFinishNow, "Finish");
        }
        return ret;
    }
    showDirtyState(def) {
        return def.showDirtyState !== undefined && def.showDirtyState && this.isDirty;
    }
}
exports.WebviewWizard = WebviewWizard;
function createButton(id, onclick, enabled, text) {
    return `<button type="button"
                  class="vscode-button"
                  ${id ? `id="${id}"` : ""}
                  ${onclick ? `onclick="${onclick}"` : ""}
                  ${enabled ? "" : " disabled"}>${text}</button>
          `;
}
exports.createButton = createButton;
;
exports.UPDATE_TITLE = "vscode-wizard/updateWizardTitle";
var SEVERITY;
(function (SEVERITY) {
    SEVERITY[SEVERITY["OTHER"] = 1] = "OTHER";
    SEVERITY[SEVERITY["INFO"] = 2] = "INFO";
    SEVERITY[SEVERITY["WARN"] = 3] = "WARN";
    SEVERITY[SEVERITY["ERROR"] = 4] = "ERROR";
})(SEVERITY = exports.SEVERITY || (exports.SEVERITY = {}));
var BUTTONS;
(function (BUTTONS) {
    BUTTONS[BUTTONS["PREVIOUS"] = 1] = "PREVIOUS";
    BUTTONS[BUTTONS["NEXT"] = 2] = "NEXT";
    BUTTONS[BUTTONS["FINISH"] = 3] = "FINISH";
})(BUTTONS = exports.BUTTONS || (exports.BUTTONS = {}));
function isWizardPageSectionDefinition(def) {
    return def.childFields !== undefined;
}
exports.isWizardPageSectionDefinition = isWizardPageSectionDefinition;
function isWizardPageFieldDefinition(def) {
    return def.type !== undefined;
}
exports.isWizardPageFieldDefinition = isWizardPageFieldDefinition;
//# sourceMappingURL=WebviewWizard.js.map