"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WizardPage = void 0;
class WizardPage {
    constructor(pageId, pageName, description) {
        this.id = pageId;
        this.name = pageName;
        this.description = description;
        this.wizard = null;
        this.isPageCompleteVar = false;
        this.previousPage = null;
    }
    canFlipToNextPage() {
        return this.isPageComplete() && this.getNextPage() !== null;
    }
    getId() {
        return this.id;
    }
    getName() {
        return this.name;
    }
    getNextPage() {
        if (this.wizard === null) {
            return null;
        }
        return this.wizard.getNextPage(this);
    }
    getPreviousPage() {
        return this.previousPage;
    }
    getWizard() {
        return this.wizard;
    }
    getDescription() {
        return this.description;
    }
    isPageComplete() {
        return this.isPageCompleteVar;
    }
    setPageComplete(val) {
        this.isPageCompleteVar = val;
    }
    setPreviousPage(page) {
        this.previousPage = page;
    }
    setWizard(wizard) {
        this.wizard = wizard;
    }
    setFocusedField(focusedField) {
        this.focusedField = focusedField;
    }
    getFocusedField() {
        return this.focusedField;
    }
}
exports.WizardPage = WizardPage;
//# sourceMappingURL=WizardPage.js.map