import * as vscode from 'vscode';
export declare type MessageHandler = (parameters?: any) => Promise<HandlerResponse>;
export interface Template {
    id: string;
    content?: string;
    contentUrl?: string;
}
export interface MesssageMapping {
    command: string;
    handler: MessageHandler;
    defaultTemplates?: Template[];
    defaultForward?: string;
}
export interface HandlerResponse {
    returnObject: any;
    templates?: Template[];
    forward?: string;
}
export declare const currentPanels: Map<string, vscode.WebviewPanel>;
export declare function sendInitialData(wizardName: string, data: Map<string, string>): void;
export declare function disposeWizard(id: string): void;
export declare function createOrShowWizard(id: string, viewType: string, title: string, context: vscode.ExtensionContext, messageMappings: MesssageMapping[]): void;
export declare function updatePanelTitle(name: string, title: string): void;
export declare function createOrShowWizardWithPaths(id: string, viewType: string, title: string, context: vscode.ExtensionContext, messageMappings: MesssageMapping[], rootPath: string, pagePath: string): void;
//# sourceMappingURL=pageImpl.d.ts.map