"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createOrShowWizardWithPaths = exports.updatePanelTitle = exports.createOrShowWizard = exports.disposeWizard = exports.sendInitialData = exports.currentPanels = void 0;
const vscode = __importStar(require("vscode"));
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const handlebars = __importStar(require("handlebars"));
exports.currentPanels = new Map();
// data should be an object literal
function sendInitialData(wizardName, data) {
    let panel = exports.currentPanels.get(wizardName);
    if (panel) {
        const response = {
            command: `InitializeData`,
        };
        let obj = Array.from(data).reduce((obj, [key, value]) => (Object.assign(obj, { [key]: value }) // Be careful! Maps can have non-String keys; object literals can't.
        ), {});
        response.result = obj;
        panel.webview.postMessage(response);
    }
}
exports.sendInitialData = sendInitialData;
function disposeWizard(id) {
    let panel = exports.currentPanels.get(id);
    if (panel) {
        exports.currentPanels.delete(id);
        panel.dispose();
    }
}
exports.disposeWizard = disposeWizard;
function createOrShowWizard(id, viewType, title, context, messageMappings) {
    const pages = path.join(__dirname, "../", "pages").normalize();
    const html = path.join(pages, "stub.html");
    createOrShowWizardWithPaths(id, viewType, title, context, messageMappings, pages, html);
}
exports.createOrShowWizard = createOrShowWizard;
function updatePanelTitle(name, title) {
    let panel = exports.currentPanels.get(name);
    if (panel) {
        panel.title = title;
    }
}
exports.updatePanelTitle = updatePanelTitle;
function createOrShowWizardWithPaths(id, viewType, title, context, messageMappings, rootPath, pagePath) {
    const rootPathUri = vscode.Uri.file(rootPath);
    let panel = exports.currentPanels.get(id);
    if (panel) {
        panel.reveal();
    }
    else {
        panel = vscode.window.createWebviewPanel(viewType, title, vscode.ViewColumn.One, {
            enableScripts: true,
            retainContextWhenHidden: true,
            localResourceRoots: [
                context.extensionUri,
                rootPathUri
            ],
        });
        const pagesWebviewUri = panel.webview.asWebviewUri(rootPathUri);
        const contents = fs.readFileSync(pagePath, 'utf-8');
        const contentsReplaced = contents.split("{{base}}").join(pagesWebviewUri.toString());
        panel.webview.html = contentsReplaced;
        panel.webview.onDidReceiveMessage(createDispatch(messageMappings, id, rootPath));
        panel.onDidDispose(() => exports.currentPanels.delete(id), undefined, context.subscriptions);
        exports.currentPanels.set(id, panel);
    }
}
exports.createOrShowWizardWithPaths = createOrShowWizardWithPaths;
function createDispatch(messageMappings, currentPanelName, resourceRoot) {
    const handler = (message) => {
        const mapping = messageMappings.find(mapping => mapping.command === message.command);
        if (mapping) {
            const response = {
                command: `${message.command}Response`,
            };
            mapping.handler.call(null, message.parameters).then(result => {
                var _a;
                if (!result) {
                    return;
                }
                const templates = (result.templates === null ? mapping.defaultTemplates : result.templates);
                const forward = (result.forward === null ? mapping.defaultForward : result.forward);
                if (templates) {
                    response.contents = [];
                    templates.forEach(template => {
                        var _a, _b;
                        if (template.content) {
                            (_a = response.contents) === null || _a === void 0 ? void 0 : _a.push({
                                id: template.id,
                                body: handlebars.compile(template.content)(result.returnObject),
                            });
                        }
                        else if (template.contentUrl) {
                            (_b = response.contents) === null || _b === void 0 ? void 0 : _b.push({
                                id: template.id,
                                body: handlebars.compile(fs
                                    .readFileSync(path.join(resourceRoot, template.contentUrl))
                                    .toString())(result),
                            });
                        }
                    });
                }
                else if (forward) {
                    return handler.call(null, {
                        command: forward,
                        parameters: result,
                    });
                }
                else {
                    response.result = result;
                }
                response.focusedField = (_a = result === null || result === void 0 ? void 0 : result.returnObject) === null || _a === void 0 ? void 0 : _a.focusedField;
                const panel = exports.currentPanels.get(currentPanelName);
                if (panel && panel !== undefined) {
                    panel.webview.postMessage(response);
                }
            });
        }
        else {
            vscode.window.showErrorMessage(`Can not find a handler for ${message.command}.`);
        }
    };
    return handler;
}
//# sourceMappingURL=pageImpl.js.map