import { Protocol } from './protocol/generated/protocol';
import { ServerCreation } from './util/serverCreation';
import { Incoming } from './protocol/generated/incoming';
import { Outgoing } from './protocol/generated/outgoing';
import { OutgoingSynchronous } from './util/outgoingsync';
/**
 * Runtime Server Protocol client implementation using JSON RPC
 */
export declare class RSPClient {
    private host;
    private port;
    private socket;
    private connection;
    private emitter;
    private serverUtil;
    private incoming;
    private outgoing;
    private outgoingSync;
    /**
     * Constructs a new RSP client
     * @param host hostname/address to connect to
     * @param port port of the running RSP service
     */
    constructor(host: string, port: number);
    /**
     * Initiates connection to the RSP server
     *
     * @param timeout operation timeout in milliseconds, default 2000 ms
     */
    connect(timeout?: number): Promise<void>;
    onConnectionClosed(listener: (arg: RSPClient) => void): void;
    removeOnConnectionClosed(listener: (arg: RSPClient) => void): void;
    /**
     * Terminates an existing connection
     *
     * @throws {@link rpc.ConnectionError} if connection is not initialized or already disposed
     */
    disconnect(): void;
    /**
     * Terminates the currently running RSP server instance and disconnects itself
     */
    shutdownServer(): void;
    getIncomingHandler(): Incoming;
    getOutgoingHandler(): Outgoing;
    getOutgoingSyncHandler(): OutgoingSynchronous;
    getServerCreation(): ServerCreation;
    /**
     * Returns the capabilities implemented by the client
     */
    getCapabilities(): Protocol.ClientCapabilitiesRequest;
    /**
     * Retrieves all listeners bound to an event
     *
     * @param eventName name of the event to get listeners for
     */
    getListeners(eventName: string): Function[];
}
