/// <reference types="node" />
import { Protocol } from './protocol';
import { MessageConnection } from 'vscode-jsonrpc';
import { EventEmitter } from 'events';
/**
 * Server incoming
 */
export declare class Incoming {
    private connection;
    private emitter;
    /**
     * Constructs a new discovery handler
     * @param connection message connection to the RSP
     * @param emitter event emitter to handle notification events
     */
    constructor(connection: MessageConnection, emitter: EventEmitter);
    /**
     * Subscribes to notifications sent by the server
     */
    private listen;
    onPromptString(listener: (arg: Protocol.StringPrompt) => Promise<string>): void;
    onMessageBox(listener: (arg: Protocol.MessageBoxNotification) => void): void;
    removeOnMessageBox(listener: (arg: Protocol.MessageBoxNotification) => void): void;
    onDiscoveryPathAdded(listener: (arg: Protocol.DiscoveryPath) => void): void;
    removeOnDiscoveryPathAdded(listener: (arg: Protocol.DiscoveryPath) => void): void;
    onDiscoveryPathRemoved(listener: (arg: Protocol.DiscoveryPath) => void): void;
    removeOnDiscoveryPathRemoved(listener: (arg: Protocol.DiscoveryPath) => void): void;
    onServerAdded(listener: (arg: Protocol.ServerHandle) => void): void;
    removeOnServerAdded(listener: (arg: Protocol.ServerHandle) => void): void;
    onServerRemoved(listener: (arg: Protocol.ServerHandle) => void): void;
    removeOnServerRemoved(listener: (arg: Protocol.ServerHandle) => void): void;
    onServerAttributesChanged(listener: (arg: Protocol.ServerHandle) => void): void;
    removeOnServerAttributesChanged(listener: (arg: Protocol.ServerHandle) => void): void;
    onServerStateChanged(listener: (arg: Protocol.ServerState) => void): void;
    removeOnServerStateChanged(listener: (arg: Protocol.ServerState) => void): void;
    onServerProcessCreated(listener: (arg: Protocol.ServerProcess) => void): void;
    removeOnServerProcessCreated(listener: (arg: Protocol.ServerProcess) => void): void;
    onServerProcessTerminated(listener: (arg: Protocol.ServerProcess) => void): void;
    removeOnServerProcessTerminated(listener: (arg: Protocol.ServerProcess) => void): void;
    onServerProcessOutputAppended(listener: (arg: Protocol.ServerProcessOutput) => void): void;
    removeOnServerProcessOutputAppended(listener: (arg: Protocol.ServerProcessOutput) => void): void;
    onJobAdded(listener: (arg: Protocol.JobHandle) => void): void;
    removeOnJobAdded(listener: (arg: Protocol.JobHandle) => void): void;
    onJobRemoved(listener: (arg: Protocol.JobRemoved) => void): void;
    removeOnJobRemoved(listener: (arg: Protocol.JobRemoved) => void): void;
    onJobChanged(listener: (arg: Protocol.JobProgress) => void): void;
    removeOnJobChanged(listener: (arg: Protocol.JobProgress) => void): void;
}
