"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vscode_jsonrpc_1 = require("vscode-jsonrpc");
/**
 * Message types sent between the RSP server and the client
 */
var Messages;
(function (Messages) {
    /**
     * Server methods
     */
    let Server;
    (function (Server) {
        /**
         * Register client capabilities so the server knows what this client can support
         */
        let RegisterClientCapabilitiesRequest;
        (function (RegisterClientCapabilitiesRequest) {
            RegisterClientCapabilitiesRequest.type = new vscode_jsonrpc_1.RequestType('server/registerClientCapabilities');
        })(RegisterClientCapabilitiesRequest = Server.RegisterClientCapabilitiesRequest || (Server.RegisterClientCapabilitiesRequest = {}));
        /**
         * The `server/shutdown` notification is sent by the client to shut down the
         * RSP itself.
         */
        let ShutdownNotification;
        (function (ShutdownNotification) {
            ShutdownNotification.type = new vscode_jsonrpc_1.NotificationType('server/shutdown');
        })(ShutdownNotification = Server.ShutdownNotification || (Server.ShutdownNotification = {}));
        /**
         * The `server/disconnectClient` notification is sent by the client to
         * alert the server that the client should be disconnected
         */
        let DisconnectClientNotification;
        (function (DisconnectClientNotification) {
            DisconnectClientNotification.type = new vscode_jsonrpc_1.NotificationType('server/disconnectClient');
        })(DisconnectClientNotification = Server.DisconnectClientNotification || (Server.DisconnectClientNotification = {}));
        /**
         * The `server/getDiscoveryPaths` request is sent by the client to fetch a list
         * of discovery paths that can be searched.
         *
         * Discovery paths exist in the RSP model as paths suitable to be searched for
         * server runtime installations. Additional paths may be added via the
         * `server/addDiscoveryPath` entry point, or removed via the
         * `server/removeDiscoveryPath` entry point.
         */
        let GetDiscoveryPathsRequest;
        (function (GetDiscoveryPathsRequest) {
            GetDiscoveryPathsRequest.type = new vscode_jsonrpc_1.RequestType('server/getDiscoveryPaths');
        })(GetDiscoveryPathsRequest = Server.GetDiscoveryPathsRequest || (Server.GetDiscoveryPathsRequest = {}));
        /**
         * The `server/findServerBeans` request is sent by the client to fetch a list of
         * server beans for the given path.
         *
         * The RSP model will iterate through a number of `IServerBeanTypeProvider`
         * instances and ask them if they recognize the contents of the folder
         * underlying the discovery path. Any providers that claim to be able to handle
         * the given path will return an object representing the details of this
         * recognized server runtime, its version, etc.
         *
         * The path parameter must be an absolute file-system path, and
         * may not be a relative path.
         */
        let FindServerBeansRequest;
        (function (FindServerBeansRequest) {
            FindServerBeansRequest.type = new vscode_jsonrpc_1.RequestType('server/findServerBeans');
        })(FindServerBeansRequest = Server.FindServerBeansRequest || (Server.FindServerBeansRequest = {}));
        /**
         * The `server/addDiscoveryPath` request is sent by the client to add a new
         * path to search when discovering servers. These paths will be stored in a
         * model, to be queried or searched later by a client.
         *
         * The path parameter must be an absolute file-system path, and
         * may not be a relative path.
         */
        let AddDiscoveryPathRequest;
        (function (AddDiscoveryPathRequest) {
            AddDiscoveryPathRequest.type = new vscode_jsonrpc_1.RequestType('server/addDiscoveryPath');
        })(AddDiscoveryPathRequest = Server.AddDiscoveryPathRequest || (Server.AddDiscoveryPathRequest = {}));
        /**
         * The `server/removeDiscoveryPath` request is sent by the client to remove
         * a path from the model and prevent it from being searched by clients when
         * discovering servers in the future.
         *
         * The path parameter must be an absolute file-system path, and
         * may not be a relative path.
         */
        let RemoveDiscoveryPathRequest;
        (function (RemoveDiscoveryPathRequest) {
            RemoveDiscoveryPathRequest.type = new vscode_jsonrpc_1.RequestType('server/removeDiscoveryPath');
        })(RemoveDiscoveryPathRequest = Server.RemoveDiscoveryPathRequest || (Server.RemoveDiscoveryPathRequest = {}));
        /**
         * The `server/getServerHandles` request is sent by the client to list the
         * server adapters currently configured. A server adapter is configured when a
         * call to `server/createServer` completes without error, or, some may be
         * pre-configured by the server upon installation.
         */
        let GetServerHandlesRequest;
        (function (GetServerHandlesRequest) {
            GetServerHandlesRequest.type = new vscode_jsonrpc_1.RequestType('server/getServerHandles');
        })(GetServerHandlesRequest = Server.GetServerHandlesRequest || (Server.GetServerHandlesRequest = {}));
        /**
         * The `server/getServerTypes` request is sent by the client to list the server
         * types currently supported. The details of how many server types are supported
         * by an RSP, or how they are registered, is implementation-specific.
         */
        let GetServerTypesRequest;
        (function (GetServerTypesRequest) {
            GetServerTypesRequest.type = new vscode_jsonrpc_1.RequestType('server/getServerTypes');
        })(GetServerTypesRequest = Server.GetServerTypesRequest || (Server.GetServerTypesRequest = {}));
        /**
         * The `server/deleteServer` request is sent by the client to delete a
         * server from the model. This server will no longer be able to be started, shut
         * down, or interacted with in any fashion.
         */
        let DeleteServerRequest;
        (function (DeleteServerRequest) {
            DeleteServerRequest.type = new vscode_jsonrpc_1.RequestType('server/deleteServer');
        })(DeleteServerRequest = Server.DeleteServerRequest || (Server.DeleteServerRequest = {}));
        /**
         * The `server/getRequiredAttributes` request is sent by the client to list the
         * required attributes that must be stored on a server object of this type, such
         * as a server-home or other required parameters. This request may return null in
         * case of error.
         */
        let GetRequiredAttributesRequest;
        (function (GetRequiredAttributesRequest) {
            GetRequiredAttributesRequest.type = new vscode_jsonrpc_1.RequestType('server/getRequiredAttributes');
        })(GetRequiredAttributesRequest = Server.GetRequiredAttributesRequest || (Server.GetRequiredAttributesRequest = {}));
        /**
         * The `server/getOptionalAttributes` request is sent by the client to list the
         * optional attributes that can be stored on a server object of this type. This
         * may include things like customizing ports, or custom methods of interacting
         * with various functionality specific to the server type. This request may return
         * null in case of error.
         */
        let GetOptionalAttributesRequest;
        (function (GetOptionalAttributesRequest) {
            GetOptionalAttributesRequest.type = new vscode_jsonrpc_1.RequestType('server/getOptionalAttributes');
        })(GetOptionalAttributesRequest = Server.GetOptionalAttributesRequest || (Server.GetOptionalAttributesRequest = {}));
        /**
         * The `server/createServer` request is sent by the client to create a server in
         * the model using the given attributes (both required and optional. This
         * request may fail if required attributes are missing, any attributes
         * have impossible, unexpected, or invalid values, or any error occurs
         * while attempting to create the server adapter as requested.
         *
         * In the event of failure, the returned `Status` object will
         * detail the cause of error.
         */
        let CreateServerRequest;
        (function (CreateServerRequest) {
            CreateServerRequest.type = new vscode_jsonrpc_1.RequestType('server/createServer');
        })(CreateServerRequest = Server.CreateServerRequest || (Server.CreateServerRequest = {}));
        /**
         * Initiate a request to create a server via workflow
         * @return
         */
        let CreateServerWorkflowRequest;
        (function (CreateServerWorkflowRequest) {
            CreateServerWorkflowRequest.type = new vscode_jsonrpc_1.RequestType('server/createServerWorkflow');
        })(CreateServerWorkflowRequest = Server.CreateServerWorkflowRequest || (Server.CreateServerWorkflowRequest = {}));
        /**
         * The `server/getServerAsJson` request is sent by the client to
         * fetch a string representation of a server adapter.
         * A server handle and a status object are included along with the
         * json representation of the server.
         *
         * In the event of failure, the returned `Status` object will
         * detail the cause of error.
         */
        let GetServerAsJsonRequest;
        (function (GetServerAsJsonRequest) {
            GetServerAsJsonRequest.type = new vscode_jsonrpc_1.RequestType('server/getServerAsJson');
        })(GetServerAsJsonRequest = Server.GetServerAsJsonRequest || (Server.GetServerAsJsonRequest = {}));
        /**
         * The `server/updateServer` request is sent by the client to
         * update a server with new k/v pairs or changed deployment options.
         *
         * In the event of failure, the returned `Status` object will
         * detail the cause of error.
         */
        let UpdateServerRequest;
        (function (UpdateServerRequest) {
            UpdateServerRequest.type = new vscode_jsonrpc_1.RequestType('server/updateServer');
        })(UpdateServerRequest = Server.UpdateServerRequest || (Server.UpdateServerRequest = {}));
        /**
         * The `server/getLaunchModes` request is sent by the client to get
         * a list of launch modes that are applicable to this server type.
         * Some servers can only be started.
         * Others can be started, debugged, profiled, etc.
         *
         * Server types may come up with their own launch modes if desired.
         * This method may return null if an error occurs on the server or
         * the parameter is invalid.
         */
        let GetLaunchModesRequest;
        (function (GetLaunchModesRequest) {
            GetLaunchModesRequest.type = new vscode_jsonrpc_1.RequestType('server/getLaunchModes');
        })(GetLaunchModesRequest = Server.GetLaunchModesRequest || (Server.GetLaunchModesRequest = {}));
        /**
         * The `server/getRequiredLaunchAttributes` request is sent by the client to get
         * any additional attributes required for launch or that can customize launch
         * behavior. Some server types may require references to a specific library, a
         * clear decision about which of several configurations the server should be
         * launched with, or any other required details required to successfully start
         * up the server.
         *
         * This request may return null if the parameter is invalid.
         */
        let GetRequiredLaunchAttributesRequest;
        (function (GetRequiredLaunchAttributesRequest) {
            GetRequiredLaunchAttributesRequest.type = new vscode_jsonrpc_1.RequestType('server/getRequiredLaunchAttributes');
        })(GetRequiredLaunchAttributesRequest = Server.GetRequiredLaunchAttributesRequest || (Server.GetRequiredLaunchAttributesRequest = {}));
        /**
         * The `server/getOptionalLaunchAttributes` request is sent by the client to get
         * any optional attributes which can be used to modify the launch behavior. Some
         * server types may allow overrides to any number of launch flags or settings,
         * but not require these changes in order to function.
         *
         * This request may return null if the parameter is invalid.
         */
        let GetOptionalLaunchAttributesRequest;
        (function (GetOptionalLaunchAttributesRequest) {
            GetOptionalLaunchAttributesRequest.type = new vscode_jsonrpc_1.RequestType('server/getOptionalLaunchAttributes');
        })(GetOptionalLaunchAttributesRequest = Server.GetOptionalLaunchAttributesRequest || (Server.GetOptionalLaunchAttributesRequest = {}));
        /**
         * The `server/getLaunchCommand` request is sent by the client to the server to
         * get the command which can be used to launch the server.
         *
         * This entry point is most often used if an editor or IDE wishes to start
         * the server by itself, but does not know the servertype-specific command
         * that must be launched. The parameter will include a mode the server
         * should run in (run, debug, etc), as well as any custom attributes
         * that may have an effect on the generation of the launch command.
         *
         * This request may return null if the parameter is invalid.
         */
        let GetLaunchCommandRequest;
        (function (GetLaunchCommandRequest) {
            GetLaunchCommandRequest.type = new vscode_jsonrpc_1.RequestType('server/getLaunchCommand');
        })(GetLaunchCommandRequest = Server.GetLaunchCommandRequest || (Server.GetLaunchCommandRequest = {}));
        /**
         * The `server/serverStartingByClient` request is sent by the client to the
         * server to inform the server that the client itself has launched the server
         * instead of asking the RSP to do so.
         *
         * The parameters include both the request used to get the launch command, and a
         * boolean as to whether the server should initiate the 'state-polling'
         * mechanism to inform the client when the selected server has completed its
         * startup.
         *
         * If the `polling` boolean is false, the client is expected to also alert
         * the RSP when the launched server has completed its startup via the
         * `server/serverStartedByClient` request.
         */
        let ServerStartingByClientRequest;
        (function (ServerStartingByClientRequest) {
            ServerStartingByClientRequest.type = new vscode_jsonrpc_1.RequestType('server/serverStartingByClient');
        })(ServerStartingByClientRequest = Server.ServerStartingByClientRequest || (Server.ServerStartingByClientRequest = {}));
        /**
         * The `server/serverStartedByClient` request is sent by the client to the
         * server to inform the server that the client itself has launched the server
         * instead of asking the RSP to do so, AND that the startup has completed.
         */
        let ServerStartedByClientRequest;
        (function (ServerStartedByClientRequest) {
            ServerStartedByClientRequest.type = new vscode_jsonrpc_1.RequestType('server/serverStartedByClient');
        })(ServerStartedByClientRequest = Server.ServerStartedByClientRequest || (Server.ServerStartedByClientRequest = {}));
        /**
         * Get the state of the current server
         */
        let GetServerStateRequest;
        (function (GetServerStateRequest) {
            GetServerStateRequest.type = new vscode_jsonrpc_1.RequestType('server/getServerState');
        })(GetServerStateRequest = Server.GetServerStateRequest || (Server.GetServerStateRequest = {}));
        /**
         * The `server/startServerAsync` request is sent by the client to the server to
         * start an existing server in the model.
         *
         * This request will cause the server to launch the server and
         * keep organized the spawned processes, their I/O streams,
         * and any events that must be propagated to the client.
         */
        let StartServerAsyncRequest;
        (function (StartServerAsyncRequest) {
            StartServerAsyncRequest.type = new vscode_jsonrpc_1.RequestType('server/startServerAsync');
        })(StartServerAsyncRequest = Server.StartServerAsyncRequest || (Server.StartServerAsyncRequest = {}));
        /**
         * The `server/stopServerAsync` request is sent by the client to the server to
         * stop an existing server in the model.
         */
        let StopServerAsyncRequest;
        (function (StopServerAsyncRequest) {
            StopServerAsyncRequest.type = new vscode_jsonrpc_1.RequestType('server/stopServerAsync');
        })(StopServerAsyncRequest = Server.StopServerAsyncRequest || (Server.StopServerAsyncRequest = {}));
        /**
         * The `server/getDeployables` request is sent by the client to the server to
         * get a list of all deployables
         */
        let GetDeployablesRequest;
        (function (GetDeployablesRequest) {
            GetDeployablesRequest.type = new vscode_jsonrpc_1.RequestType('server/getDeployables');
        })(GetDeployablesRequest = Server.GetDeployablesRequest || (Server.GetDeployablesRequest = {}));
        /**
         * The `server/listDeploymentOptions` request is sent by the client to list the
         * possible attributes that may be used when adding a new deployment.
         * This can be any set of custom server-defined settings, or standard options,
         * for example, an output name for an archive, whether to zip folders, etc.
         * This request may return null in case of error.
         *
         * @param serverHandle
         */
        let ListDeploymentOptionsRequest;
        (function (ListDeploymentOptionsRequest) {
            ListDeploymentOptionsRequest.type = new vscode_jsonrpc_1.RequestType('server/listDeploymentOptions');
        })(ListDeploymentOptionsRequest = Server.ListDeploymentOptionsRequest || (Server.ListDeploymentOptionsRequest = {}));
        /**
         * The `server/addDeployable` request is sent by the client to the server
         * to add a deployable reference to a server's list of deployable items
         * so that it can be published thereafter.
         *
         * @param handle
         * @param reference
         * @return
         */
        let AddDeployableRequest;
        (function (AddDeployableRequest) {
            AddDeployableRequest.type = new vscode_jsonrpc_1.RequestType('server/addDeployable');
        })(AddDeployableRequest = Server.AddDeployableRequest || (Server.AddDeployableRequest = {}));
        /**
         * The `server/removeDeployable` request is sent by the client to the server
         * to remove a deployable reference from a server's list of deployable items
         * so that it can be unpublished thereafter.
         *
         * @param handle
         * @param reference
         * @return
         */
        let RemoveDeployableRequest;
        (function (RemoveDeployableRequest) {
            RemoveDeployableRequest.type = new vscode_jsonrpc_1.RequestType('server/removeDeployable');
        })(RemoveDeployableRequest = Server.RemoveDeployableRequest || (Server.RemoveDeployableRequest = {}));
        /**
         * The `server/publish` request is sent by the client to the server
         * to instruct the server adapter to publish any changes to the backing runtime.
         *
         * @param request
         * @return
         */
        let PublishRequest;
        (function (PublishRequest) {
            PublishRequest.type = new vscode_jsonrpc_1.RequestType('server/publish');
        })(PublishRequest = Server.PublishRequest || (Server.PublishRequest = {}));
        /**
         * The `server/publishAsync` request is sent by the client to the server
         * to instruct the server adapter to publish any changes to the backing runtime
         * in an asynchronous fashion, ie, guaranteed to respond quickly.
         *
         * @param request
         * @return
         */
        let PublishAsyncRequest;
        (function (PublishAsyncRequest) {
            PublishAsyncRequest.type = new vscode_jsonrpc_1.RequestType('server/publishAsync');
        })(PublishAsyncRequest = Server.PublishAsyncRequest || (Server.PublishAsyncRequest = {}));
        /**
         * Get a list of all downloadable runtimes
         * @return
         */
        let ListDownloadableRuntimesRequest;
        (function (ListDownloadableRuntimesRequest) {
            ListDownloadableRuntimesRequest.type = new vscode_jsonrpc_1.RequestType('server/listDownloadableRuntimes');
        })(ListDownloadableRuntimesRequest = Server.ListDownloadableRuntimesRequest || (Server.ListDownloadableRuntimesRequest = {}));
        /**
         * Initiate a request to download a runtime
         * @return
         */
        let DownloadRuntimeRequest;
        (function (DownloadRuntimeRequest) {
            DownloadRuntimeRequest.type = new vscode_jsonrpc_1.RequestType('server/downloadRuntime');
        })(DownloadRuntimeRequest = Server.DownloadRuntimeRequest || (Server.DownloadRuntimeRequest = {}));
        /**
         * Get a list of server action items
         * @return
         */
        let ListServerActionsRequest;
        (function (ListServerActionsRequest) {
            ListServerActionsRequest.type = new vscode_jsonrpc_1.RequestType('server/listServerActions');
        })(ListServerActionsRequest = Server.ListServerActionsRequest || (Server.ListServerActionsRequest = {}));
        /**
         * Initiate a request to download a runtime
         * @return
         */
        let ExecuteServerActionRequest;
        (function (ExecuteServerActionRequest) {
            ExecuteServerActionRequest.type = new vscode_jsonrpc_1.RequestType('server/executeServerAction');
        })(ExecuteServerActionRequest = Server.ExecuteServerActionRequest || (Server.ExecuteServerActionRequest = {}));
        /**
         * Initiate a request to get a view of the current job model
         * @return
         */
        let GetJobsRequest;
        (function (GetJobsRequest) {
            GetJobsRequest.type = new vscode_jsonrpc_1.RequestType('server/getJobs');
        })(GetJobsRequest = Server.GetJobsRequest || (Server.GetJobsRequest = {}));
        /**
         * Initiate a request to cancel a given job
         * @param job The handle to the given job
         * @return
         */
        let CancelJobRequest;
        (function (CancelJobRequest) {
            CancelJobRequest.type = new vscode_jsonrpc_1.RequestType('server/cancelJob');
        })(CancelJobRequest = Server.CancelJobRequest || (Server.CancelJobRequest = {}));
    })(Server = Messages.Server || (Messages.Server = {}));
    /**
     * Client methods
     */
    let Client;
    (function (Client) {
        /**
         * Prompt the user for some feature
         */
        let PromptStringRequest;
        (function (PromptStringRequest) {
            PromptStringRequest.type = new vscode_jsonrpc_1.RequestType('client/promptString');
        })(PromptStringRequest = Client.PromptStringRequest || (Client.PromptStringRequest = {}));
        /**
         * The `client/messageBox` notification is sent by the server to all
         * clients or specific clients to inform the users of anything that may be of interest.
         */
        let MessageBoxNotification;
        (function (MessageBoxNotification) {
            MessageBoxNotification.type = new vscode_jsonrpc_1.NotificationType('client/messageBox');
        })(MessageBoxNotification = Client.MessageBoxNotification || (Client.MessageBoxNotification = {}));
        /**
         * The `client/discoveryPathAdded` notification is sent by the server to all
         * clients in response to the `server/addDiscoveryPath` notification.
         *
         * This call indicates that a discovery path has been added to the RSP model
         * which keeps track of filesystem paths that may be searched for server
         * runtimes.
         */
        let DiscoveryPathAddedNotification;
        (function (DiscoveryPathAddedNotification) {
            DiscoveryPathAddedNotification.type = new vscode_jsonrpc_1.NotificationType('client/discoveryPathAdded');
        })(DiscoveryPathAddedNotification = Client.DiscoveryPathAddedNotification || (Client.DiscoveryPathAddedNotification = {}));
        /**
         * The `client/discoveryPathRemoved` notification is sent by the server to all
         * clients in response to the `server/removeDiscoveryPath` notification.
         *
         * This call indicates that a discovery path has been removed from the RSP model
         * which keeps track of filesystem paths that may be searched for server
         * runtimes.
         */
        let DiscoveryPathRemovedNotification;
        (function (DiscoveryPathRemovedNotification) {
            DiscoveryPathRemovedNotification.type = new vscode_jsonrpc_1.NotificationType('client/discoveryPathRemoved');
        })(DiscoveryPathRemovedNotification = Client.DiscoveryPathRemovedNotification || (Client.DiscoveryPathRemovedNotification = {}));
        /**
         * The `client/serverAdded` notification is sent by the server to all clients in
         * a response to the `server/createServer` notification.
         *
         * This notification indicates that a new server adapter has been created in the
         * RSP model of existing servers. As mentioned above, this was most likely in
         * response to a server/createServer notification, but is not strictly limited
         * to this entrypoint.
         */
        let ServerAddedNotification;
        (function (ServerAddedNotification) {
            ServerAddedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverAdded');
        })(ServerAddedNotification = Client.ServerAddedNotification || (Client.ServerAddedNotification = {}));
        /**
         * The `client/serverRemoved` notification is sent by the server to all clients
         * in response to the `server/deleteServer` notification.
         *
         * This notification indicates that a server adapter has been removed from the
         * RSP model of existing servers. As mentioned above, this was most likely in
         * response to a server/deleteServer notification, but is not strictly limited
         * to this entrypoint.
         */
        let ServerRemovedNotification;
        (function (ServerRemovedNotification) {
            ServerRemovedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverRemoved');
        })(ServerRemovedNotification = Client.ServerRemovedNotification || (Client.ServerRemovedNotification = {}));
        /**
         * The `client/serverRemoved` notification is sent by the server to all clients
         * when any server has had one of its attributes changed.
         */
        let ServerAttributesChangedNotification;
        (function (ServerAttributesChangedNotification) {
            ServerAttributesChangedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverAttributesChanged');
        })(ServerAttributesChangedNotification = Client.ServerAttributesChangedNotification || (Client.ServerAttributesChangedNotification = {}));
        /**
         * The `client/serverStateChanged` notification is sent by the server to all
         * clients when any server has had its state change.
         *
         * Possible values include:
         *   `0` representing an unknown state
         *   `1` representing starting
         *   `2` representing started
         *   `3` representing stopping
         *   `4` representing stopped
         *
         */
        let ServerStateChangedNotification;
        (function (ServerStateChangedNotification) {
            ServerStateChangedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverStateChanged');
        })(ServerStateChangedNotification = Client.ServerStateChangedNotification || (Client.ServerStateChangedNotification = {}));
        /**
         * The `client/serverProcessCreated` notification is sent
         * by the server to all clients when any server
         * has launched a new process which can be monitored.
         *
         * This notification is most often sent in response to a call to
         * `server/startServerAsync` which will typically launch a process
         * to run the server in question.
         */
        let ServerProcessCreatedNotification;
        (function (ServerProcessCreatedNotification) {
            ServerProcessCreatedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverProcessCreated');
        })(ServerProcessCreatedNotification = Client.ServerProcessCreatedNotification || (Client.ServerProcessCreatedNotification = {}));
        /**
         * The `client/serverProcessTerminated` notification is sent by
         * the server to all clients when any process associated with a
         * server has been terminated.
         *
         * This notification is most often sent as a result of a call to
         * `server/stopServerAsync`, which  should shut down a given server
         * and cause all of that server's processes to terminate after some time.
         */
        let ServerProcessTerminatedNotification;
        (function (ServerProcessTerminatedNotification) {
            ServerProcessTerminatedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverProcessTerminated');
        })(ServerProcessTerminatedNotification = Client.ServerProcessTerminatedNotification || (Client.ServerProcessTerminatedNotification = {}));
        /**
         * The `client/serverProcessOutputAppended` notification is sent by
         * the server to all clients when any process associated with a
         * server generated output on any of its output streams.
         *
         * This notification may be sent as a result of anything that
         * causes a given server process to emit output, such as a change in
         * configuration, a deployment, an error, normal logging,
         * or any other number of possibilities.
         */
        let ServerProcessOutputAppendedNotification;
        (function (ServerProcessOutputAppendedNotification) {
            ServerProcessOutputAppendedNotification.type = new vscode_jsonrpc_1.NotificationType('client/serverProcessOutputAppended');
        })(ServerProcessOutputAppendedNotification = Client.ServerProcessOutputAppendedNotification || (Client.ServerProcessOutputAppendedNotification = {}));
        /**
         * The `client/jobAdded` notification is sent by
         * the server to all clients when any long-running task
         * has been scheduled on the server.
         *
         * This notification may be sent by any procedure that an extension
         * to the RSP may decide requires a long-running task to be registered.
         */
        let JobAddedNotification;
        (function (JobAddedNotification) {
            JobAddedNotification.type = new vscode_jsonrpc_1.NotificationType('client/jobAdded');
        })(JobAddedNotification = Client.JobAddedNotification || (Client.JobAddedNotification = {}));
        /**
         * The `client/jobRemoved` notification is sent by
         * the server to all clients when any long-running task
         * has been completed, canceled, or errors.
         *
         * This notification may be sent by the server when any of its long-running
         * tasks have been completed;
         */
        let JobRemovedNotification;
        (function (JobRemovedNotification) {
            JobRemovedNotification.type = new vscode_jsonrpc_1.NotificationType('client/jobRemoved');
        })(JobRemovedNotification = Client.JobRemovedNotification || (Client.JobRemovedNotification = {}));
        /**
         * The `client/jobChanged` notification is sent by the server to all clients
         * when any long-running task has its progress updated.
         */
        let JobChangedNotification;
        (function (JobChangedNotification) {
            JobChangedNotification.type = new vscode_jsonrpc_1.NotificationType('client/jobChanged');
        })(JobChangedNotification = Client.JobChangedNotification || (Client.JobChangedNotification = {}));
    })(Client = Messages.Client || (Messages.Client = {}));
})(Messages = exports.Messages || (exports.Messages = {}));
//# sourceMappingURL=messages.js.map