"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const messages_1 = require("./messages");
const common_1 = require("../../util/common");
/**
 * Server Outgoing
 */
class Outgoing {
    /**
    * Constructs a new discovery handler
    * @param connection message connection to the RSP
    */
    constructor(connection) {
        this.connection = connection;
    }
    registerClientCapabilities(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.RegisterClientCapabilitiesRequest.type, param, timeout, ErrorMessages.REGISTERCLIENTCAPABILITIES_TIMEOUT);
    }
    shutdown(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleNotification(this.connection, messages_1.Messages.Server.ShutdownNotification.type, null);
    }
    disconnectClient(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleNotification(this.connection, messages_1.Messages.Server.DisconnectClientNotification.type, null);
    }
    getDiscoveryPaths(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetDiscoveryPathsRequest.type, null, timeout, ErrorMessages.GETDISCOVERYPATHS_TIMEOUT);
    }
    findServerBeans(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.FindServerBeansRequest.type, param, timeout, ErrorMessages.FINDSERVERBEANS_TIMEOUT);
    }
    addDiscoveryPath(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.AddDiscoveryPathRequest.type, param, timeout, ErrorMessages.ADDDISCOVERYPATH_TIMEOUT);
    }
    removeDiscoveryPath(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.RemoveDiscoveryPathRequest.type, param, timeout, ErrorMessages.REMOVEDISCOVERYPATH_TIMEOUT);
    }
    getServerHandles(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetServerHandlesRequest.type, null, timeout, ErrorMessages.GETSERVERHANDLES_TIMEOUT);
    }
    getServerTypes(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetServerTypesRequest.type, null, timeout, ErrorMessages.GETSERVERTYPES_TIMEOUT);
    }
    deleteServer(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.DeleteServerRequest.type, param, timeout, ErrorMessages.DELETESERVER_TIMEOUT);
    }
    getRequiredAttributes(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetRequiredAttributesRequest.type, param, timeout, ErrorMessages.GETREQUIREDATTRIBUTES_TIMEOUT);
    }
    getOptionalAttributes(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetOptionalAttributesRequest.type, param, timeout, ErrorMessages.GETOPTIONALATTRIBUTES_TIMEOUT);
    }
    createServer(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.CreateServerRequest.type, param, timeout, ErrorMessages.CREATESERVER_TIMEOUT);
    }
    createServerWorkflow(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.CreateServerWorkflowRequest.type, param, timeout, ErrorMessages.CREATESERVERWORKFLOW_TIMEOUT);
    }
    getServerAsJson(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetServerAsJsonRequest.type, param, timeout, ErrorMessages.GETSERVERASJSON_TIMEOUT);
    }
    updateServer(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.UpdateServerRequest.type, param, timeout, ErrorMessages.UPDATESERVER_TIMEOUT);
    }
    getLaunchModes(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetLaunchModesRequest.type, param, timeout, ErrorMessages.GETLAUNCHMODES_TIMEOUT);
    }
    getRequiredLaunchAttributes(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetRequiredLaunchAttributesRequest.type, param, timeout, ErrorMessages.GETREQUIREDLAUNCHATTRIBUTES_TIMEOUT);
    }
    getOptionalLaunchAttributes(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetOptionalLaunchAttributesRequest.type, param, timeout, ErrorMessages.GETOPTIONALLAUNCHATTRIBUTES_TIMEOUT);
    }
    getLaunchCommand(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetLaunchCommandRequest.type, param, timeout, ErrorMessages.GETLAUNCHCOMMAND_TIMEOUT);
    }
    serverStartingByClient(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ServerStartingByClientRequest.type, param, timeout, ErrorMessages.SERVERSTARTINGBYCLIENT_TIMEOUT);
    }
    serverStartedByClient(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ServerStartedByClientRequest.type, param, timeout, ErrorMessages.SERVERSTARTEDBYCLIENT_TIMEOUT);
    }
    getServerState(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetServerStateRequest.type, param, timeout, ErrorMessages.GETSERVERSTATE_TIMEOUT);
    }
    startServerAsync(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.StartServerAsyncRequest.type, param, timeout, ErrorMessages.STARTSERVERASYNC_TIMEOUT);
    }
    stopServerAsync(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.StopServerAsyncRequest.type, param, timeout, ErrorMessages.STOPSERVERASYNC_TIMEOUT);
    }
    getDeployables(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetDeployablesRequest.type, param, timeout, ErrorMessages.GETDEPLOYABLES_TIMEOUT);
    }
    listDeploymentOptions(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ListDeploymentOptionsRequest.type, param, timeout, ErrorMessages.LISTDEPLOYMENTOPTIONS_TIMEOUT);
    }
    addDeployable(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.AddDeployableRequest.type, param, timeout, ErrorMessages.ADDDEPLOYABLE_TIMEOUT);
    }
    removeDeployable(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.RemoveDeployableRequest.type, param, timeout, ErrorMessages.REMOVEDEPLOYABLE_TIMEOUT);
    }
    publish(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.PublishRequest.type, param, timeout, ErrorMessages.PUBLISH_TIMEOUT);
    }
    publishAsync(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.PublishAsyncRequest.type, param, timeout, ErrorMessages.PUBLISHASYNC_TIMEOUT);
    }
    listDownloadableRuntimes(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ListDownloadableRuntimesRequest.type, null, timeout, ErrorMessages.LISTDOWNLOADABLERUNTIMES_TIMEOUT);
    }
    downloadRuntime(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.DownloadRuntimeRequest.type, param, timeout, ErrorMessages.DOWNLOADRUNTIME_TIMEOUT);
    }
    listServerActions(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ListServerActionsRequest.type, param, timeout, ErrorMessages.LISTSERVERACTIONS_TIMEOUT);
    }
    executeServerAction(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.ExecuteServerActionRequest.type, param, timeout, ErrorMessages.EXECUTESERVERACTION_TIMEOUT);
    }
    getJobs(timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.GetJobsRequest.type, null, timeout, ErrorMessages.GETJOBS_TIMEOUT);
    }
    cancelJob(param, timeout = common_1.Common.DEFAULT_TIMEOUT) {
        return common_1.Common.sendSimpleRequest(this.connection, messages_1.Messages.Server.CancelJobRequest.type, param, timeout, ErrorMessages.CANCELJOB_TIMEOUT);
    }
}
exports.Outgoing = Outgoing;
/**
 * Error messages
 */
var ErrorMessages;
(function (ErrorMessages) {
    ErrorMessages.REGISTERCLIENTCAPABILITIES_TIMEOUT = 'Failed to register client capabilities in time';
    ErrorMessages.SHUTDOWN_TIMEOUT = 'Failed to shutdown in time';
    ErrorMessages.DISCONNECTCLIENT_TIMEOUT = 'Failed to disconnect client in time';
    ErrorMessages.GETDISCOVERYPATHS_TIMEOUT = 'Failed to get discovery paths in time';
    ErrorMessages.FINDSERVERBEANS_TIMEOUT = 'Failed to find server beans in time';
    ErrorMessages.ADDDISCOVERYPATH_TIMEOUT = 'Failed to add discovery path in time';
    ErrorMessages.REMOVEDISCOVERYPATH_TIMEOUT = 'Failed to remove discovery path in time';
    ErrorMessages.GETSERVERHANDLES_TIMEOUT = 'Failed to get server handles in time';
    ErrorMessages.GETSERVERTYPES_TIMEOUT = 'Failed to get server types in time';
    ErrorMessages.DELETESERVER_TIMEOUT = 'Failed to delete server in time';
    ErrorMessages.GETREQUIREDATTRIBUTES_TIMEOUT = 'Failed to get required attributes in time';
    ErrorMessages.GETOPTIONALATTRIBUTES_TIMEOUT = 'Failed to get optional attributes in time';
    ErrorMessages.CREATESERVER_TIMEOUT = 'Failed to create server in time';
    ErrorMessages.CREATESERVERWORKFLOW_TIMEOUT = 'Failed to create server workflow in time';
    ErrorMessages.GETSERVERASJSON_TIMEOUT = 'Failed to get server as json in time';
    ErrorMessages.UPDATESERVER_TIMEOUT = 'Failed to update server in time';
    ErrorMessages.GETLAUNCHMODES_TIMEOUT = 'Failed to get launch modes in time';
    ErrorMessages.GETREQUIREDLAUNCHATTRIBUTES_TIMEOUT = 'Failed to get required launch attributes in time';
    ErrorMessages.GETOPTIONALLAUNCHATTRIBUTES_TIMEOUT = 'Failed to get optional launch attributes in time';
    ErrorMessages.GETLAUNCHCOMMAND_TIMEOUT = 'Failed to get launch command in time';
    ErrorMessages.SERVERSTARTINGBYCLIENT_TIMEOUT = 'Failed to server starting by client in time';
    ErrorMessages.SERVERSTARTEDBYCLIENT_TIMEOUT = 'Failed to server started by client in time';
    ErrorMessages.GETSERVERSTATE_TIMEOUT = 'Failed to get server state in time';
    ErrorMessages.STARTSERVERASYNC_TIMEOUT = 'Failed to start server async in time';
    ErrorMessages.STOPSERVERASYNC_TIMEOUT = 'Failed to stop server async in time';
    ErrorMessages.GETDEPLOYABLES_TIMEOUT = 'Failed to get deployables in time';
    ErrorMessages.LISTDEPLOYMENTOPTIONS_TIMEOUT = 'Failed to list deployment options in time';
    ErrorMessages.ADDDEPLOYABLE_TIMEOUT = 'Failed to add deployable in time';
    ErrorMessages.REMOVEDEPLOYABLE_TIMEOUT = 'Failed to remove deployable in time';
    ErrorMessages.PUBLISH_TIMEOUT = 'Failed to publish in time';
    ErrorMessages.PUBLISHASYNC_TIMEOUT = 'Failed to publish async in time';
    ErrorMessages.LISTDOWNLOADABLERUNTIMES_TIMEOUT = 'Failed to list downloadable runtimes in time';
    ErrorMessages.DOWNLOADRUNTIME_TIMEOUT = 'Failed to download runtime in time';
    ErrorMessages.LISTSERVERACTIONS_TIMEOUT = 'Failed to list server actions in time';
    ErrorMessages.EXECUTESERVERACTION_TIMEOUT = 'Failed to execute server action in time';
    ErrorMessages.GETJOBS_TIMEOUT = 'Failed to get jobs in time';
    ErrorMessages.CANCELJOB_TIMEOUT = 'Failed to cancel job in time';
})(ErrorMessages = exports.ErrorMessages || (exports.ErrorMessages = {}));
//# sourceMappingURL=outgoing.js.map