/**
 * Json objects sent between the server and the client
 */
export declare namespace Protocol {
    interface DownloadRuntimeDescription {
        name: string;
        id: string;
        version: string;
        url: string;
        licenseURL: string;
        humanUrl: string;
        disclaimer: boolean;
        properties: {
            [index: string]: string;
        };
        size: string;
        installationMethod: string;
    }
    interface DeployableState {
        server: ServerHandle;
        reference: DeployableReference;
        state: number;
        publishState: number;
    }
    interface CreateServerResponse {
        status: Status;
        invalidKeys: string[];
    }
    interface UpdateServerResponse {
        handle: ServerHandle;
        validation: CreateServerResponse;
        serverJson: GetServerJsonResponse;
    }
    interface ServerState {
        server: ServerHandle;
        state: number;
        publishState: number;
        runMode: string;
        deployableStates: DeployableState[];
    }
    interface ClientCapabilitiesRequest {
        map: {
            [index: string]: string;
        };
    }
    interface ServerStartingAttributes {
        initiatePolling: boolean;
        request: LaunchParameters;
    }
    interface PublishServerRequest {
        server: ServerHandle;
        kind: number;
    }
    interface UpdateServerRequest {
        handle: ServerHandle;
        serverJson: string;
    }
    interface Attribute {
        type: string;
        description: string;
        defaultVal: any;
        secret: boolean;
    }
    interface ServerCapabilitiesResponse {
        serverCapabilities: {
            [index: string]: string;
        };
        clientRegistrationStatus: Status;
    }
    interface ListDownloadRuntimeResponse {
        runtimes: DownloadRuntimeDescription[];
    }
    interface StartServerResponse {
        status: Status;
        details: CommandLineDetails;
    }
    interface ServerHandle {
        id: string;
        type: ServerType;
    }
    interface ServerBean {
        location: string;
        typeCategory: string;
        specificType: string;
        name: string;
        version: string;
        fullVersion: string;
        serverAdapterTypeId: string;
    }
    interface LaunchAttributesRequest {
        serverTypeId: string;
        mode: string;
    }
    interface WorkflowPromptDetails {
        responseType: string;
        responseSecret: boolean;
        validResponses: string[];
    }
    interface ServerType {
        id: string;
        visibleName: string;
        description: string;
    }
    interface ServerProcessOutput {
        server: ServerHandle;
        processId: string;
        streamType: number;
        text: string;
    }
    interface JobHandle {
        name: string;
        id: string;
    }
    interface ListDeployablesResponse {
        states: DeployableState[];
        status: Status;
    }
    interface WorkflowResponseItem {
        id: string;
        itemType: string;
        label: string;
        content: string;
        prompt: WorkflowPromptDetails;
        properties: {
            [index: string]: string;
        };
    }
    interface ListDeploymentOptionsResponse {
        attributes: Attributes;
        status: Status;
    }
    interface StopServerAttributes {
        id: string;
        force: boolean;
    }
    interface DeployableReference {
        label: string;
        path: string;
        options?: {
            [index: string]: any;
        };
    }
    interface WorkflowResponse {
        status: Status;
        requestId: number;
        jobId: string;
        items: WorkflowResponseItem[];
        invalidFields: string[];
    }
    interface ServerActionRequest {
        requestId: number;
        actionId: string;
        serverId: string;
        data: {
            [index: string]: any;
        };
    }
    interface LaunchParameters {
        mode: string;
        params: ServerAttributes;
    }
    interface Status {
        severity: number;
        plugin: string;
        code: number;
        message: string;
        trace: string;
        ok: boolean;
    }
    interface JobRemoved {
        status: Status;
        handle: JobHandle;
    }
    interface ServerProcess {
        server: ServerHandle;
        processId: string;
    }
    interface VMHandle {
        id: string;
    }
    interface ListServerActionResponse {
        workflows: ServerActionWorkflow[];
        status: Status;
    }
    interface ServerLaunchMode {
        mode: string;
        desc: string;
    }
    interface VMDescription {
        id: string;
        installLocation: string;
        version: string;
    }
    interface CommandLineDetails {
        cmdLine: string[];
        workingDir: string;
        envp: string[];
        properties: {
            [index: string]: string;
        };
    }
    interface CreateServerWorkflowRequest {
        requestId: number;
        serverTypeId: string;
        data: {
            [index: string]: any;
        };
    }
    interface ServerActionWorkflow {
        actionId: string;
        actionLabel: string;
        actionWorkflow: WorkflowResponse;
    }
    interface DiscoveryPath {
        filepath: string;
    }
    interface MessageBoxNotification {
        code: number;
        severity: number;
        message: string;
        properties: {
            [index: string]: any;
        };
    }
    interface GetServerJsonResponse {
        status: Status;
        serverJson: string;
        serverHandle: ServerHandle;
    }
    interface DownloadSingleRuntimeRequest {
        requestId: number;
        downloadRuntimeId: string;
        data: {
            [index: string]: any;
        };
    }
    interface JobProgress {
        percent: number;
        handle: JobHandle;
    }
    interface ServerDeployableReference {
        server: ServerHandle;
        deployableReference: DeployableReference;
    }
    interface StringPrompt {
        code: number;
        prompt: string;
        secret: boolean;
    }
    interface ServerAttributes {
        serverType: string;
        id: string;
        attributes: {
            [index: string]: any;
        };
    }
    interface Attributes {
        attributes: {
            [index: string]: Attribute;
        };
    }
}
