"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Server Connector extension ID.
 */
exports.SERVER_CONNECTOR_EXTENSION_ID = 'redhat.vscode-rsp-ui';
/**
 * Constants representing the state of the server itself or the state of publishing to the server
 */
var ServerState;
(function (ServerState) {
    /**
     * Server state constant (value 0) indicating that the
     * server is in an unknown state.
     */
    ServerState[ServerState["UNKNOWN"] = 0] = "UNKNOWN";
    /**
     * Server state constant (value 1) indicating that the
     * server is starting, but not yet ready to serve content.
     */
    ServerState[ServerState["STARTING"] = 1] = "STARTING";
    /**
     * Server state constant (value 2) indicating that the
     * server is ready to serve content.
     */
    ServerState[ServerState["STARTED"] = 2] = "STARTED";
    /**
     * Server state constant (value 3) indicating that the
     * server is shutting down.
     */
    ServerState[ServerState["STOPPING"] = 3] = "STOPPING";
    /**
     * Server state constant (value 4) indicating that the
     * server is stopped.
     */
    ServerState[ServerState["STOPPED"] = 4] = "STOPPED";
})(ServerState = exports.ServerState || (exports.ServerState = {}));
//# sourceMappingURL=constants.js.map