"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemCacheService = void 0;
const fs = __importStar(require("fs"));
const path_1 = __importDefault(require("path"));
class FileSystemCacheService {
    constructor(storagePath) {
        this.memCache = new Map();
        this.storagePath = storagePath;
        if (!fs.existsSync(storagePath)) {
            fs.mkdirSync(storagePath, { recursive: true });
        }
    }
    get(key) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.memCache.has(key)) {
                return Promise.resolve(this.memCache.get(key));
            }
            const value_1 = yield this.readFromFile(key);
            if (value_1) {
                this.memCache.set(key, value_1);
            }
            return value_1;
        });
    }
    put(key, value) {
        return __awaiter(this, void 0, void 0, function* () {
            this.memCache.set(key, value);
            yield this.writeToFile(key, value);
            return true;
        });
    }
    readFromFile(key) {
        const filePath = path_1.default.resolve(this.storagePath, `${key}.txt`);
        return new Promise((resolve, reject) => {
            if (!fs.existsSync(filePath)) {
                resolve(undefined);
                return;
            }
            fs.readFile(filePath, 'utf8', (err, data) => {
                if (err) {
                    resolve(undefined);
                    return;
                }
                resolve(data);
            });
        });
    }
    writeToFile(key, value) {
        const filePath = path_1.default.resolve(this.storagePath, `${key}.txt`);
        return new Promise((resolve, reject) => {
            fs.writeFile(filePath, value, (err) => {
                if (err) {
                    resolve(false);
                }
                resolve(true);
            });
        });
    }
}
exports.FileSystemCacheService = FileSystemCacheService;
//# sourceMappingURL=fileSystemCacheService.js.map